/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.util.ReflectHelper;

public class H2Dialect
extends Dialect {
    private String querySequenceString = "select sequence_name from information_schema.sequences";
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            String string;
            int n;
            String string2 = null;
            if (sQLException.getSQLState().startsWith("23") && (n = (string = sQLException.getMessage()).indexOf("violation: ")) > 0) {
                string2 = string.substring(n + "violation: ".length());
            }
            return string2;
        }
    };

    public H2Dialect() {
        try {
            Class clazz = ReflectHelper.classForName("org.h2.engine.Constants");
            Integer n = (Integer)clazz.getDeclaredField("BUILD_ID").get(null);
            int n2 = n;
            if (n2 < 32) {
                this.querySequenceString = "select name from information_schema.sequences";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(1, "char($l)");
        this.registerColumnType(91, "date");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(8, "double");
        this.registerColumnType(6, "float");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(7, "real");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-3, "binary($l)");
        this.registerColumnType(2, "numeric");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("atan2", new StandardSQLFunction("atan2", Hibernate.DOUBLE));
        this.registerFunction("bitand", new StandardSQLFunction("bitand", Hibernate.INTEGER));
        this.registerFunction("bitor", new StandardSQLFunction("bitor", Hibernate.INTEGER));
        this.registerFunction("bitxor", new StandardSQLFunction("bitxor", Hibernate.INTEGER));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("floor", new StandardSQLFunction("floor", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction("rand", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round", Hibernate.DOUBLE));
        this.registerFunction("roundmagic", new StandardSQLFunction("roundmagic", Hibernate.DOUBLE));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("truncate", new StandardSQLFunction("truncate", Hibernate.DOUBLE));
        this.registerFunction("compress", new StandardSQLFunction("compress", Hibernate.BINARY));
        this.registerFunction("expand", new StandardSQLFunction("compress", Hibernate.BINARY));
        this.registerFunction("decrypt", new StandardSQLFunction("decrypt", Hibernate.BINARY));
        this.registerFunction("encrypt", new StandardSQLFunction("encrypt", Hibernate.BINARY));
        this.registerFunction("hash", new StandardSQLFunction("hash", Hibernate.BINARY));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("char", new StandardSQLFunction("char", Hibernate.CHARACTER));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("difference", new StandardSQLFunction("difference", Hibernate.INTEGER));
        this.registerFunction("hextoraw", new StandardSQLFunction("hextoraw", Hibernate.STRING));
        this.registerFunction("lower", new StandardSQLFunction("lower", Hibernate.STRING));
        this.registerFunction("insert", new StandardSQLFunction("lower", Hibernate.STRING));
        this.registerFunction("left", new StandardSQLFunction("left", Hibernate.STRING));
        this.registerFunction("lcase", new StandardSQLFunction("lcase", Hibernate.STRING));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim", Hibernate.STRING));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", Hibernate.INTEGER));
        this.registerFunction("position", new StandardSQLFunction("position", Hibernate.INTEGER));
        this.registerFunction("rawtohex", new StandardSQLFunction("rawtohex", Hibernate.STRING));
        this.registerFunction("repeat", new StandardSQLFunction("repeat", Hibernate.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", Hibernate.STRING));
        this.registerFunction("right", new StandardSQLFunction("right", Hibernate.STRING));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim", Hibernate.STRING));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("stringencode", new StandardSQLFunction("stringencode", Hibernate.STRING));
        this.registerFunction("stringdecode", new StandardSQLFunction("stringdecode", Hibernate.STRING));
        this.registerFunction("ucase", new StandardSQLFunction("ucase", Hibernate.STRING));
        this.registerFunction("stringtoutf8", new StandardSQLFunction("stringtoutf8", Hibernate.BINARY));
        this.registerFunction("utf8tostring", new StandardSQLFunction("utf8tostring", Hibernate.STRING));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE));
        this.registerFunction("current_time", new NoArgSQLFunction("current_time", Hibernate.TIME));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("datediff", new NoArgSQLFunction("datediff", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("quater", new StandardSQLFunction("quater", Hibernate.INTEGER));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("curdate", new NoArgSQLFunction("curdate", Hibernate.DATE));
        this.registerFunction("curtime", new NoArgSQLFunction("curtime", Hibernate.TIME));
        this.registerFunction("curtimestamp", new NoArgSQLFunction("curtimestamp", Hibernate.TIME));
        this.registerFunction("now", new NoArgSQLFunction("now", Hibernate.TIMESTAMP));
        this.registerFunction("database", new NoArgSQLFunction("database", Hibernate.STRING));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentityColumnString() {
        return "generated by default as identity";
    }

    public String getIdentitySelectString() {
        return "call identity()";
    }

    public String getIdentityInsertString() {
        return "null";
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String string, boolean bl) {
        return new StringBuffer(string.length() + 20).append(string).append(bl ? " limit ? offset ?" : " limit ?").toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    protected String getCreateSequenceString(String string) throws MappingException {
        return "create sequence " + string;
    }

    protected String getDropSequenceString(String string) throws MappingException {
        return "drop sequence " + string;
    }

    public String getSelectSequenceNextValString(String string) {
        return "next value for " + string;
    }

    public String getSequenceNextValString(String string) {
        return "call next value for " + string;
    }

    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    public boolean supportsSequences() {
        return true;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "create temporary table if not exists";
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }
}

