/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.ReflectHelper;

public class DialectFactory {
    private static final Map MAPPERS = new HashMap();

    public static Dialect buildDialect(Properties properties, String string, int n) throws HibernateException {
        String string2 = properties.getProperty("hibernate.dialect");
        if (string2 == null) {
            return DialectFactory.determineDialect(string, n);
        }
        return DialectFactory.buildDialect(string2);
    }

    public static Dialect determineDialect(String string, int n) {
        if (string == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set");
        }
        DatabaseDialectMapper databaseDialectMapper = (DatabaseDialectMapper)MAPPERS.get(string);
        if (databaseDialectMapper == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set for database: " + string);
        }
        String string2 = databaseDialectMapper.getDialectClass(n);
        return DialectFactory.buildDialect(string2);
    }

    public static Dialect buildDialect(String string) {
        try {
            return (Dialect)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + string);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate dialect class", exception);
        }
    }

    static {
        MAPPERS.put("HSQL Database Engine", new VersionInsensitiveMapper("org.hibernate.dialect.HSQLDialect"));
        MAPPERS.put("DB2/NT", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.hibernate.dialect.MySQLDialect"));
        MAPPERS.put("PostgreSQL", new VersionInsensitiveMapper("org.hibernate.dialect.PostgreSQLDialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Sybase SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SybaseDialect"));
        MAPPERS.put("Informix Dynamic Server", new VersionInsensitiveMapper("org.hibernate.dialect.InformixDialect"));
        MAPPERS.put("Apache Derby", new VersionInsensitiveMapper("org.hibernate.dialect.DerbyDialect"));
        MAPPERS.put("Oracle", new DatabaseDialectMapper(){

            public String getDialectClass(int n) {
                return n > 8 ? "org.hibernate.dialect.Oracle9Dialect" : "org.hibernate.dialect.OracleDialect";
            }
        });
    }

    public static interface DatabaseDialectMapper {
        public String getDialectClass(int var1);
    }

    public static class VersionInsensitiveMapper
    implements DatabaseDialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String string) {
            this.dialectClassName = string;
        }

        public String getDialectClass(int n) {
            return this.dialectClassName;
        }
    }
}

