/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.TypeNames;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.engine.Mapping;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLStateConverter;
import org.hibernate.exception.ViolatedConstraintNameExtracter;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.sql.ANSICaseFragment;
import org.hibernate.sql.ANSIJoinFragment;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class Dialect {
    private static final Log log = LogFactory.getLog((Class)Dialect.class);
    public static final String DEFAULT_BATCH_SIZE = "15";
    public static final String NO_BATCH = "0";
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final Map STANDARD_AGGREGATE_FUNCTIONS = new HashMap();
    private final TypeNames typeNames = new TypeNames();
    private final TypeNames hibernateTypeNames = new TypeNames();
    private final Properties properties = new Properties();
    private final Map sqlFunctions = new HashMap();
    private final Set sqlKeywords = new HashSet();
    private static final ViolatedConstraintNameExtracter EXTRACTER;

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
        this.sqlFunctions.putAll(STANDARD_AGGREGATE_FUNCTIONS);
        this.registerFunction("substring", new SQLFunctionTemplate(Hibernate.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", new SQLFunctionTemplate(Hibernate.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.INTEGER));
        this.registerFunction("bit_length", new StandardSQLFunction("bit_length", Hibernate.INTEGER));
        this.registerFunction("coalesce", new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", new StandardSQLFunction("nullif"));
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("cast", new CastFunction());
        this.registerFunction("extract", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(?1 ?2 ?3)"));
        this.registerFunction("second", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(second from ?1)"));
        this.registerFunction("minute", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(minute from ?1)"));
        this.registerFunction("hour", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(hour from ?1)"));
        this.registerFunction("day", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(day from ?1)"));
        this.registerFunction("month", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(month from ?1)"));
        this.registerFunction("year", new SQLFunctionTemplate(Hibernate.INTEGER, "extract(year from ?1)"));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as char)"));
        this.registerHibernateType(-5, Hibernate.BIG_INTEGER.getName());
        this.registerHibernateType(-2, Hibernate.BINARY.getName());
        this.registerHibernateType(-7, Hibernate.BOOLEAN.getName());
        this.registerHibernateType(1, Hibernate.CHARACTER.getName());
        this.registerHibernateType(91, Hibernate.DATE.getName());
        this.registerHibernateType(8, Hibernate.DOUBLE.getName());
        this.registerHibernateType(6, Hibernate.FLOAT.getName());
        this.registerHibernateType(4, Hibernate.INTEGER.getName());
        this.registerHibernateType(5, Hibernate.SHORT.getName());
        this.registerHibernateType(-6, Hibernate.BYTE.getName());
        this.registerHibernateType(92, Hibernate.TIME.getName());
        this.registerHibernateType(93, Hibernate.TIMESTAMP.getName());
        this.registerHibernateType(12, Hibernate.STRING.getName());
        this.registerHibernateType(-3, Hibernate.BINARY.getName());
        this.registerHibernateType(2, Hibernate.BIG_DECIMAL.getName());
        this.registerHibernateType(3, Hibernate.BIG_DECIMAL.getName());
        this.registerHibernateType(2004, Hibernate.BLOB.getName());
        this.registerHibernateType(2005, Hibernate.CLOB.getName());
    }

    public static Dialect getDialect() throws HibernateException {
        String string = Environment.getProperties().getProperty("hibernate.dialect");
        return Dialect.instantiateDialect(string);
    }

    public static Dialect getDialect(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.dialect");
        if (string == null) {
            return Dialect.getDialect();
        }
        return Dialect.instantiateDialect(string);
    }

    private static Dialect instantiateDialect(String string) throws HibernateException {
        if (string == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new HibernateException("Dialect class not found: " + string);
        }
        catch (Exception exception) {
            throw new HibernateException("Could not instantiate dialect class", exception);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int n) throws HibernateException {
        String string = this.typeNames.get(n);
        if (string == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + n);
        }
        return string;
    }

    public String getTypeName(int n, int n2, int n3, int n4) throws HibernateException {
        String string = this.typeNames.get(n, n2, n3, n4);
        if (string == null) {
            throw new HibernateException("No type mapping for java.sql.Types code: " + n + ", length: " + n2);
        }
        return string;
    }

    public String getCastTypeName(int n) {
        return this.getTypeName(n, 255, 19, 2);
    }

    protected void registerColumnType(int n, int n2, String string) {
        this.typeNames.put(n, n2, string);
    }

    protected void registerColumnType(int n, String string) {
        this.typeNames.put(n, string);
    }

    public String getHibernateTypeName(int n) throws HibernateException {
        String string = this.hibernateTypeNames.get(n);
        if (string == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + n);
        }
        return string;
    }

    public String getHibernateTypeName(int n, int n2, int n3, int n4) throws HibernateException {
        String string = this.hibernateTypeNames.get(n, n2, n3, n4);
        if (string == null) {
            throw new HibernateException("No Hibernate type mapping for java.sql.Types code: " + n + ", length: " + n2);
        }
        return string;
    }

    protected void registerHibernateType(int n, int n2, String string) {
        this.hibernateTypeNames.put(n, n2, string);
    }

    protected void registerHibernateType(int n, String string) {
        this.hibernateTypeNames.put(n, string);
    }

    protected void registerFunction(String string, SQLFunction sQLFunction) {
        this.sqlFunctions.put(string, sQLFunction);
    }

    public final Map getFunctions() {
        return this.sqlFunctions;
    }

    protected void registerKeyword(String string) {
        this.sqlKeywords.add(string);
    }

    public Set getKeywords() {
        return this.sqlKeywords;
    }

    public Class getNativeIdentifierGeneratorClass() {
        if (this.supportsIdentityColumns()) {
            return IdentityGenerator.class;
        }
        if (this.supportsSequences()) {
            return SequenceGenerator.class;
        }
        return TableHiLoGenerator.class;
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String appendIdentitySelectToInsert(String string) {
        return string;
    }

    public String getIdentitySelectString(String string, String string2, int n) throws MappingException {
        return this.getIdentitySelectString();
    }

    protected String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityColumnString(int n) throws MappingException {
        return this.getIdentityColumnString();
    }

    protected String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsPooledSequences() {
        return false;
    }

    public String getSequenceNextValString(String string) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getSelectSequenceNextValString(String string) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String[] getCreateSequenceStrings(String string) throws MappingException {
        return new String[]{this.getCreateSequenceString(string)};
    }

    public String[] getCreateSequenceStrings(String string, int n, int n2) throws MappingException {
        return new String[]{this.getCreateSequenceString(string, n, n2)};
    }

    protected String getCreateSequenceString(String string) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    protected String getCreateSequenceString(String string, int n, int n2) throws MappingException {
        if (this.supportsPooledSequences()) {
            return this.getCreateSequenceString(string) + " start with " + n + " increment by " + n2;
        }
        throw new MappingException("Dialect does not support pooled sequences");
    }

    public String[] getDropSequenceStrings(String string) throws MappingException {
        return new String[]{this.getDropSequenceString(string)};
    }

    protected String getDropSequenceString(String string) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getQuerySequencesString() {
        return null;
    }

    public String getSelectGUIDString() {
        throw new UnsupportedOperationException("dialect does not support GUIDs");
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String string, int n, int n2) {
        return this.getLimitString(string, n > 0);
    }

    protected String getLimitString(String string, boolean bl) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public String getForUpdateString(LockMode lockMode) {
        if (lockMode == LockMode.UPGRADE) {
            return this.getForUpdateString();
        }
        if (lockMode == LockMode.UPGRADE_NOWAIT) {
            return this.getForUpdateNowaitString();
        }
        if (lockMode == LockMode.FORCE) {
            return this.getForUpdateNowaitString();
        }
        return "";
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String string) {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString() {
        return this.getForUpdateString();
    }

    public String getForUpdateNowaitString(String string) {
        return this.getForUpdateString(string);
    }

    public String appendLockHint(LockMode lockMode, String string) {
        return string;
    }

    public String applyLocksToSql(String string, Map map, Map map2) {
        return string + new ForUpdateFragment(this, map, map2).toFragmentString();
    }

    public String getCreateTableString() {
        return "create table";
    }

    public String getCreateMultisetTableString() {
        return this.getCreateTableString();
    }

    public boolean supportsTemporaryTables() {
        return false;
    }

    public String generateTemporaryTableName(String string) {
        return "HT_" + string;
    }

    public String getCreateTemporaryTableString() {
        return "create table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "";
    }

    public Boolean performTemporaryTableDDLInIsolation() {
        return null;
    }

    public boolean dropTemporaryTableAfterUse() {
        return true;
    }

    public int registerResultSetOutParameter(CallableStatement callableStatement, int n) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public ResultSet getResultSet(CallableStatement callableStatement) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    public boolean supportsCurrentTimestampSelection() {
        return false;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSelectString() {
        throw new UnsupportedOperationException("Database not known to define a current timestamp function");
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "current_timestamp";
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new SQLStateConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public String getSelectClauseNullString(int n) {
        return "null";
    }

    public boolean supportsUnionAll() {
        return false;
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public String transformSelectString(String string) {
        return string;
    }

    public int getMaxAliasLength() {
        return 10;
    }

    public String toBooleanValueString(boolean bl) {
        return bl ? "1" : NO_BATCH;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final String quote(String string) {
        if (string.charAt(0) == '`') {
            return this.openQuote() + string.substring(1, string.length() - 1) + this.closeQuote();
        }
        return string;
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by Dialect");
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getTableTypeString() {
        return "";
    }

    public String getAddForeignKeyConstraintString(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(" add constraint ").append(string).append(" foreign key (").append(StringHelper.join(", ", stringArray)).append(") references ").append(string2);
        if (!bl) {
            stringBuffer.append(" (").append(StringHelper.join(", ", stringArray2)).append(')');
        }
        return stringBuffer.toString();
    }

    public String getAddPrimaryKeyConstraintString(String string) {
        return " add constraint " + string + " primary key ";
    }

    public boolean hasSelfReferentialForeignKeyBug() {
        return false;
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getTableComment(String string) {
        return "";
    }

    public String getColumnComment(String string) {
        return "";
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return true;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public boolean supportsEmptyInList() {
        return true;
    }

    public boolean areStringComparisonsCaseInsensitive() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    public boolean useInputStreamToInsertBlob() {
        return true;
    }

    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return true;
    }

    public boolean supportsCircularCascadeDeleteConstraints() {
        return true;
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return true;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return true;
    }

    public boolean supportsLobValueChangePropogation() {
        return true;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return true;
    }

    public boolean supportsSubqueryOnMutatingTable() {
        return true;
    }

    public boolean supportsExistsInSelect() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    public boolean supportsBindAsCallableArgument() {
        return true;
    }

    static {
        STANDARD_AGGREGATE_FUNCTIONS.put("count", new StandardSQLFunction("count"){

            public Type getReturnType(Type type, Mapping mapping) {
                return Hibernate.LONG;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("avg", new StandardSQLFunction("avg"){

            public Type getReturnType(Type type, Mapping mapping) throws QueryException {
                int[] nArray;
                try {
                    nArray = type.sqlTypes(mapping);
                }
                catch (MappingException mappingException) {
                    throw new QueryException(mappingException);
                }
                if (nArray.length != 1) {
                    throw new QueryException("multi-column type in avg()");
                }
                return Hibernate.DOUBLE;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("max", new StandardSQLFunction("max"));
        STANDARD_AGGREGATE_FUNCTIONS.put("min", new StandardSQLFunction("min"));
        STANDARD_AGGREGATE_FUNCTIONS.put("sum", new StandardSQLFunction("sum"){

            public Type getReturnType(Type type, Mapping mapping) {
                int[] nArray;
                try {
                    nArray = type.sqlTypes(mapping);
                }
                catch (MappingException mappingException) {
                    throw new QueryException(mappingException);
                }
                if (nArray.length != 1) {
                    throw new QueryException("multi-column type in sum()");
                }
                int n = nArray[0];
                if (type == Hibernate.BIG_INTEGER) {
                    return Hibernate.BIG_INTEGER;
                }
                if (type == Hibernate.BIG_DECIMAL) {
                    return Hibernate.BIG_DECIMAL;
                }
                if (type == Hibernate.LONG || type == Hibernate.SHORT || type == Hibernate.INTEGER) {
                    return Hibernate.LONG;
                }
                if (type == Hibernate.FLOAT || type == Hibernate.DOUBLE) {
                    return Hibernate.DOUBLE;
                }
                if (n == 2) {
                    return type;
                }
                if (n == 6 || n == 8 || n == 3 || n == 7) {
                    return Hibernate.DOUBLE;
                }
                if (n == -5 || n == 4 || n == 5 || n == -6) {
                    return Hibernate.LONG;
                }
                return type;
            }
        });
        EXTRACTER = new ViolatedConstraintNameExtracter(){

            public String extractConstraintName(SQLException sQLException) {
                return null;
            }
        };
    }
}

