/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.id.TableHiLoGenerator;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;
import org.hibernate.type.Type;

public class DerbyDialect
extends DB2Dialect {
    public DerbyDialect() {
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "||", ")"));
        this.registerFunction("trim", new DerbyTrimFunctionEmulation());
    }

    public String getIdentityColumnString() {
        return "not null generated always as identity";
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public Class getNativeIdentifierGeneratorClass() {
        return TableHiLoGenerator.class;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getQuerySequencesString() {
        return null;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }

    public static class DerbyTrimFunctionEmulation
    implements SQLFunction {
        private static final SQLFunction LEADING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( ?1 )");
        private static final SQLFunction TRAILING_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "rtrim( ?1 )");
        private static final SQLFunction BOTH_SPACE_TRIM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?1 ) )");
        private static final SQLFunction BOTH_SPACE_TRIM_FROM = new SQLFunctionTemplate(Hibernate.STRING, "ltrim( rtrim( ?2 ) )");

        public Type getReturnType(Type type, Mapping mapping) throws QueryException {
            return Hibernate.STRING;
        }

        public boolean hasArguments() {
            return true;
        }

        public boolean hasParenthesesIfNoArguments() {
            return false;
        }

        public String render(List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
            String string;
            String string2;
            if (list.size() == 1) {
                return BOTH_SPACE_TRIM.render(list, sessionFactoryImplementor);
            }
            if ("from".equalsIgnoreCase((String)list.get(0))) {
                return BOTH_SPACE_TRIM_FROM.render(list, sessionFactoryImplementor);
            }
            boolean bl = true;
            boolean bl2 = true;
            int n = 1;
            String string3 = (String)list.get(0);
            if ("leading".equalsIgnoreCase(string3)) {
                bl2 = false;
            } else if ("trailing".equalsIgnoreCase(string3)) {
                bl = false;
            } else if (!"both".equalsIgnoreCase(string3)) {
                n = 0;
            }
            String string4 = (String)list.get(n);
            if ("from".equalsIgnoreCase(string4)) {
                string2 = "' '";
                string = (String)list.get(n + 1);
            } else if (n + 1 >= list.size()) {
                string2 = "' '";
                string = string4;
            } else {
                string2 = string4;
                string = "from".equalsIgnoreCase((String)list.get(n + 1)) ? (String)list.get(n + 2) : (String)list.get(n + 1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(string2);
            if (string2.equals("' '")) {
                if (bl && bl2) {
                    return BOTH_SPACE_TRIM.render(arrayList, sessionFactoryImplementor);
                }
                if (bl) {
                    return LEADING_SPACE_TRIM.render(arrayList, sessionFactoryImplementor);
                }
                return TRAILING_SPACE_TRIM.render(arrayList, sessionFactoryImplementor);
            }
            throw new HibernateException("cannot specify trim character when using Derby as Derby does not support the ANSI trim function, not does it support a replace function to properly emmulate it");
        }
    }
}

