/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.criterion.BetweenExpression;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.EmptyExpression;
import org.hibernate.criterion.IdentifierEqExpression;
import org.hibernate.criterion.IlikeExpression;
import org.hibernate.criterion.InExpression;
import org.hibernate.criterion.LogicalExpression;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.criterion.NotEmptyExpression;
import org.hibernate.criterion.NotExpression;
import org.hibernate.criterion.NotNullExpression;
import org.hibernate.criterion.NullExpression;
import org.hibernate.criterion.PropertyExpression;
import org.hibernate.criterion.SQLCriterion;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.SizeExpression;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class Restrictions {
    Restrictions() {
    }

    public static Criterion idEq(Object object) {
        return new IdentifierEqExpression(object);
    }

    public static SimpleExpression eq(String string, Object object) {
        return new SimpleExpression(string, object, "=");
    }

    public static SimpleExpression ne(String string, Object object) {
        return new SimpleExpression(string, object, "<>");
    }

    public static SimpleExpression like(String string, Object object) {
        return new SimpleExpression(string, object, " like ");
    }

    public static SimpleExpression like(String string, String string2, MatchMode matchMode) {
        return new SimpleExpression(string, matchMode.toMatchString(string2), " like ");
    }

    public static Criterion ilike(String string, String string2, MatchMode matchMode) {
        return new IlikeExpression(string, string2, matchMode);
    }

    public static Criterion ilike(String string, Object object) {
        return new IlikeExpression(string, object);
    }

    public static SimpleExpression gt(String string, Object object) {
        return new SimpleExpression(string, object, ">");
    }

    public static SimpleExpression lt(String string, Object object) {
        return new SimpleExpression(string, object, "<");
    }

    public static SimpleExpression le(String string, Object object) {
        return new SimpleExpression(string, object, "<=");
    }

    public static SimpleExpression ge(String string, Object object) {
        return new SimpleExpression(string, object, ">=");
    }

    public static Criterion between(String string, Object object, Object object2) {
        return new BetweenExpression(string, object, object2);
    }

    public static Criterion in(String string, Object[] objectArray) {
        return new InExpression(string, objectArray);
    }

    public static Criterion in(String string, Collection collection) {
        return new InExpression(string, collection.toArray());
    }

    public static Criterion isNull(String string) {
        return new NullExpression(string);
    }

    public static PropertyExpression eqProperty(String string, String string2) {
        return new PropertyExpression(string, string2, "=");
    }

    public static PropertyExpression neProperty(String string, String string2) {
        return new PropertyExpression(string, string2, "<>");
    }

    public static PropertyExpression ltProperty(String string, String string2) {
        return new PropertyExpression(string, string2, "<");
    }

    public static PropertyExpression leProperty(String string, String string2) {
        return new PropertyExpression(string, string2, "<=");
    }

    public static PropertyExpression gtProperty(String string, String string2) {
        return new PropertyExpression(string, string2, ">");
    }

    public static PropertyExpression geProperty(String string, String string2) {
        return new PropertyExpression(string, string2, ">=");
    }

    public static Criterion isNotNull(String string) {
        return new NotNullExpression(string);
    }

    public static LogicalExpression and(Criterion criterion, Criterion criterion2) {
        return new LogicalExpression(criterion, criterion2, "and");
    }

    public static LogicalExpression or(Criterion criterion, Criterion criterion2) {
        return new LogicalExpression(criterion, criterion2, "or");
    }

    public static Criterion not(Criterion criterion) {
        return new NotExpression(criterion);
    }

    public static Criterion sqlRestriction(String string, Object[] objectArray, Type[] typeArray) {
        return new SQLCriterion(string, objectArray, typeArray);
    }

    public static Criterion sqlRestriction(String string, Object object, Type type) {
        return new SQLCriterion(string, new Object[]{object}, new Type[]{type});
    }

    public static Criterion sqlRestriction(String string) {
        return new SQLCriterion(string, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    public static Criterion allEq(Map map) {
        Conjunction conjunction = Restrictions.conjunction();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            conjunction.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
        }
        return conjunction;
    }

    public static Criterion isEmpty(String string) {
        return new EmptyExpression(string);
    }

    public static Criterion isNotEmpty(String string) {
        return new NotEmptyExpression(string);
    }

    public static Criterion sizeEq(String string, int n) {
        return new SizeExpression(string, n, "=");
    }

    public static Criterion sizeNe(String string, int n) {
        return new SizeExpression(string, n, "<>");
    }

    public static Criterion sizeGt(String string, int n) {
        return new SizeExpression(string, n, "<");
    }

    public static Criterion sizeLt(String string, int n) {
        return new SizeExpression(string, n, ">");
    }

    public static Criterion sizeGe(String string, int n) {
        return new SizeExpression(string, n, "<=");
    }

    public static Criterion sizeLe(String string, int n) {
        return new SizeExpression(string, n, ">=");
    }

    public static NaturalIdentifier naturalId() {
        return new NaturalIdentifier();
    }
}

