/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.SimpleProjection;
import org.hibernate.type.Type;

public class PropertyProjection
extends SimpleProjection {
    private String propertyName;
    private boolean grouped;

    protected PropertyProjection(String string, boolean bl) {
        this.propertyName = string;
        this.grouped = bl;
    }

    protected PropertyProjection(String string) {
        this(string, false);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return this.propertyName;
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new Type[]{criteriaQuery.getType(criteria, this.propertyName)};
    }

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        return criteriaQuery.getColumn(criteria, this.propertyName) + " as y" + n + '_';
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        if (!this.grouped) {
            return super.toGroupSqlString(criteria, criteriaQuery);
        }
        return criteriaQuery.getColumn(criteria, this.propertyName);
    }
}

