/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class ProjectionList
implements Projection {
    private List elements = new ArrayList();

    protected ProjectionList() {
    }

    public ProjectionList create() {
        return new ProjectionList();
    }

    public ProjectionList add(Projection projection) {
        this.elements.add(projection);
        return this;
    }

    public ProjectionList add(Projection projection, String string) {
        return this.add(Projections.alias(projection, string));
    }

    public Type[] getTypes(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        ArrayList arrayList = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] objectArray = this.getProjection(i).getTypes(criteria, criteriaQuery);
            ArrayHelper.addAll(arrayList, objectArray);
        }
        return ArrayHelper.toTypeArray(arrayList);
    }

    public String toSqlString(Criteria criteria, int n, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            Projection projection = this.getProjection(i);
            stringBuffer.append(projection.toSqlString(criteria, n, criteriaQuery));
            n += projection.getColumnAliases(n).length;
            if (i >= this.elements.size() - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String toGroupSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            Projection projection = this.getProjection(i);
            if (!projection.isGrouped()) continue;
            stringBuffer.append(projection.toGroupSqlString(criteria, criteriaQuery)).append(", ");
        }
        if (stringBuffer.length() > 2) {
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        return stringBuffer.toString();
    }

    public String[] getColumnAliases(int n) {
        ArrayList arrayList = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] objectArray = this.getProjection(i).getColumnAliases(n);
            ArrayHelper.addAll(arrayList, objectArray);
            n += objectArray.length;
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] getColumnAliases(String string, int n) {
        for (int i = 0; i < this.getLength(); ++i) {
            String[] stringArray = this.getProjection(i).getColumnAliases(string, n);
            if (stringArray != null) {
                return stringArray;
            }
            n += this.getProjection(i).getColumnAliases(n).length;
        }
        return null;
    }

    public Type[] getTypes(String string, Criteria criteria, CriteriaQuery criteriaQuery) {
        for (int i = 0; i < this.getLength(); ++i) {
            Type[] typeArray = this.getProjection(i).getTypes(string, criteria, criteriaQuery);
            if (typeArray == null) continue;
            return typeArray;
        }
        return null;
    }

    public String[] getAliases() {
        ArrayList arrayList = new ArrayList(this.getLength());
        for (int i = 0; i < this.getLength(); ++i) {
            Object[] objectArray = this.getProjection(i).getAliases();
            ArrayHelper.addAll(arrayList, objectArray);
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public Projection getProjection(int n) {
        return (Projection)this.elements.get(n);
    }

    public int getLength() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    public boolean isGrouped() {
        for (int i = 0; i < this.getLength(); ++i) {
            if (!this.getProjection(i).isGrouped()) continue;
            return true;
        }
        return false;
    }
}

