/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.criterion;

import java.io.Serializable;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class Order
implements Serializable {
    private boolean ascending;
    private boolean ignoreCase;
    private String propertyName;

    public String toString() {
        return this.propertyName + ' ' + (this.ascending ? "asc" : "desc");
    }

    public Order ignoreCase() {
        this.ignoreCase = true;
        return this;
    }

    protected Order(String string, boolean bl) {
        this.propertyName = string;
        this.ascending = bl;
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        String[] stringArray = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
        Type type = criteriaQuery.getTypeUsingProjection(criteria, this.propertyName);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            SessionFactoryImplementor sessionFactoryImplementor = criteriaQuery.getFactory();
            boolean bl2 = bl = this.ignoreCase && type.sqlTypes(sessionFactoryImplementor)[i] == 12;
            if (bl) {
                stringBuffer.append(sessionFactoryImplementor.getDialect().getLowercaseFunction()).append('(');
            }
            stringBuffer.append(stringArray[i]);
            if (bl) {
                stringBuffer.append(')');
            }
            stringBuffer.append(this.ascending ? " asc" : " desc");
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static Order asc(String string) {
        return new Order(string, true);
    }

    public static Order desc(String string) {
        return new Order(string, false);
    }
}

