/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.jdbc.JDBCContext;

public class ThreadLocalSessionContext
implements CurrentSessionContext {
    private static final Log log = LogFactory.getLog((Class)ThreadLocalSessionContext.class);
    private static final Class[] SESS_PROXY_INTERFACES = new Class[]{org.hibernate.classic.Session.class, SessionImplementor.class, JDBCContext.Context.class, EventSource.class};
    private static final ThreadLocal context = new ThreadLocal();
    protected final SessionFactoryImplementor factory;

    public ThreadLocalSessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public final org.hibernate.classic.Session currentSession() throws HibernateException {
        org.hibernate.classic.Session session = ThreadLocalSessionContext.existingSession(this.factory);
        if (session == null) {
            session = this.buildOrObtainSession();
            session.getTransaction().registerSynchronization(this.buildCleanupSynch());
            if (this.needsWrapping(session)) {
                session = this.wrap(session);
            }
            ThreadLocalSessionContext.doBind(session, this.factory);
        }
        return session;
    }

    private boolean needsWrapping(org.hibernate.classic.Session session) {
        return session != null && !Proxy.isProxyClass(session.getClass()) || Proxy.getInvocationHandler(session) != null && !(Proxy.getInvocationHandler(session) instanceof TransactionProtectionWrapper);
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    protected org.hibernate.classic.Session buildOrObtainSession() {
        return this.factory.openSession(null, this.isAutoFlushEnabled(), this.isAutoCloseEnabled(), this.getConnectionReleaseMode());
    }

    protected CleanupSynch buildCleanupSynch() {
        return new CleanupSynch(this.factory);
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return this.factory.getSettings().getConnectionReleaseMode();
    }

    protected org.hibernate.classic.Session wrap(org.hibernate.classic.Session session) {
        TransactionProtectionWrapper transactionProtectionWrapper = new TransactionProtectionWrapper(session);
        org.hibernate.classic.Session session2 = (org.hibernate.classic.Session)Proxy.newProxyInstance(org.hibernate.classic.Session.class.getClassLoader(), SESS_PROXY_INTERFACES, (InvocationHandler)transactionProtectionWrapper);
        transactionProtectionWrapper.setWrapped(session2);
        return session2;
    }

    public static void bind(Session session) {
        SessionFactory sessionFactory = session.getSessionFactory();
        ThreadLocalSessionContext.cleanupAnyOrphanedSession(sessionFactory);
        ThreadLocalSessionContext.doBind(session, sessionFactory);
    }

    private static void cleanupAnyOrphanedSession(SessionFactory sessionFactory) {
        org.hibernate.classic.Session session = ThreadLocalSessionContext.doUnbind(sessionFactory, false);
        if (session != null) {
            log.warn((Object)"Already session bound on call to bind(); make sure you clean up your sessions!");
            try {
                if (session.getTransaction() != null && session.getTransaction().isActive()) {
                    try {
                        session.getTransaction().rollback();
                    }
                    catch (Throwable throwable) {
                        log.debug((Object)"Unable to rollback transaction for orphaned session", throwable);
                    }
                }
                session.close();
            }
            catch (Throwable throwable) {
                log.debug((Object)"Unable to close orphaned session", throwable);
            }
        }
    }

    public static org.hibernate.classic.Session unbind(SessionFactory sessionFactory) {
        return ThreadLocalSessionContext.doUnbind(sessionFactory, true);
    }

    private static org.hibernate.classic.Session existingSession(SessionFactory sessionFactory) {
        Map map = ThreadLocalSessionContext.sessionMap();
        if (map == null) {
            return null;
        }
        return (org.hibernate.classic.Session)map.get(sessionFactory);
    }

    protected static Map sessionMap() {
        return (Map)context.get();
    }

    private static void doBind(Session session, SessionFactory sessionFactory) {
        HashMap<SessionFactory, Session> hashMap = ThreadLocalSessionContext.sessionMap();
        if (hashMap == null) {
            hashMap = new HashMap<SessionFactory, Session>();
            context.set(hashMap);
        }
        hashMap.put(sessionFactory, session);
    }

    private static org.hibernate.classic.Session doUnbind(SessionFactory sessionFactory, boolean bl) {
        Map map = ThreadLocalSessionContext.sessionMap();
        org.hibernate.classic.Session session = null;
        if (map != null) {
            session = (org.hibernate.classic.Session)map.remove(sessionFactory);
            if (bl && map.isEmpty()) {
                context.set(null);
            }
        }
        return session;
    }

    protected static class CleanupSynch
    implements Synchronization,
    Serializable {
        protected final SessionFactory factory;

        public CleanupSynch(SessionFactory sessionFactory) {
            this.factory = sessionFactory;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            ThreadLocalSessionContext.unbind(this.factory);
        }
    }

    private class TransactionProtectionWrapper
    implements InvocationHandler,
    Serializable {
        private final org.hibernate.classic.Session realSession;
        private org.hibernate.classic.Session wrappedSession;

        public TransactionProtectionWrapper(org.hibernate.classic.Session session) {
            this.realSession = session;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                if ("close".equals(method.getName())) {
                    ThreadLocalSessionContext.unbind(this.realSession.getSessionFactory());
                } else if (!("toString".equals(method.getName()) || "equals".equals(method.getName()) || "hashCode".equals(method.getName()) || "getStatistics".equals(method.getName()) || "isOpen".equals(method.getName()) || !this.realSession.isOpen() || this.realSession.getTransaction().isActive())) {
                    if ("beginTransaction".equals(method.getName()) || "getTransaction".equals(method.getName()) || "isTransactionInProgress".equals(method.getName()) || "setFlushMode".equals(method.getName()) || "getSessionFactory".equals(method.getName())) {
                        log.trace((Object)("allowing method [" + method.getName() + "] in non-transacted context"));
                    } else if (!"reconnect".equals(method.getName()) && !"disconnect".equals(method.getName())) {
                        throw new HibernateException(method.getName() + " is not valid without active transaction");
                    }
                }
                log.trace((Object)("allowing proxied method [" + method.getName() + "] to proceed to real session"));
                return method.invoke((Object)this.realSession, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)invocationTargetException.getTargetException();
                }
                throw invocationTargetException;
            }
        }

        public void setWrapped(org.hibernate.classic.Session session) {
            this.wrappedSession = session;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (ThreadLocalSessionContext.existingSession(ThreadLocalSessionContext.this.factory) == this.wrappedSession) {
                ThreadLocalSessionContext.unbind(ThreadLocalSessionContext.this.factory);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.realSession.getTransaction().registerSynchronization(ThreadLocalSessionContext.this.buildCleanupSynch());
            ThreadLocalSessionContext.doBind(this.wrappedSession, ThreadLocalSessionContext.this.factory);
        }
    }
}

