/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.context;

import java.util.Hashtable;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.classic.Session;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.util.JTAHelper;

public class JTASessionContext
implements CurrentSessionContext {
    private static final Log log = LogFactory.getLog((Class)JTASessionContext.class);
    protected final SessionFactoryImplementor factory;
    private transient Map currentSessionMap = new Hashtable();

    public JTASessionContext(SessionFactoryImplementor sessionFactoryImplementor) {
        this.factory = sessionFactoryImplementor;
    }

    public Session currentSession() throws HibernateException {
        TransactionManager transactionManager = this.factory.getTransactionManager();
        if (transactionManager == null) {
            throw new HibernateException("No TransactionManagerLookup specified");
        }
        Transaction transaction = null;
        try {
            transaction = transactionManager.getTransaction();
            if (transaction == null) {
                throw new HibernateException("Unable to locate current JTA transaction");
            }
            if (!JTAHelper.isInProgress(transaction.getStatus())) {
                throw new HibernateException("Current transaction is not in progress");
            }
        }
        catch (HibernateException hibernateException) {
            throw hibernateException;
        }
        catch (Throwable throwable) {
            throw new HibernateException("Problem locating/validating JTA transaction", throwable);
        }
        Session session = (Session)this.currentSessionMap.get(transaction);
        if (session == null) {
            session = this.buildOrObtainSession();
            try {
                transaction.registerSynchronization((Synchronization)this.buildCleanupSynch(transaction));
            }
            catch (Throwable throwable) {
                try {
                    session.close();
                }
                catch (Throwable throwable2) {
                    log.debug((Object)"Unable to release generated current-session on failed synch registration", throwable2);
                }
                throw new HibernateException("Unable to register cleanup Synchronization with TransactionManager");
            }
            this.currentSessionMap.put(transaction, session);
        }
        return session;
    }

    private CleanupSynch buildCleanupSynch(Transaction transaction) {
        return new CleanupSynch(transaction, this);
    }

    protected Session buildOrObtainSession() {
        return this.factory.openSession(null, this.isAutoFlushEnabled(), this.isAutoCloseEnabled(), this.getConnectionReleaseMode());
    }

    protected boolean isAutoCloseEnabled() {
        return true;
    }

    protected boolean isAutoFlushEnabled() {
        return true;
    }

    protected ConnectionReleaseMode getConnectionReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    protected static class CleanupSynch
    implements Synchronization {
        private Transaction txn;
        private JTASessionContext context;

        public CleanupSynch(Transaction transaction, JTASessionContext jTASessionContext) {
            this.txn = transaction;
            this.context = jTASessionContext;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int n) {
            this.context.currentSessionMap.remove(this.txn);
        }
    }
}

