/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class DriverManagerConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final ArrayList pool = new ArrayList();
    private int poolSize;
    private int checkedOut = 0;
    private boolean autocommit;
    private static final Log log = LogFactory.getLog((Class)DriverManagerConnectionProvider.class);

    public void configure(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.connection.driver_class");
        this.poolSize = PropertiesHelper.getInt("hibernate.connection.pool_size", properties, 20);
        log.info((Object)"Using Hibernate built-in connection pool (not for production use!)");
        log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", properties);
        log.info((Object)("autocommit mode: " + this.autocommit));
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", properties);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
        if (string == null) {
            log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ReflectHelper.classForName(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    String string2 = "JDBC Driver class not found: " + string;
                    log.fatal((Object)string2, (Throwable)classNotFoundException2);
                    throw new HibernateException(string2, classNotFoundException2);
                }
            }
        }
        this.url = properties.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String string3 = "JDBC URL was not specified by property hibernate.connection.url";
            log.fatal((Object)string3);
            throw new HibernateException(string3);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties(properties);
        log.info((Object)("using driver: " + string + " at URL: " + this.url));
        if (log.isDebugEnabled()) {
            log.info((Object)("connection properties: " + this.connectionProps));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("connection properties: " + PropertiesHelper.maskOut(this.connectionProps, "password")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("total checked-out connections: " + this.checkedOut));
        }
        Object object = this.pool;
        synchronized (object) {
            if (!this.pool.isEmpty()) {
                int n = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + n));
                    ++this.checkedOut;
                }
                Connection connection = (Connection)this.pool.remove(n);
                if (this.isolation != null) {
                    connection.setTransactionIsolation(this.isolation);
                }
                if (connection.getAutoCommit() != this.autocommit) {
                    connection.setAutoCommit(this.autocommit);
                }
                return connection;
            }
        }
        log.debug((Object)"opening new JDBC connection");
        object = DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            object.setTransactionIsolation(this.isolation);
        }
        if (object.getAutoCommit() != this.autocommit) {
            object.setAutoCommit(this.autocommit);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created connection to: " + this.url + ", Isolation Level: " + object.getTransactionIsolation()));
        }
        if (log.isTraceEnabled()) {
            ++this.checkedOut;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection connection) throws SQLException {
        if (log.isDebugEnabled()) {
            --this.checkedOut;
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            int n = this.pool.size();
            if (n < this.poolSize) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (n + 1)));
                }
                this.pool.add(connection);
                return;
            }
        }
        log.debug((Object)"closing JDBC connection");
        connection.close();
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        log.info((Object)("cleaning up connection pool: " + this.url));
        Iterator iterator = this.pool.iterator();
        while (iterator.hasNext()) {
            try {
                ((Connection)iterator.next()).close();
            }
            catch (SQLException sQLException) {
                log.warn((Object)"problem closing pooled connection", (Throwable)sQLException);
            }
        }
        this.pool.clear();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

