/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.NamingHelper;

public class DatasourceConnectionProvider
implements ConnectionProvider {
    private DataSource ds;
    private String user;
    private String pass;
    private static final Log log = LogFactory.getLog((Class)DatasourceConnectionProvider.class);

    public DataSource getDataSource() {
        return this.ds;
    }

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public void configure(Properties properties) throws HibernateException {
        String string = properties.getProperty("hibernate.connection.datasource");
        if (string == null) {
            String string2 = "datasource JNDI name was not specified by property hibernate.connection.datasource";
            log.fatal((Object)string2);
            throw new HibernateException(string2);
        }
        this.user = properties.getProperty("hibernate.connection.username");
        this.pass = properties.getProperty("hibernate.connection.password");
        try {
            this.ds = (DataSource)NamingHelper.getInitialContext(properties).lookup(string);
        }
        catch (Exception exception) {
            log.fatal((Object)("Could not find datasource: " + string), (Throwable)exception);
            throw new HibernateException("Could not find datasource", exception);
        }
        if (this.ds == null) {
            throw new HibernateException("Could not find datasource: " + string);
        }
        log.info((Object)("Using datasource: " + string));
    }

    public Connection getConnection() throws SQLException {
        if (this.user != null || this.pass != null) {
            return this.ds.getConnection(this.user, this.pass);
        }
        return this.ds.getConnection();
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void close() {
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

