/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.DatasourceConnectionProvider;
import org.hibernate.connection.DriverManagerConnectionProvider;
import org.hibernate.connection.ProxoolConnectionProvider;
import org.hibernate.connection.UserSuppliedConnectionProvider;
import org.hibernate.util.ReflectHelper;

public final class ConnectionProviderFactory {
    private static final Log log = LogFactory.getLog((Class)ConnectionProviderFactory.class);
    private static final Set SPECIAL_PROPERTIES = new HashSet();

    public static ConnectionProvider newConnectionProvider() throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
    }

    public static ConnectionProvider newConnectionProvider(Properties properties) throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(properties, null);
    }

    public static ConnectionProvider newConnectionProvider(Properties properties, Map map) throws HibernateException {
        ConnectionProvider connectionProvider;
        String string = properties.getProperty("hibernate.connection.provider_class");
        if (string != null) {
            try {
                log.info((Object)("Initializing connection provider: " + string));
                connectionProvider = (ConnectionProvider)ReflectHelper.classForName(string).newInstance();
            }
            catch (Exception exception) {
                log.fatal((Object)"Could not instantiate connection provider", (Throwable)exception);
                throw new HibernateException("Could not instantiate connection provider: " + string);
            }
        } else {
            connectionProvider = properties.getProperty("hibernate.connection.datasource") != null ? new DatasourceConnectionProvider() : (properties.getProperty("hibernate.c3p0.max_size") != null ? new C3P0ConnectionProvider() : (properties.getProperty("hibernate.proxool.xml") != null || properties.getProperty("hibernate.proxool.properties") != null || properties.getProperty("hibernate.proxool.existing_pool") != null ? new ProxoolConnectionProvider() : (properties.getProperty("hibernate.connection.url") != null ? new DriverManagerConnectionProvider() : new UserSuppliedConnectionProvider())));
        }
        if (map != null && map.size() != 0) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(connectionProvider.getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n = propertyDescriptorArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = propertyDescriptorArray[i].getName();
                    if (!map.containsKey(string2)) continue;
                    Method method = propertyDescriptorArray[i].getWriteMethod();
                    method.invoke((Object)connectionProvider, map.get(string2));
                }
            }
            catch (IntrospectionException introspectionException) {
                throw new HibernateException("Unable to inject objects into the conenction provider", introspectionException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new HibernateException("Unable to inject objects into the conenction provider", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new HibernateException("Unable to inject objects into the conenction provider", invocationTargetException);
            }
        }
        connectionProvider.configure(properties);
        return connectionProvider;
    }

    private ConnectionProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties getConnectionProperties(Properties properties) {
        String string;
        Iterator<Object> iterator = properties.keySet().iterator();
        Properties properties2 = new Properties();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.indexOf("hibernate.connection") <= -1 || SPECIAL_PROPERTIES.contains(string)) continue;
            properties2.setProperty(string.substring("hibernate.connection".length() + 1), properties.getProperty(string));
        }
        string = properties.getProperty("hibernate.connection.username");
        if (string != null) {
            properties2.setProperty("user", string);
        }
        return properties2;
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
    }
}

