/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class C3P0ConnectionProvider
implements ConnectionProvider {
    private static final Log log = LogFactory.getLog((Class)C3P0ConnectionProvider.class);
    private static final String C3P0_STYLE_MIN_POOL_SIZE = "c3p0.minPoolSize";
    private static final String C3P0_STYLE_MAX_POOL_SIZE = "c3p0.maxPoolSize";
    private static final String C3P0_STYLE_MAX_IDLE_TIME = "c3p0.maxIdleTime";
    private static final String C3P0_STYLE_MAX_STATEMENTS = "c3p0.maxStatements";
    private static final String C3P0_STYLE_ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    private static final String C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    private static final String C3P0_STYLE_TEST_CONNECTION_ON_CHECKOUT = "c3p0.testConnectionOnCheckout";
    private static final String C3P0_STYLE_INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    private DataSource ds;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        if (this.isolation != null) {
            connection.setTransactionIsolation(this.isolation);
        }
        if (connection.getAutoCommit() != this.autocommit) {
            connection.setAutoCommit(this.autocommit);
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public void configure(Properties properties) throws HibernateException {
        Object object;
        String string = properties.getProperty("hibernate.connection.driver_class");
        String string2 = properties.getProperty("hibernate.connection.url");
        Properties properties2 = ConnectionProviderFactory.getConnectionProperties(properties);
        log.info((Object)("C3P0 using driver: " + string + " at URL: " + string2));
        log.info((Object)("Connection properties: " + PropertiesHelper.maskOut(properties2, "password")));
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", properties);
        log.info((Object)("autocommit mode: " + this.autocommit));
        if (string == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ReflectHelper.classForName(string);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    String string3 = "JDBC Driver class not found: " + string;
                    log.fatal((Object)string3, (Throwable)classNotFoundException2);
                    throw new HibernateException(string3, classNotFoundException2);
                }
            }
        }
        try {
            Object object2;
            Object object3;
            object = PropertiesHelper.getInteger("hibernate.c3p0.min_size", properties);
            Integer n = PropertiesHelper.getInteger("hibernate.c3p0.max_size", properties);
            Integer n2 = PropertiesHelper.getInteger("hibernate.c3p0.timeout", properties);
            Integer n3 = PropertiesHelper.getInteger("hibernate.c3p0.max_statements", properties);
            Integer n4 = PropertiesHelper.getInteger("hibernate.c3p0.acquire_increment", properties);
            Integer n5 = PropertiesHelper.getInteger("hibernate.c3p0.idle_test_period", properties);
            Properties properties3 = new Properties();
            Object object4 = properties.keySet().iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                if (!((String)object3).startsWith("hibernate.c3p0.")) continue;
                object2 = ((String)object3).substring(10);
                if (properties.containsKey(object2)) {
                    this.warnPropertyConflict((String)object3, (String)object2);
                }
                properties3.put(object2, properties.get(object3));
            }
            this.setOverwriteProperty("hibernate.c3p0.min_size", C3P0_STYLE_MIN_POOL_SIZE, properties, properties3, (Integer)object);
            this.setOverwriteProperty("hibernate.c3p0.max_size", C3P0_STYLE_MAX_POOL_SIZE, properties, properties3, n);
            this.setOverwriteProperty("hibernate.c3p0.timeout", C3P0_STYLE_MAX_IDLE_TIME, properties, properties3, n2);
            this.setOverwriteProperty("hibernate.c3p0.max_statements", C3P0_STYLE_MAX_STATEMENTS, properties, properties3, n3);
            this.setOverwriteProperty("hibernate.c3p0.acquire_increment", C3P0_STYLE_ACQUIRE_INCREMENT, properties, properties3, n4);
            this.setOverwriteProperty("hibernate.c3p0.idle_test_period", C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD, properties, properties3, n5);
            object4 = PropertiesHelper.getInteger(C3P0_STYLE_INITIAL_POOL_SIZE, properties);
            if (object4 == null && object != null) {
                properties3.put(C3P0_STYLE_INITIAL_POOL_SIZE, String.valueOf(object).trim());
            }
            object3 = DataSources.unpooledDataSource((String)string2, (Properties)properties2);
            object2 = (Properties)properties.clone();
            ((Properties)object2).putAll((Map<?, ?>)properties3);
            this.ds = DataSources.pooledDataSource((DataSource)object3, (Properties)object2);
        }
        catch (Exception exception) {
            log.fatal((Object)"could not instantiate C3P0 connection pool", (Throwable)exception);
            throw new HibernateException("Could not instantiate C3P0 connection pool", exception);
        }
        object = properties.getProperty("hibernate.connection.isolation");
        if (object == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer((String)object);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    public void close() {
        try {
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException sQLException) {
            log.warn((Object)"could not destroy C3P0 connection pool", (Throwable)sQLException);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    private void setOverwriteProperty(String string, String string2, Properties properties, Properties properties2, Integer n) {
        if (n != null) {
            String string3;
            properties2.put(string2, String.valueOf(n).trim());
            if (properties.getProperty(string2) != null) {
                this.warnPropertyConflict(string, string2);
            }
            if (properties.getProperty(string3 = "hibernate." + string2) != null) {
                this.warnPropertyConflict(string, string3);
            }
        }
    }

    private void warnPropertyConflict(String string, String string2) {
        log.warn((Object)("Both hibernate-style property '" + string + "' and c3p0-style property '" + string2 + "' have been set in hibernate.properties. " + "Hibernate-style property '" + string + "' will be used " + "and c3p0-style property '" + string2 + "' will be ignored!"));
    }
}

