/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentIndexedElementHolder;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentListElementHolder
extends PersistentIndexedElementHolder {
    public PersistentListElementHolder(SessionImplementor sessionImplementor, Element element) {
        super(sessionImplementor, element);
    }

    public PersistentListElementHolder(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) throws HibernateException {
        super(sessionImplementor, collectionPersister, serializable);
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Type type = collectionPersister.getElementType();
        String string = PersistentListElementHolder.getIndexAttributeName(collectionPersister);
        Serializable[] serializableArray = (Serializable[])serializable;
        for (int i = 0; i < serializableArray.length; ++i) {
            Object object2 = type.assemble(serializableArray[i], this.getSession(), object);
            Element element = this.element.addElement(collectionPersister.getElementNodeName());
            type.setToXMLNode((Node)element, object2, collectionPersister.getFactory());
            PersistentListElementHolder.setIndex(element, string, Integer.toString(i));
        }
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        String string = PersistentListElementHolder.getIndexAttributeName(collectionPersister);
        List list = this.element.elements(collectionPersister.getElementNodeName());
        int n = list.size();
        Serializable[] serializableArray = new Serializable[n];
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode((Node)element, collectionPersister.getFactory());
            Integer n2 = (Integer)Hibernate.INTEGER.fromStringValue(PersistentListElementHolder.getIndex(element, string, i));
            serializableArray[n2.intValue()] = type.disassemble(object, this.getSession(), null);
        }
        return serializableArray;
    }
}

