/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;

public abstract class PersistentIndexedElementHolder
extends AbstractPersistentCollection {
    protected Element element;

    public PersistentIndexedElementHolder(SessionImplementor sessionImplementor, Element element) {
        super(sessionImplementor);
        this.element = element;
        this.setInitialized();
    }

    protected static String getIndex(Element element, String string, int n) {
        if (string != null) {
            return element.attributeValue(string);
        }
        return Integer.toString(n);
    }

    protected static void setIndex(Element element, String string, String string2) {
        if (string != null) {
            element.addAttribute(string, string2);
        }
    }

    protected static String getIndexAttributeName(CollectionPersister collectionPersister) {
        String string = collectionPersister.getIndexNodeName();
        return string == null ? null : string.substring(1);
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        String string = PersistentIndexedElementHolder.getIndexAttributeName(collectionPersister);
        List list = this.element.elements(collectionPersister.getElementNodeName());
        HashMap<String, Object> hashMap = new HashMap<String, Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode((Node)element, collectionPersister.getFactory());
            Object object2 = type.deepCopy(object, this.getSession().getEntityMode(), collectionPersister.getFactory());
            hashMap.put(PersistentIndexedElementHolder.getIndex(element, string, i), object2);
        }
        return hashMap;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        return CollectionHelper.EMPTY_COLLECTION;
    }

    public PersistentIndexedElementHolder(SessionImplementor sessionImplementor, CollectionPersister collectionPersister, Serializable serializable) throws HibernateException {
        super(sessionImplementor);
        Element element = (Element)sessionImplementor.getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
        if (element == null) {
            throw new AssertionFailure("null owner");
        }
        String string = collectionPersister.getNodeName();
        if (".".equals(string)) {
            this.element = element;
        } else {
            this.element = element.element(string);
            if (this.element == null) {
                this.element = element.addElement(string);
            }
        }
    }

    public boolean isWrapper(Object object) {
        return this.element == object;
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        String string = PersistentIndexedElementHolder.getIndexAttributeName(collectionPersister);
        HashMap hashMap = (HashMap)this.getSnapshot();
        List list = this.element.elements(collectionPersister.getElementNodeName());
        if (hashMap.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < hashMap.size(); ++i) {
            Object object;
            Element element = (Element)list.get(i);
            Object v = hashMap.get(PersistentIndexedElementHolder.getIndex(element, string, i));
            if (!type.isDirty(v, object = type.fromXMLNode((Node)element, collectionPersister.getFactory()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((HashMap)serializable).isEmpty();
    }

    public boolean empty() {
        return !this.element.elementIterator().hasNext();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        Type type = collectionPersister.getElementType();
        SessionFactoryImplementor sessionFactoryImplementor = collectionPersister.getFactory();
        String string = PersistentIndexedElementHolder.getIndexAttributeName(collectionPersister);
        Element element = this.element.addElement(collectionPersister.getElementNodeName());
        type.setToXMLNode((Node)element, object2, sessionFactoryImplementor);
        Type type2 = collectionPersister.getIndexType();
        Object object3 = collectionPersister.readIndex(resultSet, collectionAliases.getSuffixedIndexAliases(), this.getSession());
        String string2 = ((NullableType)type2).toXMLString(object3, sessionFactoryImplementor);
        PersistentIndexedElementHolder.setIndex(element, string, string2);
        return object2;
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        Type type = collectionPersister.getElementType();
        String string = PersistentIndexedElementHolder.getIndexAttributeName(collectionPersister);
        List list = this.element.elements(collectionPersister.getElementNodeName());
        int n = list.size();
        ArrayList<IndexedValue> arrayList = new ArrayList<IndexedValue>(n);
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.get(i);
            Object object = type.fromXMLNode((Node)element, collectionPersister.getFactory());
            arrayList.add(new IndexedValue(PersistentIndexedElementHolder.getIndex(element, string, i), object));
        }
        return arrayList.iterator();
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public Object getValue() {
        return this.element;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        Type type = collectionPersister.getIndexType();
        HashMap hashMap = (HashMap)this.getSnapshot();
        HashMap hashMap2 = (HashMap)hashMap.clone();
        hashMap2.keySet().removeAll(((HashMap)this.getSnapshot(collectionPersister)).keySet());
        ArrayList arrayList = new ArrayList(hashMap2.size());
        Iterator iterator = hashMap2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object object = bl ? entry.getValue() : ((NullableType)type).fromXMLString((String)entry.getKey(), collectionPersister.getFactory());
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        HashMap hashMap = (HashMap)this.getSnapshot();
        IndexedValue indexedValue = (IndexedValue)object;
        return indexedValue.value != null && hashMap.get(indexedValue.index) == null;
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        HashMap hashMap = (HashMap)this.getSnapshot();
        IndexedValue indexedValue = (IndexedValue)object;
        Object v = hashMap.get(indexedValue.index);
        return v != null && type.isDirty(v, indexedValue.value, this.getSession());
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        String string = ((IndexedValue)object).index;
        Type type = collectionPersister.getIndexType();
        return ((NullableType)type).fromXMLString(string, collectionPersister.getFactory());
    }

    public Object getElement(Object object) {
        return ((IndexedValue)object).value;
    }

    public Object getSnapshotElement(Object object, int n) {
        return ((HashMap)this.getSnapshot()).get(((IndexedValue)object).index);
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }

    public static final class IndexedValue {
        String index;
        Object value;

        IndexedValue(String string, Object object) {
            this.index = string;
            this.value = object;
        }
    }
}

