/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentBag
extends AbstractPersistentCollection
implements List {
    protected List bag;

    public PersistentBag(SessionImplementor sessionImplementor) {
        super(sessionImplementor);
    }

    public PersistentBag(SessionImplementor sessionImplementor, Collection collection) {
        super(sessionImplementor);
        if (collection instanceof List) {
            this.bag = (List)collection;
        } else {
            this.bag = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.bag.add(iterator.next());
            }
        }
        this.setInitialized();
        this.setDirectlyAccessible(true);
    }

    public PersistentBag() {
    }

    public boolean isWrapper(Object object) {
        return this.bag == object;
    }

    public boolean empty() {
        return this.bag.isEmpty();
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.bag.iterator();
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        if (object2 != null) {
            this.bag.add(object2);
        }
        return object2;
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
        this.bag = (List)collectionPersister.getCollectionType().instantiate(n);
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        EntityMode entityMode = this.getSession().getEntityMode();
        List list = (List)((Object)this.getSnapshot());
        if (list.size() != this.bag.size()) {
            return false;
        }
        Iterator iterator = this.bag.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = this.countOccurrences(e, this.bag, type, entityMode) != this.countOccurrences(e, list, type, entityMode);
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return ((Collection)((Object)serializable)).isEmpty();
    }

    private int countOccurrences(Object object, List list, Type type, EntityMode entityMode) throws HibernateException {
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (!type.isSame(object, iterator.next(), entityMode)) continue;
            ++n;
        }
        return n;
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        ArrayList<Object> arrayList = new ArrayList<Object>(this.bag.size());
        Iterator iterator = this.bag.iterator();
        while (iterator.hasNext()) {
            arrayList.add(collectionPersister.getElementType().deepCopy(iterator.next(), entityMode, collectionPersister.getFactory()));
        }
        return arrayList;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        List list = (List)((Object)serializable);
        return PersistentBag.getOrphans(list, this.bag, string, this.getSession());
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        int n = this.bag.size();
        Serializable[] serializableArray = new Serializable[n];
        for (int i = 0; i < n; ++i) {
            serializableArray[i] = collectionPersister.getElementType().disassemble(this.bag.get(i), this.getSession(), null);
        }
        return serializableArray;
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        int n = serializableArray.length;
        this.beforeInitialize(collectionPersister, n);
        for (int i = 0; i < n; ++i) {
            Object object2 = collectionPersister.getElementType().assemble(serializableArray[i], this.getSession(), object);
            if (object2 == null) continue;
            this.bag.add(object2);
        }
    }

    public boolean needsRecreate(CollectionPersister collectionPersister) {
        return !collectionPersister.isOneToMany();
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        Type type = collectionPersister.getElementType();
        EntityMode entityMode = this.getSession().getEntityMode();
        ArrayList arrayList = new ArrayList();
        List list = (List)((Object)this.getSnapshot());
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Iterator iterator2 = this.bag.iterator();
            boolean bl2 = false;
            if (this.bag.size() > n && type.isSame(e, this.bag.get(n++), entityMode)) {
                bl2 = true;
            } else {
                while (iterator2.hasNext()) {
                    if (!type.isSame(e, iterator2.next(), entityMode)) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        List list = (List)((Object)this.getSnapshot());
        EntityMode entityMode = this.getSession().getEntityMode();
        if (list.size() > n && type.isSame(list.get(n), object, entityMode)) {
            return false;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!type.isSame(e, object, entityMode)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowUpdatePossible() {
        return false;
    }

    public boolean needsUpdating(Object object, int n, Type type) {
        return false;
    }

    public int size() {
        return this.readSize() ? this.getCachedSize() : this.bag.size();
    }

    public boolean isEmpty() {
        return this.readSize() ? this.getCachedSize() == 0 : this.bag.isEmpty();
    }

    public boolean contains(Object object) {
        Boolean bl = this.readElementExistence(object);
        return bl == null ? this.bag.contains(object) : bl.booleanValue();
    }

    public Iterator iterator() {
        this.read();
        return new AbstractPersistentCollection.IteratorProxy(this.bag.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.bag.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        this.read();
        return this.bag.toArray(objectArray);
    }

    public boolean add(Object object) {
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.add(object);
        }
        this.queueOperation(new SimpleAdd(object));
        return true;
    }

    public boolean remove(Object object) {
        this.initialize(true);
        if (this.bag.remove(object)) {
            this.dirty();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        this.read();
        return this.bag.containsAll(collection);
    }

    public boolean addAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        if (!this.isOperationQueueEnabled()) {
            this.write();
            return this.bag.addAll(collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.queueOperation(new SimpleAdd(iterator.next()));
        }
        return collection.size() > 0;
    }

    public boolean removeAll(Collection collection) {
        if (collection.size() > 0) {
            this.initialize(true);
            if (this.bag.removeAll(collection)) {
                this.dirty();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean retainAll(Collection collection) {
        this.initialize(true);
        if (this.bag.retainAll(collection)) {
            this.dirty();
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.isClearQueueEnabled()) {
            this.queueOperation(new Clear());
        } else {
            this.initialize(true);
            if (!this.bag.isEmpty()) {
                this.bag.clear();
                this.dirty();
            }
        }
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        throw new UnsupportedOperationException("Bags don't have indexes");
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        List list = (List)((Object)this.getSnapshot());
        return list.get(n);
    }

    public int occurrences(Object object) {
        this.read();
        Iterator iterator = this.bag.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            ++n;
        }
        return n;
    }

    public void add(int n, Object object) {
        this.write();
        this.bag.add(n, object);
    }

    public boolean addAll(int n, Collection collection) {
        if (collection.size() > 0) {
            this.write();
            return this.bag.addAll(n, collection);
        }
        return false;
    }

    public Object get(int n) {
        this.read();
        return this.bag.get(n);
    }

    public int indexOf(Object object) {
        this.read();
        return this.bag.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        this.read();
        return this.bag.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator());
    }

    public ListIterator listIterator(int n) {
        this.read();
        return new AbstractPersistentCollection.ListIteratorProxy(this.bag.listIterator(n));
    }

    public Object remove(int n) {
        this.write();
        return this.bag.remove(n);
    }

    public Object set(int n, Object object) {
        this.write();
        return this.bag.set(n, object);
    }

    public List subList(int n, int n2) {
        this.read();
        return new AbstractPersistentCollection.ListProxy(this.bag.subList(n, n2));
    }

    public String toString() {
        this.read();
        return this.bag.toString();
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    final class Clear
    implements AbstractPersistentCollection.DelayedOperation {
        Clear() {
        }

        public void operate() {
            PersistentBag.this.bag.clear();
        }

        public Object getAddedInstance() {
            return null;
        }

        public Object getOrphan() {
            throw new UnsupportedOperationException("queued clear cannot be used with orphan delete");
        }
    }

    final class SimpleAdd
    implements AbstractPersistentCollection.DelayedOperation {
        private Object value;

        public SimpleAdd(Object object) {
            this.value = object;
        }

        public void operate() {
            PersistentBag.this.bag.add(this.value);
        }

        public Object getAddedInstance() {
            return this.value;
        }

        public Object getOrphan() {
            return null;
        }
    }
}

