/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class PersistentArrayHolder
extends AbstractPersistentCollection {
    protected Object array;
    private static final Log log = LogFactory.getLog((Class)PersistentArrayHolder.class);
    private transient Class elementClass;
    private transient List tempList;

    public PersistentArrayHolder(SessionImplementor sessionImplementor, Object object) {
        super(sessionImplementor);
        this.array = object;
        this.setInitialized();
    }

    public Serializable getSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        EntityMode entityMode = this.getSession().getEntityMode();
        int n = Array.getLength(this.array);
        Serializable serializable = (Serializable)Array.newInstance(collectionPersister.getElementClass(), n);
        for (int i = 0; i < n; ++i) {
            Object object = Array.get(this.array, i);
            try {
                Array.set(serializable, i, collectionPersister.getElementType().deepCopy(object, entityMode, collectionPersister.getFactory()));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.error((Object)"Array element type error", (Throwable)illegalArgumentException);
                throw new HibernateException("Array element type error", illegalArgumentException);
            }
        }
        return serializable;
    }

    public boolean isSnapshotEmpty(Serializable serializable) {
        return Array.getLength(serializable) == 0;
    }

    public Collection getOrphans(Serializable serializable, String string) throws HibernateException {
        int n;
        Object[] objectArray = (Object[])serializable;
        Object[] objectArray2 = (Object[])this.array;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < objectArray.length; ++n) {
            arrayList.add(objectArray[n]);
        }
        for (n = 0; n < objectArray.length; ++n) {
            PersistentArrayHolder.identityRemove(arrayList, objectArray2[n], string, this.getSession());
        }
        return arrayList;
    }

    public PersistentArrayHolder(SessionImplementor sessionImplementor, CollectionPersister collectionPersister) throws HibernateException {
        super(sessionImplementor);
        this.elementClass = collectionPersister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean isWrapper(Object object) {
        return this.array == object;
    }

    public boolean equalsSnapshot(CollectionPersister collectionPersister) throws HibernateException {
        Type type = collectionPersister.getElementType();
        Serializable serializable = this.getSnapshot();
        int n = Array.getLength(serializable);
        if (n != Array.getLength(this.array)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (!type.isDirty(Array.get(serializable, i), Array.get(this.array, i), this.getSession())) continue;
            return false;
        }
        return true;
    }

    public Iterator elements() {
        int n = Array.getLength(this.array);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(Array.get(this.array, i));
        }
        return arrayList.iterator();
    }

    public boolean empty() {
        return false;
    }

    public Object readFrom(ResultSet resultSet, CollectionPersister collectionPersister, CollectionAliases collectionAliases, Object object) throws HibernateException, SQLException {
        Object object2 = collectionPersister.readElement(resultSet, object, collectionAliases.getSuffixedElementAliases(), this.getSession());
        int n = (Integer)collectionPersister.readIndex(resultSet, collectionAliases.getSuffixedIndexAliases(), this.getSession());
        for (int i = this.tempList.size(); i <= n; ++i) {
            this.tempList.add(i, null);
        }
        this.tempList.set(n, object2);
        return object2;
    }

    public Iterator entries(CollectionPersister collectionPersister) {
        return this.elements();
    }

    public void beginRead() {
        super.beginRead();
        this.tempList = new ArrayList();
    }

    public boolean endRead() {
        this.setInitialized();
        this.array = Array.newInstance(this.elementClass, this.tempList.size());
        for (int i = 0; i < this.tempList.size(); ++i) {
            Array.set(this.array, i, this.tempList.get(i));
        }
        this.tempList = null;
        return true;
    }

    public void beforeInitialize(CollectionPersister collectionPersister, int n) {
    }

    public boolean isDirectlyAccessible() {
        return true;
    }

    public void initializeFromCache(CollectionPersister collectionPersister, Serializable serializable, Object object) throws HibernateException {
        Serializable[] serializableArray = (Serializable[])serializable;
        this.array = Array.newInstance(collectionPersister.getElementClass(), serializableArray.length);
        for (int i = 0; i < serializableArray.length; ++i) {
            Array.set(this.array, i, collectionPersister.getElementType().assemble(serializableArray[i], this.getSession(), object));
        }
    }

    public Serializable disassemble(CollectionPersister collectionPersister) throws HibernateException {
        int n = Array.getLength(this.array);
        Serializable[] serializableArray = new Serializable[n];
        for (int i = 0; i < n; ++i) {
            serializableArray[i] = collectionPersister.getElementType().disassemble(Array.get(this.array, i), this.getSession(), null);
        }
        return serializableArray;
    }

    public Object getValue() {
        return this.array;
    }

    public Iterator getDeletes(CollectionPersister collectionPersister, boolean bl) throws HibernateException {
        int n;
        int n2;
        int n3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Serializable serializable = this.getSnapshot();
        int n4 = Array.getLength(serializable);
        if (n4 > (n3 = Array.getLength(this.array))) {
            for (n2 = n3; n2 < n4; ++n2) {
                arrayList.add(new Integer(n2));
            }
            n = n3;
        } else {
            n = n4;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (Array.get(this.array, n2) != null || Array.get(serializable, n2) == null) continue;
            arrayList.add(new Integer(n2));
        }
        return arrayList.iterator();
    }

    public boolean needsInserting(Object object, int n, Type type) throws HibernateException {
        Serializable serializable = this.getSnapshot();
        return Array.get(this.array, n) != null && (n >= Array.getLength(serializable) || Array.get(serializable, n) == null);
    }

    public boolean needsUpdating(Object object, int n, Type type) throws HibernateException {
        Serializable serializable = this.getSnapshot();
        return n < Array.getLength(serializable) && Array.get(serializable, n) != null && Array.get(this.array, n) != null && type.isDirty(Array.get(this.array, n), Array.get(serializable, n), this.getSession());
    }

    public Object getIndex(Object object, int n, CollectionPersister collectionPersister) {
        return new Integer(n);
    }

    public Object getElement(Object object) {
        return object;
    }

    public Object getSnapshotElement(Object object, int n) {
        Serializable serializable = this.getSnapshot();
        return Array.get(serializable, n);
    }

    public boolean entryExists(Object object, int n) {
        return object != null;
    }
}

