/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.cglib.BytecodeProviderImpl;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.NoCacheProvider;
import org.hibernate.cache.QueryCacheFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLExceptionConverterFactory;
import org.hibernate.hql.QueryTranslatorFactory;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.jdbc.BatchingBatcherFactory;
import org.hibernate.jdbc.NonBatchingBatcherFactory;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionFactoryFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class SettingsFactory
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)SettingsFactory.class);
    public static final String DEF_CACHE_PROVIDER = NoCacheProvider.class.getName();

    protected SettingsFactory() throws HibernateException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings(Properties properties) {
        SQLExceptionConverter sQLExceptionConverter;
        ConnectionReleaseMode connectionReleaseMode;
        Object object;
        Object object2;
        Object object3;
        Settings settings = new Settings();
        String string = properties.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(string);
        ConnectionProvider connectionProvider = this.createConnectionProvider(properties);
        settings.setConnectionProvider(connectionProvider);
        String string2 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = PropertiesHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", properties, true);
        if (bl6) {
            try {
                object3 = connectionProvider.getConnection();
                try {
                    object2 = object3.getMetaData();
                    string2 = object2.getDatabaseProductName();
                    n = this.getDatabaseMajorVersion((DatabaseMetaData)object2);
                    log.info((Object)("RDBMS: " + string2 + ", version: " + object2.getDatabaseProductVersion()));
                    log.info((Object)("JDBC driver: " + object2.getDriverName() + ", version: " + object2.getDriverVersion()));
                    bl = object2.supportsResultSetType(1004);
                    bl3 = object2.supportsBatchUpdates();
                    bl4 = object2.dataDefinitionCausesTransactionCommit();
                    boolean bl7 = bl5 = !object2.dataDefinitionIgnoredInTransactions();
                    if (Environment.jvmSupportsGetGeneratedKeys()) {
                        try {
                            object = (Boolean)DatabaseMetaData.class.getMethod("supportsGetGeneratedKeys", null).invoke(object2, null);
                            bl2 = (Boolean)object;
                        }
                        catch (AbstractMethodError abstractMethodError) {
                            bl2 = false;
                        }
                        catch (Exception exception) {
                            bl2 = false;
                        }
                    }
                }
                finally {
                    connectionProvider.closeConnection((Connection)object3);
                }
            }
            catch (SQLException sQLException) {
                log.warn((Object)"Could not obtain connection metadata", (Throwable)sQLException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        settings.setDataDefinitionImplicitCommit(bl4);
        settings.setDataDefinitionInTransactionSupported(bl5);
        object3 = this.determineDialect(properties, string2, n);
        settings.setDialect((Dialect)object3);
        object2 = new Properties();
        ((Properties)object2).putAll((Map<?, ?>)((Dialect)object3).getDefaultProperties());
        ((Properties)object2).putAll((Map<?, ?>)properties);
        object = this.createTransactionFactory((Properties)object2);
        settings.setTransactionFactory((TransactionFactory)object);
        settings.setTransactionManagerLookup(this.createTransactionManagerLookup((Properties)object2));
        boolean bl8 = PropertiesHelper.getBoolean("hibernate.transaction.flush_before_completion", (Properties)object2);
        log.info((Object)("Automatic flush during beforeCompletion(): " + SettingsFactory.enabledDisabled(bl8)));
        settings.setFlushBeforeCompletionEnabled(bl8);
        boolean bl9 = PropertiesHelper.getBoolean("hibernate.transaction.auto_close_session", (Properties)object2);
        log.info((Object)("Automatic session close at end of transaction: " + SettingsFactory.enabledDisabled(bl9)));
        settings.setAutoCloseSessionEnabled(bl9);
        int n2 = PropertiesHelper.getInt("hibernate.jdbc.batch_size", (Properties)object2, 0);
        if (!bl3) {
            n2 = 0;
        }
        if (n2 > 0) {
            log.info((Object)("JDBC batch size: " + n2));
        }
        settings.setJdbcBatchSize(n2);
        boolean bl10 = PropertiesHelper.getBoolean("hibernate.jdbc.batch_versioned_data", (Properties)object2, false);
        if (n2 > 0) {
            log.info((Object)("JDBC batch updates for versioned data: " + SettingsFactory.enabledDisabled(bl10)));
        }
        settings.setJdbcBatchVersionedData(bl10);
        settings.setBatcherFactory(this.createBatcherFactory((Properties)object2, n2));
        boolean bl11 = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", (Properties)object2, bl);
        log.info((Object)("Scrollable result sets: " + SettingsFactory.enabledDisabled(bl11)));
        settings.setScrollableResultSetsEnabled(bl11);
        boolean bl12 = PropertiesHelper.getBoolean("hibernate.jdbc.wrap_result_sets", (Properties)object2, false);
        log.debug((Object)("Wrap result sets: " + SettingsFactory.enabledDisabled(bl12)));
        settings.setWrapResultSetsEnabled(bl12);
        boolean bl13 = PropertiesHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", (Properties)object2, bl2);
        log.info((Object)("JDBC3 getGeneratedKeys(): " + SettingsFactory.enabledDisabled(bl13)));
        settings.setGetGeneratedKeysEnabled(bl13);
        Integer n3 = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", (Properties)object2);
        if (n3 != null) {
            log.info((Object)("JDBC result set fetch size: " + n3));
        }
        settings.setJdbcFetchSize(n3);
        String string3 = PropertiesHelper.getString("hibernate.connection.release_mode", (Properties)object2, "auto");
        log.info((Object)("Connection release mode: " + string3));
        if ("auto".equals(string3)) {
            connectionReleaseMode = object.getDefaultReleaseMode();
        } else {
            connectionReleaseMode = ConnectionReleaseMode.parse(string3);
            if (connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !connectionProvider.supportsAggressiveRelease()) {
                log.warn((Object)"Overriding release mode as connection provider does not support 'after_statement'");
                connectionReleaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
            }
        }
        settings.setConnectionReleaseMode(connectionReleaseMode);
        String string4 = ((Properties)object2).getProperty("hibernate.default_schema");
        String string5 = ((Properties)object2).getProperty("hibernate.default_catalog");
        if (string4 != null) {
            log.info((Object)("Default schema: " + string4));
        }
        if (string5 != null) {
            log.info((Object)("Default catalog: " + string5));
        }
        settings.setDefaultSchemaName(string4);
        settings.setDefaultCatalogName(string5);
        Integer n4 = PropertiesHelper.getInteger("hibernate.max_fetch_depth", (Properties)object2);
        if (n4 != null) {
            log.info((Object)("Maximum outer join fetch depth: " + n4));
        }
        settings.setMaximumFetchDepth(n4);
        int n5 = PropertiesHelper.getInt("hibernate.default_batch_fetch_size", (Properties)object2, 1);
        log.info((Object)("Default batch fetch size: " + n5));
        settings.setDefaultBatchFetchSize(n5);
        boolean bl14 = PropertiesHelper.getBoolean("hibernate.use_sql_comments", (Properties)object2);
        log.info((Object)("Generate SQL with comments: " + SettingsFactory.enabledDisabled(bl14)));
        settings.setCommentsEnabled(bl14);
        boolean bl15 = PropertiesHelper.getBoolean("hibernate.order_updates", (Properties)object2);
        log.info((Object)("Order SQL updates by primary key: " + SettingsFactory.enabledDisabled(bl15)));
        settings.setOrderUpdatesEnabled(bl15);
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory((Properties)object2));
        Map map = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", (Properties)object2);
        log.info((Object)("Query language substitutions: " + map));
        settings.setQuerySubstitutions(map);
        boolean bl16 = PropertiesHelper.getBoolean("hibernate.query.jpaql_strict_compliance", (Properties)object2, false);
        settings.setStrictJPAQLCompliance(bl16);
        log.info((Object)("JPA-QL strict compliance: " + SettingsFactory.enabledDisabled(bl16)));
        boolean bl17 = PropertiesHelper.getBoolean("hibernate.cache.use_second_level_cache", (Properties)object2, true);
        log.info((Object)("Second-level cache: " + SettingsFactory.enabledDisabled(bl17)));
        settings.setSecondLevelCacheEnabled(bl17);
        boolean bl18 = PropertiesHelper.getBoolean("hibernate.cache.use_query_cache", (Properties)object2);
        log.info((Object)("Query cache: " + SettingsFactory.enabledDisabled(bl18)));
        settings.setQueryCacheEnabled(bl18);
        if (bl17 || bl18) {
            settings.setCacheProvider(this.createCacheProvider((Properties)object2));
        } else {
            settings.setCacheProvider(new NoCacheProvider());
        }
        boolean bl19 = PropertiesHelper.getBoolean("hibernate.cache.use_minimal_puts", (Properties)object2, settings.getCacheProvider().isMinimalPutsEnabledByDefault());
        log.info((Object)("Optimize cache for minimal puts: " + SettingsFactory.enabledDisabled(bl19)));
        settings.setMinimalPutsEnabled(bl19);
        String string6 = ((Properties)object2).getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(string6)) {
            string6 = null;
        }
        if (string6 != null) {
            log.info((Object)("Cache region prefix: " + string6));
        }
        settings.setCacheRegionPrefix(string6);
        boolean bl20 = PropertiesHelper.getBoolean("hibernate.cache.use_structured_entries", (Properties)object2, false);
        log.info((Object)("Structured second-level cache entries: " + SettingsFactory.enabledDisabled(bl20)));
        settings.setStructuredCacheEntriesEnabled(bl20);
        if (bl18) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory((Properties)object2));
        }
        try {
            sQLExceptionConverter = SQLExceptionConverterFactory.buildSQLExceptionConverter((Dialect)object3, (Properties)object2);
        }
        catch (HibernateException hibernateException) {
            log.warn((Object)"Error building SQLExceptionConverter; using minimal converter");
            sQLExceptionConverter = SQLExceptionConverterFactory.buildMinimalSQLExceptionConverter();
        }
        settings.setSQLExceptionConverter(sQLExceptionConverter);
        boolean bl21 = PropertiesHelper.getBoolean("hibernate.show_sql", (Properties)object2);
        if (bl21) {
            log.info((Object)"Echoing all SQL to stdout");
        }
        settings.setShowSqlEnabled(bl21);
        boolean bl22 = PropertiesHelper.getBoolean("hibernate.format_sql", (Properties)object2);
        settings.setFormatSqlEnabled(bl22);
        boolean bl23 = PropertiesHelper.getBoolean("hibernate.generate_statistics", (Properties)object2);
        log.info((Object)("Statistics: " + SettingsFactory.enabledDisabled(bl23)));
        settings.setStatisticsEnabled(bl23);
        boolean bl24 = PropertiesHelper.getBoolean("hibernate.use_identifier_rollback", (Properties)object2);
        log.info((Object)("Deleted entity synthetic identifier rollback: " + SettingsFactory.enabledDisabled(bl24)));
        settings.setIdentifierRollbackEnabled(bl24);
        String string7 = ((Properties)object2).getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(string7)) {
            settings.setAutoValidateSchema(true);
        }
        if ("update".equals(string7)) {
            settings.setAutoUpdateSchema(true);
        }
        if ("create".equals(string7)) {
            settings.setAutoCreateSchema(true);
        }
        if ("create-drop".equals(string7)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        }
        EntityMode entityMode = EntityMode.parse(((Properties)object2).getProperty("hibernate.default_entity_mode"));
        log.info((Object)("Default entity-mode: " + entityMode));
        settings.setDefaultEntityMode(entityMode);
        boolean bl25 = PropertiesHelper.getBoolean("hibernate.query.startup_check", (Properties)object2, true);
        log.info((Object)("Named query checking : " + SettingsFactory.enabledDisabled(bl25)));
        settings.setNamedQueryStartupCheckingEnabled(bl25);
        return settings;
    }

    protected BytecodeProvider buildBytecodeProvider(String string) {
        if ("javassist".equals(string)) {
            return new org.hibernate.bytecode.javassist.BytecodeProviderImpl();
        }
        if ("cglib".equals(string)) {
            return new BytecodeProviderImpl();
        }
        log.debug((Object)"using cglib as bytecode provider by default");
        return new BytecodeProviderImpl();
    }

    private int getDatabaseMajorVersion(DatabaseMetaData databaseMetaData) {
        try {
            Method method = DatabaseMetaData.class.getMethod("getDatabaseMajorVersion", null);
            return (Integer)method.invoke((Object)databaseMetaData, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return 0;
        }
        catch (Throwable throwable) {
            log.debug((Object)"could not get database version from JDBC metadata");
            return 0;
        }
    }

    private static String enabledDisabled(boolean bl) {
        return bl ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.cache.query_cache_factory", properties, "org.hibernate.cache.StandardQueryCacheFactory");
        log.info((Object)("Query cache factory: " + string));
        try {
            return (QueryCacheFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + string, exception);
        }
    }

    protected CacheProvider createCacheProvider(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.cache.provider_class", properties, DEF_CACHE_PROVIDER);
        log.info((Object)("Cache provider: " + string));
        try {
            return (CacheProvider)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate CacheProvider: " + string, exception);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties) {
        String string = PropertiesHelper.getString("hibernate.query.factory_class", properties, "org.hibernate.hql.ast.ASTQueryTranslatorFactory");
        log.info((Object)("Query translator: " + string));
        try {
            return (QueryTranslatorFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + string, exception);
        }
    }

    protected BatcherFactory createBatcherFactory(Properties properties, int n) {
        String string = properties.getProperty("hibernate.jdbc.factory_class");
        if (string == null) {
            return n == 0 ? new NonBatchingBatcherFactory() : new BatchingBatcherFactory();
        }
        log.info((Object)("Batcher factory: " + string));
        try {
            return (BatcherFactory)ReflectHelper.classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new HibernateException("could not instantiate BatcherFactory: " + string, exception);
        }
    }

    protected ConnectionProvider createConnectionProvider(Properties properties) {
        return ConnectionProviderFactory.newConnectionProvider(properties);
    }

    protected TransactionFactory createTransactionFactory(Properties properties) {
        return TransactionFactoryFactory.buildTransactionFactory(properties);
    }

    protected TransactionManagerLookup createTransactionManagerLookup(Properties properties) {
        return TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
    }

    private Dialect determineDialect(Properties properties, String string, int n) {
        return DialectFactory.buildDialect(properties, string, n);
    }
}

