/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.DuplicateMappingException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.SecondPass;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.util.StringHelper;

public class Mappings
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)Mappings.class);
    protected final Map classes;
    protected final Map collections;
    protected final Map tables;
    protected final Map queries;
    protected final Map sqlqueries;
    protected final Map resultSetMappings;
    protected final Map typeDefs;
    protected final List secondPasses;
    protected final Map imports;
    protected String schemaName;
    protected String catalogName;
    protected String defaultCascade;
    protected String defaultPackage;
    protected String defaultAccess;
    protected boolean autoImport;
    protected boolean defaultLazy;
    protected final List propertyReferences;
    protected final NamingStrategy namingStrategy;
    protected final Map filterDefinitions;
    protected final List auxiliaryDatabaseObjects;
    protected final Map extendsQueue;
    protected final Map columnNameBindingPerTable;
    protected final Map tableNameBinding;

    Mappings(Map map, Map map2, Map map3, Map map4, Map map5, Map map6, Map map7, List list, List list2, NamingStrategy namingStrategy, Map map8, Map map9, Map map10, List list3, Map map11, Map map12) {
        this.classes = map;
        this.collections = map2;
        this.queries = map4;
        this.sqlqueries = map5;
        this.resultSetMappings = map6;
        this.tables = map3;
        this.imports = map7;
        this.secondPasses = list;
        this.propertyReferences = list2;
        this.namingStrategy = namingStrategy;
        this.typeDefs = map8;
        this.filterDefinitions = map9;
        this.extendsQueue = map10;
        this.auxiliaryDatabaseObjects = list3;
        this.tableNameBinding = map11;
        this.columnNameBindingPerTable = map12;
    }

    public void addClass(PersistentClass persistentClass) throws MappingException {
        PersistentClass persistentClass2 = this.classes.put(persistentClass.getEntityName(), persistentClass);
        if (persistentClass2 != null) {
            throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
        }
    }

    public void addCollection(Collection collection) throws MappingException {
        Collection collection2 = this.collections.put(collection.getRole(), collection);
        if (collection2 != null) {
            throw new DuplicateMappingException("collection role", collection.getRole());
        }
    }

    public PersistentClass getClass(String string) {
        return (PersistentClass)this.classes.get(string);
    }

    public Collection getCollection(String string) {
        return (Collection)this.collections.get(string);
    }

    public void addImport(String string, String string2) throws MappingException {
        String string3 = this.imports.put(string2, string);
        if (string3 != null) {
            if (string3.equals(string)) {
                log.info((Object)("duplicate import: " + string + "->" + string2));
            } else {
                throw new DuplicateMappingException("duplicate import: " + string2 + " refers to both " + string + " and " + string3 + " (try using auto-import=\"false\")", "import", string2);
            }
        }
    }

    public Table addTable(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
        Table table = (Table)this.tables.get(string5);
        if (table == null) {
            table = new Table();
            table.setAbstract(bl);
            table.setName(string3);
            table.setSchema(string);
            table.setCatalog(string2);
            table.setSubselect(string4);
            this.tables.put(string5, table);
        } else if (!bl) {
            table.setAbstract(false);
        }
        return table;
    }

    public Table addDenormalizedTable(String string, String string2, String string3, boolean bl, String string4, Table table) throws MappingException {
        String string5;
        String string6 = string5 = string4 == null ? Table.qualify(string2, string, string3) : string4;
        if (this.tables.containsKey(string5)) {
            throw new DuplicateMappingException("table", string3);
        }
        DenormalizedTable denormalizedTable = new DenormalizedTable(table);
        denormalizedTable.setAbstract(bl);
        denormalizedTable.setName(string3);
        denormalizedTable.setSchema(string);
        denormalizedTable.setCatalog(string2);
        denormalizedTable.setSubselect(string4);
        this.tables.put(string5, denormalizedTable);
        return denormalizedTable;
    }

    public Table getTable(String string, String string2, String string3) {
        String string4 = Table.qualify(string2, string, string3);
        return (Table)this.tables.get(string4);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getDefaultCascade() {
        return this.defaultCascade;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    public void setDefaultCascade(String string) {
        this.defaultCascade = string;
    }

    public void setDefaultAccess(String string) {
        this.defaultAccess = string;
    }

    public String getDefaultAccess() {
        return this.defaultAccess;
    }

    public void addQuery(String string, NamedQueryDefinition namedQueryDefinition) throws MappingException {
        this.checkQueryExist(string);
        this.queries.put(string.intern(), namedQueryDefinition);
    }

    public void addSQLQuery(String string, NamedSQLQueryDefinition namedSQLQueryDefinition) throws MappingException {
        this.checkQueryExist(string);
        this.sqlqueries.put(string.intern(), namedSQLQueryDefinition);
    }

    private void checkQueryExist(String string) throws MappingException {
        if (this.sqlqueries.containsKey(string) || this.queries.containsKey(string)) {
            throw new DuplicateMappingException("query", string);
        }
    }

    public void addResultSetMapping(ResultSetMappingDefinition resultSetMappingDefinition) {
        String string = resultSetMappingDefinition.getName();
        if (this.resultSetMappings.containsKey(string)) {
            throw new DuplicateMappingException("resultSet", string);
        }
        this.resultSetMappings.put(string, resultSetMappingDefinition);
    }

    public ResultSetMappingDefinition getResultSetMapping(String string) {
        return (ResultSetMappingDefinition)this.resultSetMappings.get(string);
    }

    public NamedQueryDefinition getQuery(String string) {
        return (NamedQueryDefinition)this.queries.get(string);
    }

    public void addSecondPass(SecondPass secondPass) {
        this.addSecondPass(secondPass, false);
    }

    public void addSecondPass(SecondPass secondPass, boolean bl) {
        if (bl) {
            this.secondPasses.add(0, secondPass);
        } else {
            this.secondPasses.add(secondPass);
        }
    }

    public boolean isAutoImport() {
        return this.autoImport;
    }

    public void setAutoImport(boolean bl) {
        this.autoImport = bl;
    }

    void addUniquePropertyReference(String string, String string2) {
        PropertyReference propertyReference = new PropertyReference();
        propertyReference.referencedClass = string;
        propertyReference.propertyName = string2;
        propertyReference.unique = true;
        this.propertyReferences.add(propertyReference);
    }

    void addPropertyReference(String string, String string2) {
        PropertyReference propertyReference = new PropertyReference();
        propertyReference.referencedClass = string;
        propertyReference.propertyName = string2;
        this.propertyReferences.add(propertyReference);
    }

    private String buildTableNameKey(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(".");
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(".");
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String string) {
        this.defaultPackage = string;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void addTypeDef(String string, String string2, Properties properties) {
        TypeDef typeDef = new TypeDef(string2, properties);
        this.typeDefs.put(string, typeDef);
        log.debug((Object)("Added " + string + " with class " + string2));
    }

    public TypeDef getTypeDef(String string) {
        return (TypeDef)this.typeDefs.get(string);
    }

    public Iterator iterateCollections() {
        return this.collections.values().iterator();
    }

    public Iterator iterateTables() {
        return this.tables.values().iterator();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
    }

    public FilterDefinition getFilterDefinition(String string) {
        return (FilterDefinition)this.filterDefinitions.get(string);
    }

    public boolean isDefaultLazy() {
        return this.defaultLazy;
    }

    public void setDefaultLazy(boolean bl) {
        this.defaultLazy = bl;
    }

    public void addToExtendsQueue(ExtendsQueueEntry extendsQueueEntry) {
        this.extendsQueue.put(extendsQueueEntry, null);
    }

    public PersistentClass locatePersistentClassByEntityName(String string) {
        String string2;
        PersistentClass persistentClass = (PersistentClass)this.classes.get(string);
        if (persistentClass == null && StringHelper.isNotEmpty(string2 = (String)this.imports.get(string))) {
            persistentClass = (PersistentClass)this.classes.get(string2);
        }
        return persistentClass;
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public void addTableBinding(String string, String string2, String string3, String string4, Table table) {
        TableDescription tableDescription;
        String string5 = this.buildTableNameKey(string, string2, string4);
        TableDescription tableDescription2 = this.tableNameBinding.put(string5, tableDescription = new TableDescription(string3, table));
        if (tableDescription2 != null && !tableDescription2.logicalName.equals(string3)) {
            throw new MappingException("Same physical table name reference several logical table names: " + string4 + " => " + "'" + tableDescription2.logicalName + "' and '" + string3 + "'");
        }
    }

    public void addColumnBinding(String string, Column column, Table table) {
        String string2;
        ColumnNames columnNames = (ColumnNames)this.columnNameBindingPerTable.get(table);
        if (columnNames == null) {
            columnNames = new ColumnNames();
            this.columnNameBindingPerTable.put(table, columnNames);
        }
        if ((string2 = columnNames.logicalToPhysical.put(string.toLowerCase(), column.getQuotedName())) != null && !(!column.isQuoted() ? string2.equalsIgnoreCase(column.getQuotedName()) : string2.equals(column.getQuotedName()))) {
            throw new MappingException("Same logical column name referenced by different physical ones: " + table.getName() + "." + string + " => '" + string2 + "' and '" + column.getQuotedName() + "'");
        }
        String string3 = columnNames.physicalToLogical.put(column.getQuotedName(), string);
        if (string3 != null && !string3.equals(string)) {
            throw new MappingException("Same physical column represented by different logical column names: " + table.getName() + "." + column.getQuotedName() + " => '" + string3 + "' and '" + string + "'");
        }
    }

    private String getLogicalTableName(String string, String string2, String string3) {
        String string4 = this.buildTableNameKey(string, string2, string3);
        TableDescription tableDescription = (TableDescription)this.tableNameBinding.get(string4);
        if (tableDescription == null) {
            throw new MappingException("Unable to find physical table: " + string3);
        }
        return tableDescription.logicalName;
    }

    public String getPhysicalColumnName(String string, Table table) {
        string = string.toLowerCase();
        String string2 = null;
        Table table2 = table;
        do {
            String string3;
            TableDescription tableDescription;
            ColumnNames columnNames;
            if ((columnNames = (ColumnNames)this.columnNameBindingPerTable.get(table2)) != null) {
                string2 = (String)columnNames.logicalToPhysical.get(string);
            }
            if ((tableDescription = (TableDescription)this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getSchema(), table2.getCatalog(), table2.getName()))) == null) continue;
            table2 = tableDescription.denormalizedSupertable;
        } while (string2 == null && table2 != null);
        if (string2 == null) {
            throw new MappingException("Unable to find column with logical name " + string + " in table " + table.getName());
        }
        return string2;
    }

    public String getLogicalColumnName(String string, Table table) {
        String string2 = null;
        Table table2 = table;
        TableDescription tableDescription = null;
        do {
            String string3;
            ColumnNames columnNames;
            if ((columnNames = (ColumnNames)this.columnNameBindingPerTable.get(table2)) != null) {
                string2 = (String)columnNames.physicalToLogical.get(string);
            }
            if ((tableDescription = (TableDescription)this.tableNameBinding.get(string3 = this.buildTableNameKey(table2.getSchema(), table2.getCatalog(), table2.getName()))) == null) continue;
            table2 = tableDescription.denormalizedSupertable;
        } while (string2 == null && table2 != null && tableDescription != null);
        if (string2 == null) {
            throw new MappingException("Unable to find logical column name from physical name " + string + " in table " + table.getName());
        }
        return string2;
    }

    public String getLogicalTableName(Table table) {
        return this.getLogicalTableName(table.getQuotedSchema(), table.getCatalog(), table.getQuotedName());
    }

    public static class ColumnNames
    implements Serializable {
        public Map logicalToPhysical = new HashMap();
        public Map physicalToLogical = new HashMap();
    }

    static final class PropertyReference
    implements Serializable {
        String referencedClass;
        String propertyName;
        boolean unique;

        PropertyReference() {
        }
    }

    public static class TableDescription
    implements Serializable {
        public String logicalName;
        public Table denormalizedSupertable;

        public TableDescription(String string, Table table) {
            this.logicalName = string;
            this.denormalizedSupertable = table;
        }
    }
}

