/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamedSQLQuerySecondPass;
import org.hibernate.cfg.ResultSetMappingSecondPass;
import org.hibernate.cfg.SecondPass;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleAuxiliaryDatabaseObject;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public final class HbmBinder {
    private static final Log log = LogFactory.getLog((Class)HbmBinder.class);

    private HbmBinder() {
    }

    public static void bindRoot(Document document, Mappings mappings, java.util.Map map) throws MappingException {
        java.util.List list = HbmBinder.getExtendsNeeded(document, mappings);
        if (!list.isEmpty()) {
            Element element = document.getRootElement();
            Attribute attribute = element.attribute("package");
            String string = null;
            if (attribute != null) {
                string = attribute.getValue();
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                mappings.addToExtendsQueue(new ExtendsQueueEntry(string2, string, document));
            }
            return;
        }
        Element element = document.getRootElement();
        map = HbmBinder.getMetas(element, map, true);
        HbmBinder.extractRootAttributes(element, mappings);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass;
            Element element2 = (Element)iterator.next();
            String string = element2.getName();
            if ("filter-def".equals(string)) {
                HbmBinder.parseFilterDef(element2, mappings);
                continue;
            }
            if ("typedef".equals(string)) {
                HbmBinder.bindTypeDef(element2, mappings);
                continue;
            }
            if ("class".equals(string)) {
                persistentClass = new RootClass();
                HbmBinder.bindRootClass(element2, persistentClass, mappings, map);
                mappings.addClass(persistentClass);
                continue;
            }
            if ("subclass".equals(string)) {
                persistentClass = HbmBinder.getSuperclass(mappings, element2);
                HbmBinder.handleSubclass(persistentClass, mappings, element2, map);
                continue;
            }
            if ("joined-subclass".equals(string)) {
                persistentClass = HbmBinder.getSuperclass(mappings, element2);
                HbmBinder.handleJoinedSubclass(persistentClass, mappings, element2, map);
                continue;
            }
            if ("union-subclass".equals(string)) {
                persistentClass = HbmBinder.getSuperclass(mappings, element2);
                HbmBinder.handleUnionSubclass(persistentClass, mappings, element2, map);
                continue;
            }
            if ("query".equals(string)) {
                HbmBinder.bindNamedQuery(element2, null, mappings);
                continue;
            }
            if ("sql-query".equals(string)) {
                HbmBinder.bindNamedSQLQuery(element2, null, mappings);
                continue;
            }
            if ("resultset".equals(string)) {
                HbmBinder.bindResultSetMappingDefinition(element2, null, mappings);
                continue;
            }
            if ("import".equals(string)) {
                HbmBinder.bindImport(element2, mappings);
                continue;
            }
            if (!"database-object".equals(string)) continue;
            HbmBinder.bindAuxiliaryDatabaseObject(element2, mappings);
        }
    }

    private static void bindImport(Element element, Mappings mappings) {
        String string = HbmBinder.getClassName(element.attribute("class"), mappings);
        Attribute attribute = element.attribute("rename");
        String string2 = attribute == null ? StringHelper.unqualify(string) : attribute.getValue();
        log.debug((Object)("Import: " + string2 + " -> " + string));
        mappings.addImport(string, string2);
    }

    private static void bindTypeDef(Element element, Mappings mappings) {
        String string = element.attributeValue("class");
        String string2 = element.attributeValue("name");
        Iterator iterator = element.elementIterator("param");
        Properties properties = new Properties();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            properties.setProperty(element2.attributeValue("name"), element2.getTextTrim());
        }
        mappings.addTypeDef(string2, string, properties);
    }

    private static void bindAuxiliaryDatabaseObject(Element element, Mappings mappings) {
        AuxiliaryDatabaseObject auxiliaryDatabaseObject = null;
        Element element2 = element.element("definition");
        if (element2 != null) {
            try {
                auxiliaryDatabaseObject = (AuxiliaryDatabaseObject)ReflectHelper.classForName(element2.attributeValue("class")).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MappingException("could not locate custom database object class [" + element2.attributeValue("class") + "]");
            }
            catch (Throwable throwable) {
                throw new MappingException("could not instantiate custom database object class [" + element2.attributeValue("class") + "]");
            }
        } else {
            auxiliaryDatabaseObject = new SimpleAuxiliaryDatabaseObject(element.elementTextTrim("create"), element.elementTextTrim("drop"));
        }
        Iterator iterator = element.elementIterator("dialect-scope");
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            auxiliaryDatabaseObject.addDialectScope(element3.attributeValue("name"));
        }
        mappings.addAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
    }

    private static void extractRootAttributes(Element element, Mappings mappings) {
        Attribute attribute = element.attribute("schema");
        mappings.setSchemaName(attribute == null ? null : attribute.getValue());
        Attribute attribute2 = element.attribute("catalog");
        mappings.setCatalogName(attribute2 == null ? null : attribute2.getValue());
        Attribute attribute3 = element.attribute("default-cascade");
        mappings.setDefaultCascade(attribute3 == null ? "none" : attribute3.getValue());
        Attribute attribute4 = element.attribute("default-access");
        mappings.setDefaultAccess(attribute4 == null ? "property" : attribute4.getValue());
        Attribute attribute5 = element.attribute("default-lazy");
        mappings.setDefaultLazy(attribute5 == null || attribute5.getValue().equals("true"));
        Attribute attribute6 = element.attribute("auto-import");
        mappings.setAutoImport(attribute6 == null || "true".equals(attribute6.getValue()));
        Attribute attribute7 = element.attribute("package");
        if (attribute7 != null) {
            mappings.setDefaultPackage(attribute7.getValue());
        }
    }

    public static void bindRootClass(Element element, RootClass rootClass, Mappings mappings, java.util.Map map) throws MappingException {
        HbmBinder.bindClass(element, rootClass, mappings, map);
        map = HbmBinder.getMetas(element, map, true);
        HbmBinder.bindRootPersistentClassCommonValues(element, map, mappings, rootClass);
    }

    private static void bindRootPersistentClassCommonValues(Element element, java.util.Map map, Mappings mappings, RootClass rootClass) throws MappingException {
        Attribute attribute;
        Attribute attribute2;
        Attribute attribute3 = element.attribute("schema");
        String string = attribute3 == null ? mappings.getSchemaName() : attribute3.getValue();
        Attribute attribute4 = element.attribute("catalog");
        String string2 = attribute4 == null ? mappings.getCatalogName() : attribute4.getValue();
        Table table = mappings.addTable(string, string2, HbmBinder.getClassTableName(rootClass, element, string, string2, null, mappings), HbmBinder.getSubselect(element), rootClass.isAbstract() != null && rootClass.isAbstract() != false);
        rootClass.setTable(table);
        HbmBinder.bindComment(table, element);
        log.info((Object)("Mapping class: " + rootClass.getEntityName() + " -> " + rootClass.getTable().getName()));
        Attribute attribute5 = element.attribute("mutable");
        rootClass.setMutable(attribute5 == null || attribute5.getValue().equals("true"));
        Attribute attribute6 = element.attribute("where");
        if (attribute6 != null) {
            rootClass.setWhere(attribute6.getValue());
        }
        if ((attribute2 = element.attribute("check")) != null) {
            table.addCheckConstraint(attribute2.getValue());
        }
        rootClass.setExplicitPolymorphism((attribute = element.attribute("polymorphism")) != null && attribute.getValue().equals("explicit"));
        Attribute attribute7 = element.attribute("rowid");
        if (attribute7 != null) {
            table.setRowId(attribute7.getValue());
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string3 = element2.getName();
            if ("id".equals(string3)) {
                HbmBinder.bindSimpleId(element2, rootClass, mappings, map);
                continue;
            }
            if ("composite-id".equals(string3)) {
                HbmBinder.bindCompositeId(element2, rootClass, mappings, map);
                continue;
            }
            if ("version".equals(string3) || "timestamp".equals(string3)) {
                HbmBinder.bindVersioningProperty(table, element2, mappings, string3, rootClass, map);
                continue;
            }
            if ("discriminator".equals(string3)) {
                HbmBinder.bindDiscriminatorProperty(table, rootClass, element2, mappings);
                continue;
            }
            if (!"cache".equals(string3)) continue;
            rootClass.setCacheConcurrencyStrategy(element2.attributeValue("usage"));
            rootClass.setCacheRegionName(element2.attributeValue("region"));
            rootClass.setLazyPropertiesCacheable(!"non-lazy".equals(element2.attributeValue("include")));
        }
        rootClass.createPrimaryKey();
        HbmBinder.createClassProperties(element, rootClass, mappings, map);
    }

    private static void bindSimpleId(Element element, RootClass rootClass, Mappings mappings, java.util.Map map) throws MappingException {
        String string = element.attributeValue("name");
        SimpleValue simpleValue = new SimpleValue(rootClass.getTable());
        rootClass.setIdentifier(simpleValue);
        if (string == null) {
            HbmBinder.bindSimpleValue(element, simpleValue, false, "id", mappings);
        } else {
            HbmBinder.bindSimpleValue(element, simpleValue, false, string, mappings);
        }
        if (string == null || !rootClass.hasPojoRepresentation()) {
            if (!simpleValue.isTypeSpecified()) {
                throw new MappingException("must specify an identifier type: " + rootClass.getEntityName());
            }
        } else {
            simpleValue.setTypeUsingReflection(rootClass.getClassName(), string);
        }
        if (string != null) {
            Property property = new Property();
            property.setValue(simpleValue);
            HbmBinder.bindProperty(element, property, mappings, map);
            rootClass.setIdentifierProperty(property);
        }
        HbmBinder.makeIdentifier(element, simpleValue, mappings);
    }

    private static void bindCompositeId(Element element, RootClass rootClass, Mappings mappings, java.util.Map map) throws MappingException {
        String string = element.attributeValue("name");
        Component component = new Component(rootClass);
        rootClass.setIdentifier(component);
        HbmBinder.bindCompositeId(element, component, rootClass, string, mappings, map);
        if (string == null) {
            rootClass.setEmbeddedIdentifier(component.isEmbedded());
            if (component.isEmbedded()) {
                component.setDynamic(!rootClass.hasPojoRepresentation());
            }
        } else {
            Property property = new Property();
            property.setValue(component);
            HbmBinder.bindProperty(element, property, mappings, map);
            rootClass.setIdentifierProperty(property);
        }
        HbmBinder.makeIdentifier(element, component, mappings);
    }

    private static void bindVersioningProperty(Table table, Element element, Mappings mappings, String string, RootClass rootClass, java.util.Map map) {
        String string2 = element.attributeValue("name");
        SimpleValue simpleValue = new SimpleValue(table);
        HbmBinder.bindSimpleValue(element, simpleValue, false, string2, mappings);
        if (!simpleValue.isTypeSpecified()) {
            if ("version".equals(string)) {
                simpleValue.setTypeName("integer");
            } else if ("db".equals(element.attributeValue("source"))) {
                simpleValue.setTypeName("dbtimestamp");
            } else {
                simpleValue.setTypeName("timestamp");
            }
        }
        Property property = new Property();
        property.setValue(simpleValue);
        HbmBinder.bindProperty(element, property, mappings, map);
        if (property.getGeneration() == PropertyGeneration.INSERT) {
            throw new MappingException("'generated' attribute cannot be 'insert' for versioning property");
        }
        HbmBinder.makeVersion(element, simpleValue);
        rootClass.setVersion(property);
        rootClass.addProperty(property);
    }

    private static void bindDiscriminatorProperty(Table table, RootClass rootClass, Element element, Mappings mappings) {
        SimpleValue simpleValue = new SimpleValue(table);
        rootClass.setDiscriminator(simpleValue);
        HbmBinder.bindSimpleValue(element, simpleValue, false, "class", mappings);
        if (!simpleValue.isTypeSpecified()) {
            simpleValue.setTypeName("string");
        }
        rootClass.setPolymorphic(true);
        if ("true".equals(element.attributeValue("force"))) {
            rootClass.setForceDiscriminator(true);
        }
        if ("false".equals(element.attributeValue("insert"))) {
            rootClass.setDiscriminatorInsertable(false);
        }
    }

    public static void bindClass(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute = element.attribute("lazy");
        boolean bl = attribute == null ? mappings.isDefaultLazy() : "true".equals(attribute.getValue());
        persistentClass.setLazy(bl);
        String string = element.attributeValue("entity-name");
        if (string == null) {
            string = HbmBinder.getClassName(element.attribute("name"), mappings);
        }
        if (string == null) {
            throw new MappingException("Unable to determine entity name");
        }
        persistentClass.setEntityName(string);
        HbmBinder.bindPojoRepresentation(element, persistentClass, mappings, map);
        HbmBinder.bindDom4jRepresentation(element, persistentClass, mappings, map);
        HbmBinder.bindMapRepresentation(element, persistentClass, mappings, map);
        HbmBinder.bindPersistentClassCommonValues(element, persistentClass, mappings, map);
    }

    private static void bindPojoRepresentation(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) {
        String string = HbmBinder.getClassName(element.attribute("name"), mappings);
        String string2 = HbmBinder.getClassName(element.attribute("proxy"), mappings);
        persistentClass.setClassName(string);
        if (string2 != null) {
            persistentClass.setProxyInterfaceName(string2);
            persistentClass.setLazy(true);
        } else if (persistentClass.isLazy()) {
            persistentClass.setProxyInterfaceName(string);
        }
        Element element2 = HbmBinder.locateTuplizerDefinition(element, EntityMode.POJO);
        if (element2 != null) {
            persistentClass.addTuplizer(EntityMode.POJO, element2.attributeValue("class"));
        }
    }

    private static void bindDom4jRepresentation(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) {
        String string = element.attributeValue("node");
        if (string == null) {
            string = StringHelper.unqualify(persistentClass.getEntityName());
        }
        persistentClass.setNodeName(string);
        Element element2 = HbmBinder.locateTuplizerDefinition(element, EntityMode.DOM4J);
        if (element2 != null) {
            persistentClass.addTuplizer(EntityMode.DOM4J, element2.attributeValue("class"));
        }
    }

    private static void bindMapRepresentation(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) {
        Element element2 = HbmBinder.locateTuplizerDefinition(element, EntityMode.MAP);
        if (element2 != null) {
            persistentClass.addTuplizer(EntityMode.MAP, element2.attributeValue("class"));
        }
    }

    private static Element locateTuplizerDefinition(Element element, EntityMode entityMode) {
        Iterator iterator = element.elements("tuplizer").iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!entityMode.toString().equals(element2.attributeValue("entity-mode"))) continue;
            return element2;
        }
        return null;
    }

    private static void bindPersistentClassCommonValues(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute;
        Attribute attribute2;
        Attribute attribute3 = element.attribute("discriminator-value");
        persistentClass.setDiscriminatorValue(attribute3 == null ? persistentClass.getEntityName() : attribute3.getValue());
        Attribute attribute4 = element.attribute("dynamic-update");
        persistentClass.setDynamicUpdate(attribute4 != null && "true".equals(attribute4.getValue()));
        Attribute attribute5 = element.attribute("dynamic-insert");
        persistentClass.setDynamicInsert(attribute5 != null && "true".equals(attribute5.getValue()));
        mappings.addImport(persistentClass.getEntityName(), persistentClass.getEntityName());
        if (mappings.isAutoImport() && persistentClass.getEntityName().indexOf(46) > 0) {
            mappings.addImport(persistentClass.getEntityName(), StringHelper.unqualify(persistentClass.getEntityName()));
        }
        if ((attribute2 = element.attribute("batch-size")) != null) {
            persistentClass.setBatchSize(Integer.parseInt(attribute2.getValue()));
        }
        if ((attribute = element.attribute("select-before-update")) != null) {
            persistentClass.setSelectBeforeUpdate("true".equals(attribute.getValue()));
        }
        Attribute attribute6 = element.attribute("optimistic-lock");
        persistentClass.setOptimisticLockMode(HbmBinder.getOptimisticLockMode(attribute6));
        persistentClass.setMetaAttributes(HbmBinder.getMetas(element, map));
        Attribute attribute7 = element.attribute("persister");
        if (attribute7 != null) {
            try {
                persistentClass.setEntityPersisterClass(ReflectHelper.classForName(attribute7.getValue()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MappingException("Could not find persister class: " + attribute7.getValue());
            }
        }
        HbmBinder.handleCustomSQL(element, persistentClass);
        Iterator iterator = element.elementIterator("synchronize");
        while (iterator.hasNext()) {
            persistentClass.addSynchronizedTable(((Element)iterator.next()).attributeValue("table"));
        }
        Attribute attribute8 = element.attribute("abstract");
        Boolean bl = attribute8 == null ? null : ("true".equals(attribute8.getValue()) ? Boolean.TRUE : ("false".equals(attribute8.getValue()) ? Boolean.FALSE : null));
        persistentClass.setAbstract(bl);
    }

    private static void handleCustomSQL(Element element, PersistentClass persistentClass) throws MappingException {
        boolean bl;
        Element element2 = element.element("sql-insert");
        if (element2 != null) {
            bl = HbmBinder.isCallable(element2);
            persistentClass.setCustomSQLInsert(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-delete")) != null) {
            bl = HbmBinder.isCallable(element2);
            persistentClass.setCustomSQLDelete(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-update")) != null) {
            bl = HbmBinder.isCallable(element2);
            persistentClass.setCustomSQLUpdate(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("loader")) != null) {
            persistentClass.setLoaderName(element2.attributeValue("query-ref"));
        }
    }

    private static void handleCustomSQL(Element element, Join join) throws MappingException {
        boolean bl;
        Element element2 = element.element("sql-insert");
        if (element2 != null) {
            bl = HbmBinder.isCallable(element2);
            join.setCustomSQLInsert(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-delete")) != null) {
            bl = HbmBinder.isCallable(element2);
            join.setCustomSQLDelete(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-update")) != null) {
            bl = HbmBinder.isCallable(element2);
            join.setCustomSQLUpdate(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
    }

    private static void handleCustomSQL(Element element, org.hibernate.mapping.Collection collection) throws MappingException {
        boolean bl;
        Element element2 = element.element("sql-insert");
        if (element2 != null) {
            bl = HbmBinder.isCallable(element2, true);
            collection.setCustomSQLInsert(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-delete")) != null) {
            bl = HbmBinder.isCallable(element2, true);
            collection.setCustomSQLDelete(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-update")) != null) {
            bl = HbmBinder.isCallable(element2, true);
            collection.setCustomSQLUpdate(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
        if ((element2 = element.element("sql-delete-all")) != null) {
            bl = HbmBinder.isCallable(element2, true);
            collection.setCustomSQLDeleteAll(element2.getTextTrim(), bl, HbmBinder.getResultCheckStyle(element2, bl));
        }
    }

    private static boolean isCallable(Element element) throws MappingException {
        return HbmBinder.isCallable(element, true);
    }

    private static boolean isCallable(Element element, boolean bl) throws MappingException {
        Attribute attribute = element.attribute("callable");
        if (attribute != null && "true".equals(attribute.getValue())) {
            if (!bl) {
                throw new MappingException("callable attribute not supported yet!");
            }
            return true;
        }
        return false;
    }

    private static ExecuteUpdateResultCheckStyle getResultCheckStyle(Element element, boolean bl) throws MappingException {
        Attribute attribute = element.attribute("check");
        if (attribute == null) {
            return ExecuteUpdateResultCheckStyle.COUNT;
        }
        return ExecuteUpdateResultCheckStyle.parse(attribute.getValue());
    }

    public static void bindUnionSubclass(Element element, UnionSubclass unionSubclass, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute;
        HbmBinder.bindClass(element, unionSubclass, mappings, map);
        map = HbmBinder.getMetas(element, map, true);
        if (unionSubclass.getEntityPersisterClass() == null) {
            unionSubclass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        String string = (attribute = element.attribute("schema")) == null ? mappings.getSchemaName() : attribute.getValue();
        Attribute attribute2 = element.attribute("catalog");
        String string2 = attribute2 == null ? mappings.getCatalogName() : attribute2.getValue();
        Table table = unionSubclass.getSuperclass().getTable();
        Table table2 = mappings.addDenormalizedTable(string, string2, HbmBinder.getClassTableName(unionSubclass, element, string, string2, table, mappings), unionSubclass.isAbstract() != null && unionSubclass.isAbstract() != false, HbmBinder.getSubselect(element), table);
        unionSubclass.setTable(table2);
        log.info((Object)("Mapping union-subclass: " + unionSubclass.getEntityName() + " -> " + unionSubclass.getTable().getName()));
        HbmBinder.createClassProperties(element, unionSubclass, mappings, map);
    }

    public static void bindSubclass(Element element, Subclass subclass, Mappings mappings, java.util.Map map) throws MappingException {
        HbmBinder.bindClass(element, subclass, mappings, map);
        map = HbmBinder.getMetas(element, map, true);
        if (subclass.getEntityPersisterClass() == null) {
            subclass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
        }
        log.info((Object)("Mapping subclass: " + subclass.getEntityName() + " -> " + subclass.getTable().getName()));
        HbmBinder.createClassProperties(element, subclass, mappings, map);
    }

    private static String getClassTableName(PersistentClass persistentClass, Element element, String string, String string2, Table table, Mappings mappings) {
        String string3;
        String string4;
        Attribute attribute = element.attribute("table");
        if (attribute == null) {
            string4 = StringHelper.unqualify(persistentClass.getEntityName());
            string3 = mappings.getNamingStrategy().classToTableName(persistentClass.getEntityName());
        } else {
            string4 = attribute.getValue();
            string3 = mappings.getNamingStrategy().tableName(string4);
        }
        mappings.addTableBinding(string, string2, string4, string3, table);
        return string3;
    }

    public static void bindJoinedSubclass(Element element, JoinedSubclass joinedSubclass, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute;
        HbmBinder.bindClass(element, joinedSubclass, mappings, map);
        map = HbmBinder.getMetas(element, map, true);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
        }
        String string = (attribute = element.attribute("schema")) == null ? mappings.getSchemaName() : attribute.getValue();
        Attribute attribute2 = element.attribute("catalog");
        String string2 = attribute2 == null ? mappings.getCatalogName() : attribute2.getValue();
        Table table = mappings.addTable(string, string2, HbmBinder.getClassTableName(joinedSubclass, element, string, string2, null, mappings), HbmBinder.getSubselect(element), false);
        joinedSubclass.setTable(table);
        HbmBinder.bindComment(table, element);
        log.info((Object)("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName()));
        Element element2 = element.element("key");
        DependantValue dependantValue = new DependantValue(table, joinedSubclass.getIdentifier());
        joinedSubclass.setKey(dependantValue);
        dependantValue.setCascadeDeleteEnabled("cascade".equals(element2.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(element2, dependantValue, false, joinedSubclass.getEntityName(), mappings);
        joinedSubclass.createPrimaryKey();
        joinedSubclass.createForeignKey();
        Attribute attribute3 = element.attribute("check");
        if (attribute3 != null) {
            table.addCheckConstraint(attribute3.getValue());
        }
        HbmBinder.createClassProperties(element, joinedSubclass, mappings, map);
    }

    private static void bindJoin(Element element, Join join, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute;
        Attribute attribute2;
        PersistentClass persistentClass = join.getPersistentClass();
        String string = persistentClass.getEntityName();
        Attribute attribute3 = element.attribute("schema");
        String string2 = attribute3 == null ? mappings.getSchemaName() : attribute3.getValue();
        Attribute attribute4 = element.attribute("catalog");
        String string3 = attribute4 == null ? mappings.getCatalogName() : attribute4.getValue();
        Table table = persistentClass.getTable();
        Table table2 = mappings.addTable(string2, string3, HbmBinder.getClassTableName(persistentClass, element, string2, string3, table, mappings), HbmBinder.getSubselect(element), false);
        join.setTable(table2);
        HbmBinder.bindComment(table2, element);
        Attribute attribute5 = element.attribute("fetch");
        if (attribute5 != null) {
            join.setSequentialSelect("select".equals(attribute5.getValue()));
        }
        if ((attribute2 = element.attribute("inverse")) != null) {
            join.setInverse("true".equals(attribute2.getValue()));
        }
        if ((attribute = element.attribute("optional")) != null) {
            join.setOptional("true".equals(attribute.getValue()));
        }
        log.info((Object)("Mapping class join: " + persistentClass.getEntityName() + " -> " + join.getTable().getName()));
        Element element2 = element.element("key");
        DependantValue dependantValue = new DependantValue(table2, persistentClass.getIdentifier());
        join.setKey(dependantValue);
        dependantValue.setCascadeDeleteEnabled("cascade".equals(element2.attributeValue("on-delete")));
        HbmBinder.bindSimpleValue(element2, dependantValue, false, persistentClass.getEntityName(), mappings);
        join.createPrimaryKey();
        join.createForeignKey();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Object object;
            Element element3 = (Element)iterator.next();
            String string4 = element3.getName();
            String string5 = element3.attributeValue("name");
            SimpleValue simpleValue = null;
            if ("many-to-one".equals(string4)) {
                simpleValue = new ManyToOne(table2);
                HbmBinder.bindManyToOne(element3, simpleValue, string5, true, mappings);
            } else if ("any".equals(string4)) {
                simpleValue = new Any(table2);
                HbmBinder.bindAny(element3, (Any)simpleValue, true, mappings);
            } else if ("property".equals(string4)) {
                simpleValue = new SimpleValue(table2);
                HbmBinder.bindSimpleValue(element3, simpleValue, true, string5, mappings);
            } else if ("component".equals(string4) || "dynamic-component".equals(string4)) {
                object = StringHelper.qualify(string, string5);
                simpleValue = new Component(join);
                HbmBinder.bindComponent(element3, (Component)simpleValue, join.getPersistentClass().getClassName(), string5, (String)object, true, false, mappings, map, false);
            }
            if (simpleValue == null) continue;
            object = HbmBinder.createProperty(simpleValue, string5, persistentClass.getEntityName(), element3, mappings, map);
            ((Property)object).setOptional(join.isOptional());
            join.addProperty((Property)object);
        }
        HbmBinder.handleCustomSQL(element, join);
    }

    public static void bindColumns(Element element, SimpleValue simpleValue, boolean bl, boolean bl2, String string, Mappings mappings) throws MappingException {
        Object object;
        Table table = simpleValue.getTable();
        Attribute attribute = element.attribute("column");
        if (attribute == null) {
            object = element.elementIterator();
            int n = 0;
            while (object.hasNext()) {
                Selectable selectable;
                Element element2 = (Element)object.next();
                if (element2.getName().equals("column")) {
                    selectable = new Column();
                    ((Column)selectable).setValue(simpleValue);
                    ((Column)selectable).setTypeIndex(n++);
                    HbmBinder.bindColumn(element2, (Column)selectable, bl);
                    String string2 = mappings.getNamingStrategy().logicalColumnName(element2.attributeValue("name"), string);
                    ((Column)selectable).setName(mappings.getNamingStrategy().columnName(string2));
                    if (table != null) {
                        table.addColumn((Column)selectable);
                        mappings.addColumnBinding(string2, (Column)selectable, table);
                    }
                    simpleValue.addColumn((Column)selectable);
                    HbmBinder.bindIndex(element2.attribute("index"), table, (Column)selectable, mappings);
                    HbmBinder.bindIndex(element.attribute("index"), table, (Column)selectable, mappings);
                    HbmBinder.bindUniqueKey(element2.attribute("unique-key"), table, (Column)selectable, mappings);
                    HbmBinder.bindUniqueKey(element.attribute("unique-key"), table, (Column)selectable, mappings);
                    continue;
                }
                if (!element2.getName().equals("formula")) continue;
                selectable = new Formula();
                ((Formula)selectable).setFormula(element2.getText());
                simpleValue.addFormula((Formula)selectable);
            }
        } else {
            if (element.elementIterator("column").hasNext()) {
                throw new MappingException("column attribute may not be used together with <column> subelement");
            }
            if (element.elementIterator("formula").hasNext()) {
                throw new MappingException("column attribute may not be used together with <formula> subelement");
            }
            object = new Column();
            ((Column)object).setValue(simpleValue);
            HbmBinder.bindColumn(element, (Column)object, bl);
            String string3 = mappings.getNamingStrategy().logicalColumnName(attribute.getValue(), string);
            ((Column)object).setName(mappings.getNamingStrategy().columnName(string3));
            if (table != null) {
                table.addColumn((Column)object);
                mappings.addColumnBinding(string3, (Column)object, table);
            }
            simpleValue.addColumn((Column)object);
            HbmBinder.bindIndex(element.attribute("index"), table, (Column)object, mappings);
            HbmBinder.bindUniqueKey(element.attribute("unique-key"), table, (Column)object, mappings);
        }
        if (bl2 && simpleValue.getColumnSpan() == 0) {
            object = new Column();
            ((Column)object).setValue(simpleValue);
            HbmBinder.bindColumn(element, (Column)object, bl);
            ((Column)object).setName(mappings.getNamingStrategy().propertyToColumnName(string));
            String string4 = mappings.getNamingStrategy().logicalColumnName(null, string);
            mappings.addColumnBinding(string4, (Column)object, table);
            simpleValue.getTable().addColumn((Column)object);
            simpleValue.addColumn((Column)object);
            HbmBinder.bindIndex(element.attribute("index"), table, (Column)object, mappings);
            HbmBinder.bindUniqueKey(element.attribute("unique-key"), table, (Column)object, mappings);
        }
    }

    private static void bindIndex(Attribute attribute, Table table, Column column, Mappings mappings) {
        if (attribute != null && table != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(attribute.getValue(), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                table.getOrCreateIndex(stringTokenizer.nextToken()).addColumn(column);
            }
        }
    }

    private static void bindUniqueKey(Attribute attribute, Table table, Column column, Mappings mappings) {
        if (attribute != null && table != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(attribute.getValue(), ", ");
            while (stringTokenizer.hasMoreTokens()) {
                table.getOrCreateUniqueKey(stringTokenizer.nextToken()).addColumn(column);
            }
        }
    }

    public static void bindSimpleValue(Element element, SimpleValue simpleValue, boolean bl, String string, Mappings mappings) throws MappingException {
        HbmBinder.bindSimpleValueType(element, simpleValue, mappings);
        HbmBinder.bindColumnsOrFormula(element, simpleValue, string, bl, mappings);
        Attribute attribute = element.attribute("foreign-key");
        if (attribute != null) {
            simpleValue.setForeignKeyName(attribute.getValue());
        }
    }

    private static void bindSimpleValueType(Element element, SimpleValue simpleValue, Mappings mappings) throws MappingException {
        Properties properties;
        Object object;
        String string = null;
        Properties properties2 = new Properties();
        Attribute attribute = element.attribute("type");
        if (attribute == null) {
            attribute = element.attribute("id-type");
        }
        if (attribute != null) {
            string = attribute.getValue();
        }
        Element element2 = element.element("type");
        if (string == null && element2 != null) {
            string = element2.attribute("name").getValue();
            object = element2.elementIterator("param");
            while (object.hasNext()) {
                properties = (Element)object.next();
                properties2.setProperty(properties.attributeValue("name"), properties.getTextTrim());
            }
        }
        if ((object = mappings.getTypeDef(string)) != null) {
            string = ((TypeDef)object).getTypeClass();
            properties = new Properties();
            properties.putAll((java.util.Map<?, ?>)((TypeDef)object).getParameters());
            properties.putAll((java.util.Map<?, ?>)properties2);
            properties2 = properties;
        }
        if (!properties2.isEmpty()) {
            simpleValue.setTypeParameters(properties2);
        }
        if (string != null) {
            simpleValue.setTypeName(string);
        }
    }

    public static void bindProperty(Element element, Property property, Mappings mappings, java.util.Map map) throws MappingException {
        Object object;
        boolean bl;
        String string = element.attributeValue("name");
        property.setName(string);
        String string2 = element.attributeValue("node");
        if (string2 == null) {
            string2 = string;
        }
        property.setNodeName(string2);
        Attribute attribute = element.attribute("access");
        if (attribute != null) {
            property.setPropertyAccessorName(attribute.getValue());
        } else if (element.getName().equals("properties")) {
            property.setPropertyAccessorName("embedded");
        } else {
            property.setPropertyAccessorName(mappings.getDefaultAccess());
        }
        Attribute attribute2 = element.attribute("cascade");
        property.setCascade(attribute2 == null ? mappings.getDefaultCascade() : attribute2.getValue());
        Attribute attribute3 = element.attribute("update");
        property.setUpdateable(attribute3 == null || "true".equals(attribute3.getValue()));
        Attribute attribute4 = element.attribute("insert");
        property.setInsertable(attribute4 == null || "true".equals(attribute4.getValue()));
        Attribute attribute5 = element.attribute("optimistic-lock");
        property.setOptimisticLocked(attribute5 == null || "true".equals(attribute5.getValue()));
        Attribute attribute6 = element.attribute("generated");
        String string3 = attribute6 == null ? null : attribute6.getValue();
        PropertyGeneration propertyGeneration = PropertyGeneration.parse(string3);
        property.setGeneration(propertyGeneration);
        if (propertyGeneration == PropertyGeneration.ALWAYS || propertyGeneration == PropertyGeneration.INSERT) {
            if (property.isInsertable()) {
                if (attribute4 == null) {
                    property.setInsertable(false);
                } else {
                    throw new MappingException("cannot specify both insert=\"true\" and generated=\"" + propertyGeneration.getName() + "\" for property: " + string);
                }
            }
            if (property.isUpdateable() && propertyGeneration == PropertyGeneration.ALWAYS) {
                if (attribute3 == null) {
                    property.setUpdateable(false);
                } else {
                    throw new MappingException("cannot specify both update=\"true\" and generated=\"" + propertyGeneration.getName() + "\" for property: " + string);
                }
            }
        }
        boolean bl2 = bl = "property".equals(element.getName()) || "component".equals(element.getName()) || "many-to-one".equals(element.getName()) || "one-to-one".equals(element.getName()) || "any".equals(element.getName());
        if (bl) {
            object = element.attribute("lazy");
            property.setLazy(object != null && "true".equals(object.getValue()));
        }
        if (log.isDebugEnabled()) {
            object = "Mapped property: " + property.getName();
            String string4 = HbmBinder.columns(property.getValue());
            if (string4.length() > 0) {
                object = (String)object + " -> " + string4;
            }
            log.debug(object);
        }
        property.setMetaAttributes(HbmBinder.getMetas(element, map));
    }

    private static String columns(Value value) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = value.getColumnIterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Selectable)iterator.next()).getText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public static void bindCollection(Element element, org.hibernate.mapping.Collection collection, String string, String string2, Mappings mappings, java.util.Map map) throws MappingException {
        Attribute attribute;
        Object object;
        Object object2;
        String string3;
        Object object3;
        Element element2;
        Attribute attribute2;
        String string4;
        Attribute attribute3;
        Attribute attribute4;
        Attribute attribute5;
        Attribute attribute6;
        collection.setRole(string2);
        Attribute attribute7 = element.attribute("inverse");
        if (attribute7 != null) {
            collection.setInverse("true".equals(attribute7.getValue()));
        }
        if ((attribute6 = element.attribute("mutable")) != null) {
            collection.setMutable(!"false".equals(attribute6.getValue()));
        }
        collection.setOptimisticLocked((attribute5 = element.attribute("optimistic-lock")) == null || "true".equals(attribute5.getValue()));
        Attribute attribute8 = element.attribute("order-by");
        if (attribute8 != null) {
            if (Environment.jvmSupportsLinkedHashCollections() || collection instanceof Bag) {
                collection.setOrderBy(attribute8.getValue());
            } else {
                log.warn((Object)"Attribute \"order-by\" ignored in JDK1.3 or less");
            }
        }
        if ((attribute4 = element.attribute("where")) != null) {
            collection.setWhere(attribute4.getValue());
        }
        if ((attribute3 = element.attribute("batch-size")) != null) {
            collection.setBatchSize(Integer.parseInt(attribute3.getValue()));
        }
        if ((string4 = element.attributeValue("node")) == null) {
            string4 = element.attributeValue("name");
        }
        collection.setNodeName(string4);
        String string5 = element.attributeValue("embed-xml");
        collection.setEmbedded(string5 == null || "true".equals(string5));
        Attribute attribute9 = element.attribute("persister");
        if (attribute9 != null) {
            try {
                collection.setCollectionPersisterClass(ReflectHelper.classForName(attribute9.getValue()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MappingException("Could not find collection persister class: " + attribute9.getValue());
            }
        }
        if ((attribute2 = element.attribute("collection-type")) != null) {
            collection.setTypeName(attribute2.getValue());
        }
        HbmBinder.initOuterJoinFetchSetting(element, collection);
        if ("subselect".equals(element.attributeValue("fetch"))) {
            collection.setSubselectLoadable(true);
            collection.getOwner().setSubselectLoadableCollections(true);
        }
        HbmBinder.initLaziness(element, collection, mappings, "true", mappings.isDefaultLazy());
        if ("extra".equals(element.attributeValue("lazy"))) {
            collection.setLazy(true);
            collection.setExtraLazy(true);
        }
        if ((element2 = element.element("one-to-many")) != null) {
            object3 = new OneToMany(collection.getOwner());
            collection.setElement((Value)object3);
            HbmBinder.bindOneToMany(element2, (OneToMany)object3, mappings);
        } else {
            object3 = element.attribute("table");
            if (object3 != null) {
                string3 = mappings.getNamingStrategy().tableName(object3.getValue());
            } else {
                object2 = collection.getOwner().getTable();
                object = ((Table)object2).getName();
                string3 = mappings.getNamingStrategy().collectionTableName(collection.getOwner().getEntityName(), (String)object, null, null, string2);
            }
            object2 = element.attribute("schema");
            object = object2 == null ? mappings.getSchemaName() : object2.getValue();
            attribute = element.attribute("catalog");
            String string6 = attribute == null ? mappings.getCatalogName() : attribute.getValue();
            Table table = mappings.addTable((String)object, string6, string3, HbmBinder.getSubselect(element), false);
            collection.setCollectionTable(table);
            HbmBinder.bindComment(table, element);
            log.info((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        object3 = element.attribute("sort");
        if (object3 == null || object3.getValue().equals("unsorted")) {
            collection.setSorted(false);
        } else {
            collection.setSorted(true);
            string3 = object3.getValue();
            if (!string3.equals("natural")) {
                collection.setComparatorClassName(string3);
            }
        }
        string3 = element.attribute("cascade");
        if (string3 != null && string3.getValue().indexOf("delete-orphan") >= 0) {
            collection.setOrphanDelete(true);
        }
        HbmBinder.handleCustomSQL(element, collection);
        if (collection instanceof List) {
            mappings.addSecondPass(new ListSecondPass(element, mappings, (List)collection, map));
        } else if (collection instanceof Map) {
            mappings.addSecondPass(new MapSecondPass(element, mappings, (Map)collection, map));
        } else if (collection instanceof IdentifierCollection) {
            mappings.addSecondPass(new IdentifierCollectionSecondPass(element, mappings, collection, map));
        } else {
            mappings.addSecondPass(new CollectionSecondPass(element, mappings, collection, map));
        }
        object2 = element.elementIterator("filter");
        while (object2.hasNext()) {
            object = (Element)object2.next();
            HbmBinder.parseFilter((Element)object, collection, mappings);
        }
        object = element.elementIterator("synchronize");
        while (object.hasNext()) {
            collection.getSynchronizedTables().add(((Element)object.next()).attributeValue("table"));
        }
        attribute = element.element("loader");
        if (attribute != null) {
            collection.setLoaderName(attribute.attributeValue("query-ref"));
        }
        collection.setReferencedPropertyName(element.element("key").attributeValue("property-ref"));
    }

    private static void initLaziness(Element element, Fetchable fetchable, Mappings mappings, String string, boolean bl) {
        Attribute attribute = element.attribute("lazy");
        boolean bl2 = attribute == null ? bl && fetchable.isLazy() : attribute.getValue().equals(string);
        fetchable.setLazy(bl2);
    }

    private static void initLaziness(Element element, ToOne toOne, Mappings mappings, boolean bl) {
        if ("no-proxy".equals(element.attributeValue("lazy"))) {
            toOne.setUnwrapProxy(true);
            toOne.setLazy(true);
        } else {
            HbmBinder.initLaziness(element, toOne, mappings, "proxy", bl);
        }
    }

    private static void bindColumnsOrFormula(Element element, SimpleValue simpleValue, String string, boolean bl, Mappings mappings) {
        Attribute attribute = element.attribute("formula");
        if (attribute != null) {
            Formula formula = new Formula();
            formula.setFormula(attribute.getText());
            simpleValue.addFormula(formula);
        } else {
            HbmBinder.bindColumns(element, simpleValue, bl, true, string, mappings);
        }
    }

    private static void bindComment(Table table, Element element) {
        Element element2 = element.element("comment");
        if (element2 != null) {
            table.setComment(element2.getTextTrim());
        }
    }

    public static void bindManyToOne(Element element, ManyToOne manyToOne, String string, boolean bl, Mappings mappings) throws MappingException {
        Attribute attribute;
        HbmBinder.bindColumnsOrFormula(element, manyToOne, string, bl, mappings);
        HbmBinder.initOuterJoinFetchSetting(element, manyToOne);
        HbmBinder.initLaziness(element, manyToOne, mappings, true);
        Attribute attribute2 = element.attribute("property-ref");
        if (attribute2 != null) {
            manyToOne.setReferencedPropertyName(attribute2.getValue());
        }
        manyToOne.setReferencedEntityName(HbmBinder.getEntityName(element, mappings));
        String string2 = element.attributeValue("embed-xml");
        manyToOne.setEmbedded(string2 == null || "true".equals(string2));
        String string3 = element.attributeValue("not-found");
        manyToOne.setIgnoreNotFound("ignore".equals(string3));
        if (attribute2 != null && !manyToOne.isIgnoreNotFound() && !element.getName().equals("many-to-many")) {
            mappings.addSecondPass(new ManyToOneSecondPass(manyToOne));
        }
        if ((attribute = element.attribute("foreign-key")) != null) {
            manyToOne.setForeignKeyName(attribute.getValue());
        }
        HbmBinder.validateCascade(element, string);
    }

    private static void validateCascade(Element element, String string) {
        String string2 = element.attributeValue("cascade");
        if (string2 != null && string2.indexOf("delete-orphan") > 0) {
            throw new MappingException("single-valued associations do not support orphan delete: " + string);
        }
    }

    public static void bindAny(Element element, Any any, boolean bl, Mappings mappings) throws MappingException {
        any.setIdentifierType(HbmBinder.getTypeFromXML(element));
        Attribute attribute = element.attribute("meta-type");
        if (attribute != null) {
            any.setMetaType(attribute.getValue());
            Iterator iterator = element.elementIterator("meta-value");
            if (iterator.hasNext()) {
                HashMap<Object, String> hashMap = new HashMap<Object, String>();
                Type type = TypeFactory.heuristicType(any.getMetaType());
                while (iterator.hasNext()) {
                    Element element2 = (Element)iterator.next();
                    try {
                        Object object = ((DiscriminatorType)type).stringToObject(element2.attributeValue("value"));
                        String string = HbmBinder.getClassName(element2.attribute("class"), mappings);
                        hashMap.put(object, string);
                    }
                    catch (ClassCastException classCastException) {
                        throw new MappingException("meta-type was not a DiscriminatorType: " + type.getName());
                    }
                    catch (Exception exception) {
                        throw new MappingException("could not interpret meta-value", exception);
                    }
                }
                any.setMetaValues(hashMap);
            }
        }
        HbmBinder.bindColumns(element, any, bl, false, null, mappings);
    }

    public static void bindOneToOne(Element element, OneToOne oneToOne, String string, boolean bl, Mappings mappings) throws MappingException {
        Attribute attribute;
        HbmBinder.bindColumns(element, oneToOne, bl, false, null, mappings);
        Attribute attribute2 = element.attribute("constrained");
        boolean bl2 = attribute2 != null && attribute2.getValue().equals("true");
        oneToOne.setConstrained(bl2);
        oneToOne.setForeignKeyType(bl2 ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        HbmBinder.initOuterJoinFetchSetting(element, oneToOne);
        HbmBinder.initLaziness(element, oneToOne, mappings, true);
        oneToOne.setEmbedded("true".equals(element.attributeValue("embed-xml")));
        Attribute attribute3 = element.attribute("foreign-key");
        if (attribute3 != null) {
            oneToOne.setForeignKeyName(attribute3.getValue());
        }
        if ((attribute = element.attribute("property-ref")) != null) {
            oneToOne.setReferencedPropertyName(attribute.getValue());
        }
        oneToOne.setPropertyName(element.attributeValue("name"));
        oneToOne.setReferencedEntityName(HbmBinder.getEntityName(element, mappings));
        HbmBinder.validateCascade(element, string);
    }

    public static void bindOneToMany(Element element, OneToMany oneToMany, Mappings mappings) throws MappingException {
        oneToMany.setReferencedEntityName(HbmBinder.getEntityName(element, mappings));
        String string = element.attributeValue("embed-xml");
        oneToMany.setEmbedded(string == null || "true".equals(string));
        String string2 = element.attributeValue("not-found");
        oneToMany.setIgnoreNotFound("ignore".equals(string2));
    }

    public static void bindColumn(Element element, Column column, boolean bl) {
        Element element2;
        Attribute attribute;
        Attribute attribute2;
        Attribute attribute3;
        Attribute attribute4 = element.attribute("length");
        if (attribute4 != null) {
            column.setLength(Integer.parseInt(attribute4.getValue()));
        }
        if ((attribute3 = element.attribute("scale")) != null) {
            column.setScale(Integer.parseInt(attribute3.getValue()));
        }
        if ((attribute2 = element.attribute("precision")) != null) {
            column.setPrecision(Integer.parseInt(attribute2.getValue()));
        }
        column.setNullable((attribute = element.attribute("not-null")) == null ? bl : attribute.getValue().equals("false"));
        Attribute attribute5 = element.attribute("unique");
        if (attribute5 != null) {
            column.setUnique(attribute5.getValue().equals("true"));
        }
        column.setCheckConstraint(element.attributeValue("check"));
        column.setDefaultValue(element.attributeValue("default"));
        Attribute attribute6 = element.attribute("sql-type");
        if (attribute6 != null) {
            column.setSqlType(attribute6.getValue());
        }
        if ((element2 = element.element("comment")) != null) {
            column.setComment(element2.getTextTrim());
        }
    }

    public static void bindArray(Element element, Array array, String string, String string2, Mappings mappings, java.util.Map map) throws MappingException {
        HbmBinder.bindCollection(element, array, string, string2, mappings, map);
        Attribute attribute = element.attribute("element-class");
        if (attribute != null) {
            array.setElementClassName(HbmBinder.getClassName(attribute, mappings));
        }
    }

    private static Class reflectedPropertyClass(String string, String string2) throws MappingException {
        if (string == null) {
            return null;
        }
        return ReflectHelper.reflectedPropertyClass(string, string2);
    }

    public static void bindComposite(Element element, Component component, String string, boolean bl, Mappings mappings, java.util.Map map) throws MappingException {
        HbmBinder.bindComponent(element, component, null, null, string, bl, false, mappings, map, false);
    }

    public static void bindCompositeId(Element element, Component component, PersistentClass persistentClass, String string, Mappings mappings, java.util.Map map) throws MappingException {
        component.setKey(true);
        String string2 = StringHelper.qualify(persistentClass.getEntityName(), string == null ? "id" : string);
        HbmBinder.bindComponent(element, component, persistentClass.getClassName(), string, string2, false, element.attribute("class") == null && string == null, mappings, map, false);
        if ("true".equals(element.attributeValue("mapped"))) {
            if (string != null) {
                throw new MappingException("cannot combine mapped=\"true\" with specified name");
            }
            Component component2 = new Component(persistentClass);
            HbmBinder.bindComponent(element, component2, persistentClass.getClassName(), null, string2, false, true, mappings, map, true);
            persistentClass.setIdentifierMapper(component2);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(component2);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
        }
    }

    public static void bindComponent(Element element, Component component, String string, String string2, String string3, boolean bl, boolean bl2, Mappings mappings, java.util.Map map, boolean bl3) throws MappingException {
        Object object;
        Object object2;
        Object object3;
        Attribute attribute;
        component.setEmbedded(bl2);
        component.setRoleName(string3);
        map = HbmBinder.getMetas(element, map);
        component.setMetaAttributes(map);
        Attribute attribute2 = attribute = bl3 ? null : element.attribute("class");
        if (attribute != null) {
            component.setComponentClassName(HbmBinder.getClassName(attribute, mappings));
        } else if ("dynamic-component".equals(element.getName())) {
            component.setDynamic(true);
        } else if (bl2) {
            if (component.getOwner().hasPojoRepresentation()) {
                component.setComponentClassName(component.getOwner().getClassName());
            } else {
                component.setDynamic(true);
            }
        } else if (component.getOwner().hasPojoRepresentation()) {
            object3 = HbmBinder.reflectedPropertyClass(string, string2);
            if (object3 != null) {
                component.setComponentClassName(((Class)object3).getName());
            }
        } else {
            component.setDynamic(true);
        }
        object3 = element.attributeValue("node");
        if (object3 == null) {
            object3 = element.attributeValue("name");
        }
        if (object3 == null) {
            object3 = component.getOwner().getNodeName();
        }
        component.setNodeName((String)object3);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Object object4;
            object2 = (Element)iterator.next();
            object = object2.getName();
            String string4 = HbmBinder.getPropertyName((Element)object2);
            String string5 = string4 == null ? null : StringHelper.qualify(string3, string4);
            CollectionType collectionType = CollectionType.collectionTypeFromString((String)object);
            Value value = null;
            if (collectionType != null) {
                object4 = collectionType.create((Element)object2, string5, component.getOwner(), mappings, map);
                mappings.addCollection((org.hibernate.mapping.Collection)object4);
                value = object4;
            } else if ("many-to-one".equals(object) || "key-many-to-one".equals(object)) {
                value = new ManyToOne(component.getTable());
                object4 = bl2 ? string4 : string5.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindManyToOne((Element)object2, value, (String)object4, bl, mappings);
            } else if ("one-to-one".equals(object)) {
                value = new OneToOne(component.getTable(), component.getOwner());
                object4 = bl2 ? string4 : string5.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindOneToOne((Element)object2, (OneToOne)value, (String)object4, bl, mappings);
            } else if ("any".equals(object)) {
                value = new Any(component.getTable());
                HbmBinder.bindAny((Element)object2, (Any)value, bl, mappings);
            } else if ("property".equals(object) || "key-property".equals(object)) {
                value = new SimpleValue(component.getTable());
                object4 = bl2 ? string4 : string5.substring(component.getOwner().getEntityName().length() + 1);
                HbmBinder.bindSimpleValue((Element)object2, value, bl, (String)object4, mappings);
            } else if ("component".equals(object) || "dynamic-component".equals(object) || "nested-composite-element".equals(object)) {
                value = new Component(component);
                HbmBinder.bindComponent((Element)object2, (Component)value, component.getComponentClassName(), string4, string5, bl, bl2, mappings, map, bl3);
            } else if ("parent".equals(object)) {
                component.setParentProperty(string4);
            }
            if (value == null) continue;
            object4 = HbmBinder.createProperty(value, string4, component.getComponentClassName(), (Element)object2, mappings, map);
            if (bl3) {
                ((Property)object4).setInsertable(false);
                ((Property)object4).setUpdateable(false);
            }
            component.addProperty((Property)object4);
        }
        if ("true".equals(element.attributeValue("unique"))) {
            iterator = component.getColumnIterator();
            object2 = new ArrayList();
            while (iterator.hasNext()) {
                ((ArrayList)object2).add(iterator.next());
            }
            component.getOwner().getTable().createUniqueKey((java.util.List)object2);
        }
        iterator = element.elementIterator("tuplizer");
        while (iterator.hasNext()) {
            object2 = (Element)iterator.next();
            object = EntityMode.parse(object2.attributeValue("entity-mode"));
            component.addTuplizer((EntityMode)object, object2.attributeValue("class"));
        }
    }

    public static String getTypeFromXML(Element element) throws MappingException {
        Attribute attribute = element.attribute("type");
        if (attribute == null) {
            attribute = element.attribute("id-type");
        }
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    private static void initOuterJoinFetchSetting(Element element, Fetchable fetchable) {
        FetchMode fetchMode;
        Attribute attribute = element.attribute("fetch");
        boolean bl = true;
        if (attribute == null) {
            Attribute attribute2 = element.attribute("outer-join");
            if (attribute2 == null) {
                if ("many-to-many".equals(element.getName())) {
                    bl = false;
                    fetchMode = FetchMode.JOIN;
                } else {
                    fetchMode = "one-to-one".equals(element.getName()) ? ((bl = ((OneToOne)fetchable).isConstrained()) ? FetchMode.DEFAULT : FetchMode.JOIN) : FetchMode.DEFAULT;
                }
            } else {
                boolean bl2;
                String string = attribute2.getValue();
                fetchMode = "auto".equals(string) ? FetchMode.DEFAULT : ((bl2 = "true".equals(string)) ? FetchMode.JOIN : FetchMode.SELECT);
            }
        } else {
            boolean bl3 = "join".equals(attribute.getValue());
            fetchMode = bl3 ? FetchMode.JOIN : FetchMode.SELECT;
        }
        fetchable.setFetchMode(fetchMode);
        fetchable.setLazy(bl);
    }

    private static void makeIdentifier(Element element, SimpleValue simpleValue, Mappings mappings) {
        Object object;
        Element element2 = element.element("generator");
        if (element2 != null) {
            simpleValue.setIdentifierGeneratorStrategy(element2.attributeValue("class"));
            object = new Properties();
            if (mappings.getSchemaName() != null) {
                ((Properties)object).setProperty("schema", mappings.getSchemaName());
            }
            if (mappings.getCatalogName() != null) {
                ((Properties)object).setProperty("catalog", mappings.getCatalogName());
            }
            Iterator iterator = element2.elementIterator("param");
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                ((Properties)object).setProperty(element3.attributeValue("name"), element3.getText());
            }
            simpleValue.setIdentifierGeneratorProperties((Properties)object);
        }
        simpleValue.getTable().setIdentifierValue(simpleValue);
        object = element.attribute("unsaved-value");
        if (object != null) {
            simpleValue.setNullValue(object.getValue());
        } else if ("assigned".equals(simpleValue.getIdentifierGeneratorStrategy())) {
            simpleValue.setNullValue("undefined");
        } else {
            simpleValue.setNullValue(null);
        }
    }

    private static final void makeVersion(Element element, SimpleValue simpleValue) {
        Attribute attribute = element.attribute("unsaved-value");
        if (attribute != null) {
            simpleValue.setNullValue(attribute.getValue());
        } else {
            simpleValue.setNullValue("undefined");
        }
    }

    protected static void createClassProperties(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
        HbmBinder.createClassProperties(element, persistentClass, mappings, map, null, true, true, false);
    }

    protected static void createClassProperties(Element element, PersistentClass persistentClass, Mappings mappings, java.util.Map map, UniqueKey uniqueKey, boolean bl, boolean bl2, boolean bl3) throws MappingException {
        String string = persistentClass.getEntityName();
        Table table = persistentClass.getTable();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Object object;
            Element element2 = (Element)iterator.next();
            String string2 = element2.getName();
            String string3 = element2.attributeValue("name");
            CollectionType collectionType = CollectionType.collectionTypeFromString(string2);
            Value value = null;
            if (collectionType != null) {
                object = collectionType.create(element2, StringHelper.qualify(string, string3), persistentClass, mappings, map);
                mappings.addCollection((org.hibernate.mapping.Collection)object);
                value = object;
            } else if ("many-to-one".equals(string2)) {
                value = new ManyToOne(table);
                HbmBinder.bindManyToOne(element2, value, string3, bl2, mappings);
            } else if ("any".equals(string2)) {
                value = new Any(table);
                HbmBinder.bindAny(element2, (Any)value, bl2, mappings);
            } else if ("one-to-one".equals(string2)) {
                value = new OneToOne(table, persistentClass);
                HbmBinder.bindOneToOne(element2, (OneToOne)value, string3, true, mappings);
            } else if ("property".equals(string2)) {
                value = new SimpleValue(table);
                HbmBinder.bindSimpleValue(element2, value, bl2, string3, mappings);
            } else if ("component".equals(string2) || "dynamic-component".equals(string2) || "properties".equals(string2)) {
                object = StringHelper.qualify(string, string3);
                value = new Component(persistentClass);
                HbmBinder.bindComponent(element2, (Component)value, persistentClass.getClassName(), string3, (String)object, true, "properties".equals(string2), mappings, map, false);
            } else if ("join".equals(string2)) {
                object = new Join();
                ((Join)object).setPersistentClass(persistentClass);
                HbmBinder.bindJoin(element2, (Join)object, mappings, map);
                persistentClass.addJoin((Join)object);
            } else if ("subclass".equals(string2)) {
                HbmBinder.handleSubclass(persistentClass, mappings, element2, map);
            } else if ("joined-subclass".equals(string2)) {
                HbmBinder.handleJoinedSubclass(persistentClass, mappings, element2, map);
            } else if ("union-subclass".equals(string2)) {
                HbmBinder.handleUnionSubclass(persistentClass, mappings, element2, map);
            } else if ("filter".equals(string2)) {
                HbmBinder.parseFilter(element2, persistentClass, mappings);
            } else if ("natural-id".equals(string2)) {
                object = new UniqueKey();
                ((Constraint)object).setName("_UniqueKey");
                ((Constraint)object).setTable(table);
                boolean bl4 = "true".equals(element2.attributeValue("mutable"));
                HbmBinder.createClassProperties(element2, persistentClass, mappings, map, (UniqueKey)object, bl4, false, true);
                table.addUniqueKey((UniqueKey)object);
            } else if ("query".equals(string2)) {
                HbmBinder.bindNamedQuery(element2, persistentClass.getEntityName(), mappings);
            } else if ("sql-query".equals(string2)) {
                HbmBinder.bindNamedSQLQuery(element2, persistentClass.getEntityName(), mappings);
            } else if ("resultset".equals(string2)) {
                HbmBinder.bindResultSetMappingDefinition(element2, persistentClass.getEntityName(), mappings);
            }
            if (value == null) continue;
            object = HbmBinder.createProperty(value, string3, persistentClass.getClassName(), element2, mappings, map);
            if (!bl) {
                ((Property)object).setUpdateable(false);
            }
            if (bl3) {
                ((Property)object).setNaturalIdentifier(true);
            }
            persistentClass.addProperty((Property)object);
            if (uniqueKey == null) continue;
            uniqueKey.addColumns(((Property)object).getColumnIterator());
        }
    }

    private static Property createProperty(Value value, String string, String string2, Element element, Mappings mappings, java.util.Map map) throws MappingException {
        String string3;
        Serializable serializable;
        if (StringHelper.isEmpty(string)) {
            throw new MappingException(element.getName() + " mapping must defined a name attribute [" + string2 + "]");
        }
        value.setTypeUsingReflection(string2, string);
        if (value instanceof ToOne) {
            serializable = (ToOne)value;
            String string4 = ((ToOne)serializable).getReferencedPropertyName();
            if (string4 != null) {
                mappings.addUniquePropertyReference(((ToOne)serializable).getReferencedEntityName(), string4);
            }
        } else if (value instanceof org.hibernate.mapping.Collection && (string3 = ((org.hibernate.mapping.Collection)(serializable = (org.hibernate.mapping.Collection)value)).getReferencedPropertyName()) != null) {
            mappings.addPropertyReference(((org.hibernate.mapping.Collection)serializable).getOwnerEntityName(), string3);
        }
        value.createForeignKey();
        serializable = new Property();
        ((Property)serializable).setValue(value);
        HbmBinder.bindProperty(element, (Property)serializable, mappings, map);
        return serializable;
    }

    private static void handleUnionSubclass(PersistentClass persistentClass, Mappings mappings, Element element, java.util.Map map) throws MappingException {
        UnionSubclass unionSubclass = new UnionSubclass(persistentClass);
        HbmBinder.bindUnionSubclass(element, unionSubclass, mappings, map);
        persistentClass.addSubclass(unionSubclass);
        mappings.addClass(unionSubclass);
    }

    private static void handleJoinedSubclass(PersistentClass persistentClass, Mappings mappings, Element element, java.util.Map map) throws MappingException {
        JoinedSubclass joinedSubclass = new JoinedSubclass(persistentClass);
        HbmBinder.bindJoinedSubclass(element, joinedSubclass, mappings, map);
        persistentClass.addSubclass(joinedSubclass);
        mappings.addClass(joinedSubclass);
    }

    private static void handleSubclass(PersistentClass persistentClass, Mappings mappings, Element element, java.util.Map map) throws MappingException {
        SingleTableSubclass singleTableSubclass = new SingleTableSubclass(persistentClass);
        HbmBinder.bindSubclass(element, singleTableSubclass, mappings, map);
        persistentClass.addSubclass(singleTableSubclass);
        mappings.addClass(singleTableSubclass);
    }

    public static void bindListSecondPass(Element element, List list, java.util.Map map, Mappings mappings, java.util.Map map2) throws MappingException {
        HbmBinder.bindCollectionSecondPass(element, list, map, mappings, map2);
        Element element2 = element.element("list-index");
        if (element2 == null) {
            element2 = element.element("index");
        }
        SimpleValue simpleValue = new SimpleValue(list.getCollectionTable());
        HbmBinder.bindSimpleValue(element2, simpleValue, list.isOneToMany(), "idx", mappings);
        simpleValue.setTypeName("integer");
        list.setIndex(simpleValue);
        String string = element2.attributeValue("base");
        if (string != null) {
            list.setBaseIndex(Integer.parseInt(string));
        }
        list.setIndexNodeName(element2.attributeValue("node"));
        if (list.isOneToMany() && !list.getKey().isNullable() && !list.isInverse()) {
            String string2 = ((OneToMany)list.getElement()).getReferencedEntityName();
            PersistentClass persistentClass = mappings.getClass(string2);
            IndexBackref indexBackref = new IndexBackref();
            indexBackref.setName('_' + element.attributeValue("name") + "IndexBackref");
            indexBackref.setUpdateable(false);
            indexBackref.setSelectable(false);
            indexBackref.setCollectionRole(list.getRole());
            indexBackref.setEntityName(list.getOwner().getEntityName());
            indexBackref.setValue(list.getIndex());
            persistentClass.addProperty(indexBackref);
        }
    }

    public static void bindIdentifierCollectionSecondPass(Element element, IdentifierCollection identifierCollection, java.util.Map map, Mappings mappings, java.util.Map map2) throws MappingException {
        HbmBinder.bindCollectionSecondPass(element, identifierCollection, map, mappings, map2);
        Element element2 = element.element("collection-id");
        SimpleValue simpleValue = new SimpleValue(identifierCollection.getCollectionTable());
        HbmBinder.bindSimpleValue(element2, simpleValue, false, "id", mappings);
        identifierCollection.setIdentifier(simpleValue);
        HbmBinder.makeIdentifier(element2, simpleValue, mappings);
    }

    public static void bindMapSecondPass(Element element, Map map, java.util.Map map2, Mappings mappings, java.util.Map map3) throws MappingException {
        Object object;
        Object object2;
        HbmBinder.bindCollectionSecondPass(element, map, map2, mappings, map3);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            object2 = element2.getName();
            if ("index".equals(object2) || "map-key".equals(object2)) {
                object = new SimpleValue(map.getCollectionTable());
                HbmBinder.bindSimpleValue(element2, (SimpleValue)object, map.isOneToMany(), "idx", mappings);
                if (!((SimpleValue)object).isTypeSpecified()) {
                    throw new MappingException("map index element must specify a type: " + map.getRole());
                }
                map.setIndex((Value)object);
                map.setIndexNodeName(element2.attributeValue("node"));
                continue;
            }
            if ("index-many-to-many".equals(object2) || "map-key-many-to-many".equals(object2)) {
                object = new ManyToOne(map.getCollectionTable());
                HbmBinder.bindManyToOne(element2, (ManyToOne)object, "idx", map.isOneToMany(), mappings);
                map.setIndex((Value)object);
                continue;
            }
            if ("composite-index".equals(object2) || "composite-map-key".equals(object2)) {
                object = new Component(map);
                HbmBinder.bindComposite(element2, (Component)object, map.getRole() + ".index", map.isOneToMany(), mappings, map3);
                map.setIndex((Value)object);
                continue;
            }
            if (!"index-many-to-any".equals(object2)) continue;
            object = new Any(map.getCollectionTable());
            HbmBinder.bindAny(element2, (Any)object, map.isOneToMany(), mappings);
            map.setIndex((Value)object);
        }
        boolean bl = false;
        object2 = map.getIndex().getColumnIterator();
        while (object2.hasNext()) {
            if (!((Selectable)object2.next()).isFormula()) continue;
            bl = true;
        }
        if (map.isOneToMany() && !map.getKey().isNullable() && !map.isInverse() && !bl) {
            object = ((OneToMany)map.getElement()).getReferencedEntityName();
            PersistentClass persistentClass = mappings.getClass((String)object);
            IndexBackref indexBackref = new IndexBackref();
            indexBackref.setName('_' + element.attributeValue("name") + "IndexBackref");
            indexBackref.setUpdateable(false);
            indexBackref.setSelectable(false);
            indexBackref.setCollectionRole(map.getRole());
            indexBackref.setEntityName(map.getOwner().getEntityName());
            indexBackref.setValue(map.getIndex());
            persistentClass.addProperty(indexBackref);
        }
    }

    public static void bindCollectionSecondPass(Element element, org.hibernate.mapping.Collection collection, java.util.Map map, Mappings mappings, java.util.Map map2) throws MappingException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        OneToMany oneToMany;
        if (collection.isOneToMany()) {
            oneToMany = (OneToMany)collection.getElement();
            object4 = oneToMany.getReferencedEntityName();
            object3 = (PersistentClass)map.get(object4);
            if (object3 == null) {
                throw new MappingException("Association references unmapped class: " + (String)object4);
            }
            oneToMany.setAssociatedClass((PersistentClass)object3);
            collection.setCollectionTable(((PersistentClass)object3).getTable());
            log.info((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        if ((oneToMany = element.attribute("check")) != null) {
            collection.getCollectionTable().addCheckConstraint(oneToMany.getValue());
        }
        object4 = element.elementIterator();
        while (object4.hasNext()) {
            object3 = (Element)object4.next();
            object2 = object3.getName();
            if ("key".equals(object2)) {
                String string = collection.getReferencedPropertyName();
                object = string == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getReferencedProperty(string).getValue();
                DependantValue dependantValue = new DependantValue(collection.getCollectionTable(), (KeyValue)object);
                dependantValue.setCascadeDeleteEnabled("cascade".equals(object3.attributeValue("on-delete")));
                HbmBinder.bindSimpleValue((Element)object3, dependantValue, collection.isOneToMany(), "id", mappings);
                collection.setKey(dependantValue);
                Attribute attribute = object3.attribute("not-null");
                dependantValue.setNullable(attribute == null || attribute.getValue().equals("false"));
                Attribute attribute2 = object3.attribute("update");
                dependantValue.setUpdateable(attribute2 == null || attribute2.getValue().equals("true"));
            } else if ("element".equals(object2)) {
                object = new SimpleValue(collection.getCollectionTable());
                collection.setElement((Value)object);
                HbmBinder.bindSimpleValue((Element)object3, (SimpleValue)object, true, "elt", mappings);
            } else if ("many-to-many".equals(object2)) {
                object = new ManyToOne(collection.getCollectionTable());
                collection.setElement((Value)object);
                HbmBinder.bindManyToOne((Element)object3, (ManyToOne)object, "elt", false, mappings);
                HbmBinder.bindManyToManySubelements(collection, (Element)object3, mappings);
            } else if ("composite-element".equals(object2)) {
                object = new Component(collection);
                collection.setElement((Value)object);
                HbmBinder.bindComposite((Element)object3, (Component)object, collection.getRole() + ".element", true, mappings, map2);
            } else if ("many-to-any".equals(object2)) {
                object = new Any(collection.getCollectionTable());
                collection.setElement((Value)object);
                HbmBinder.bindAny((Element)object3, (Any)object, true, mappings);
            } else if ("cache".equals(object2)) {
                collection.setCacheConcurrencyStrategy(object3.attributeValue("usage"));
                collection.setCacheRegionName(object3.attributeValue("region"));
            }
            if ((object = object3.attributeValue("node")) == null) continue;
            collection.setElementNodeName((String)object);
        }
        if (collection.isOneToMany() && !collection.isInverse() && !collection.getKey().isNullable()) {
            object3 = ((OneToMany)collection.getElement()).getReferencedEntityName();
            object2 = mappings.getClass((String)object3);
            object = new Backref();
            ((Property)object).setName('_' + element.attributeValue("name") + "Backref");
            ((Property)object).setUpdateable(false);
            ((Property)object).setSelectable(false);
            ((Backref)object).setCollectionRole(collection.getRole());
            ((Backref)object).setEntityName(collection.getOwner().getEntityName());
            ((Property)object).setValue(collection.getKey());
            ((PersistentClass)object2).addProperty((Property)object);
        }
    }

    private static void bindManyToManySubelements(org.hibernate.mapping.Collection collection, Element element, Mappings mappings) throws MappingException {
        Attribute attribute = element.attribute("where");
        String string = attribute == null ? null : attribute.getValue();
        collection.setManyToManyWhere(string);
        Attribute attribute2 = element.attribute("order-by");
        String string2 = attribute2 == null ? null : attribute2.getValue();
        collection.setManyToManyOrdering(string2);
        Iterator iterator = element.elementIterator("filter");
        if ((iterator.hasNext() || string != null) && collection.getFetchMode() == FetchMode.JOIN && collection.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("many-to-many defining filter or where without join fetching not valid within collection using join fetching [" + collection.getRole() + "]");
        }
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string3 = element2.attributeValue("name");
            String string4 = element2.getTextTrim();
            if (StringHelper.isEmpty(string4)) {
                string4 = element2.attributeValue("condition");
            }
            if (StringHelper.isEmpty(string4)) {
                string4 = mappings.getFilterDefinition(string3).getDefaultFilterCondition();
            }
            if (string4 == null) {
                throw new MappingException("no filter condition found for filter: " + string3);
            }
            log.debug((Object)("Applying many-to-many filter [" + string3 + "] as [" + string4 + "] to role [" + collection.getRole() + "]"));
            collection.addManyToManyFilter(string3, string4);
        }
    }

    public static final FlushMode getFlushMode(String string) {
        if (string == null) {
            return null;
        }
        if ("auto".equals(string)) {
            return FlushMode.AUTO;
        }
        if ("commit".equals(string)) {
            return FlushMode.COMMIT;
        }
        if ("never".equals(string)) {
            return FlushMode.NEVER;
        }
        if ("manual".equals(string)) {
            return FlushMode.MANUAL;
        }
        if ("always".equals(string)) {
            return FlushMode.ALWAYS;
        }
        throw new MappingException("unknown flushmode");
    }

    private static void bindNamedQuery(Element element, String string, Mappings mappings) {
        String string2 = element.attributeValue("name");
        if (string != null) {
            string2 = string + '.' + string2;
        }
        String string3 = element.getText();
        log.debug((Object)("Named query: " + string2 + " -> " + string3));
        boolean bl = "true".equals(element.attributeValue("cacheable"));
        String string4 = element.attributeValue("cache-region");
        Attribute attribute = element.attribute("timeout");
        Integer n = attribute == null ? null : new Integer(attribute.getValue());
        Attribute attribute2 = element.attribute("fetch-size");
        Integer n2 = attribute2 == null ? null : new Integer(attribute2.getValue());
        Attribute attribute3 = element.attribute("read-only");
        boolean bl2 = attribute3 != null && "true".equals(attribute3.getValue());
        Attribute attribute4 = element.attribute("cache-mode");
        String string5 = attribute4 == null ? null : attribute4.getValue();
        Attribute attribute5 = element.attribute("comment");
        String string6 = attribute5 == null ? null : attribute5.getValue();
        NamedQueryDefinition namedQueryDefinition = new NamedQueryDefinition(string3, bl, string4, n, n2, HbmBinder.getFlushMode(element.attributeValue("flush-mode")), HbmBinder.getCacheMode(string5), bl2, string6, HbmBinder.getParameterTypes(element));
        mappings.addQuery(string2, namedQueryDefinition);
    }

    public static CacheMode getCacheMode(String string) {
        if (string == null) {
            return null;
        }
        if ("get".equals(string)) {
            return CacheMode.GET;
        }
        if ("ignore".equals(string)) {
            return CacheMode.IGNORE;
        }
        if ("normal".equals(string)) {
            return CacheMode.NORMAL;
        }
        if ("put".equals(string)) {
            return CacheMode.PUT;
        }
        if ("refresh".equals(string)) {
            return CacheMode.REFRESH;
        }
        throw new MappingException("Unknown Cache Mode: " + string);
    }

    public static java.util.Map getParameterTypes(Element element) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        Iterator iterator = element.elementIterator("query-param");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            sequencedHashMap.put(element2.attributeValue("name"), element2.attributeValue("type"));
        }
        return sequencedHashMap;
    }

    private static void bindResultSetMappingDefinition(Element element, String string, Mappings mappings) {
        mappings.addSecondPass(new ResultSetMappingSecondPass(element, string, mappings));
    }

    private static void bindNamedSQLQuery(Element element, String string, Mappings mappings) {
        mappings.addSecondPass(new NamedSQLQuerySecondPass(element, string, mappings));
    }

    private static String getPropertyName(Element element) {
        return element.attributeValue("name");
    }

    private static PersistentClass getSuperclass(Mappings mappings, Element element) throws MappingException {
        String string = element.attributeValue("extends");
        PersistentClass persistentClass = mappings.getClass(string);
        if (persistentClass == null) {
            String string2 = HbmBinder.getClassName(string, mappings);
            persistentClass = mappings.getClass(string2);
        }
        if (persistentClass == null) {
            throw new MappingException("Cannot extend unmapped class " + string);
        }
        return persistentClass;
    }

    private static int getOptimisticLockMode(Attribute attribute) throws MappingException {
        if (attribute == null) {
            return 0;
        }
        String string = attribute.getValue();
        if (string == null || "version".equals(string)) {
            return 0;
        }
        if ("dirty".equals(string)) {
            return 1;
        }
        if ("all".equals(string)) {
            return 2;
        }
        if ("none".equals(string)) {
            return -1;
        }
        throw new MappingException("Unsupported optimistic-lock style: " + string);
    }

    private static final java.util.Map getMetas(Element element, java.util.Map map) {
        return HbmBinder.getMetas(element, map, false);
    }

    public static final java.util.Map getMetas(Element element, java.util.Map map, boolean bl) {
        HashMap<String, MetaAttribute> hashMap = new HashMap<String, MetaAttribute>();
        hashMap.putAll(map);
        Iterator iterator = element.elementIterator("meta");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            boolean bl2 = Boolean.valueOf(element2.attributeValue("inherit"));
            if (bl & !bl2) continue;
            String string = element2.attributeValue("attribute");
            MetaAttribute metaAttribute = (MetaAttribute)hashMap.get(string);
            MetaAttribute metaAttribute2 = (MetaAttribute)map.get(string);
            if (metaAttribute == null) {
                metaAttribute = new MetaAttribute(string);
                hashMap.put(string, metaAttribute);
            } else if (metaAttribute == metaAttribute2) {
                metaAttribute = new MetaAttribute(string);
                hashMap.put(string, metaAttribute);
            }
            metaAttribute.addValue(element2.getText());
        }
        return hashMap;
    }

    public static String getEntityName(Element element, Mappings mappings) {
        String string = element.attributeValue("entity-name");
        return string == null ? HbmBinder.getClassName(element.attribute("class"), mappings) : string;
    }

    private static String getClassName(Attribute attribute, Mappings mappings) {
        if (attribute == null) {
            return null;
        }
        return HbmBinder.getClassName(attribute.getValue(), mappings);
    }

    public static String getClassName(String string, Mappings mappings) {
        return HbmBinder.getClassName(string, mappings.getDefaultPackage());
    }

    public static String getClassName(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(46) < 0 && string2 != null) {
            return string2 + '.' + string;
        }
        return string;
    }

    private static void parseFilterDef(Element element, Mappings mappings) {
        Object object;
        String string = element.attributeValue("name");
        log.debug((Object)("Parsing filter-def [" + string + "]"));
        String string2 = element.getTextTrim();
        if (StringHelper.isEmpty(string2)) {
            string2 = element.attributeValue("condition");
        }
        HashMap<String, Type> hashMap = new HashMap<String, Type>();
        Iterator iterator = element.elementIterator("filter-param");
        while (iterator.hasNext()) {
            object = (Element)iterator.next();
            String string3 = object.attributeValue("name");
            String string4 = object.attributeValue("type");
            log.debug((Object)("adding filter parameter : " + string3 + " -> " + string4));
            Type type = TypeFactory.heuristicType(string4);
            log.debug((Object)("parameter heuristic type : " + type));
            hashMap.put(string3, type);
        }
        log.debug((Object)("Parsed filter-def [" + string + "]"));
        object = new FilterDefinition(string, string2, hashMap);
        mappings.addFilterDefinition((FilterDefinition)object);
    }

    private static void parseFilter(Element element, Filterable filterable, Mappings mappings) {
        String string = element.attributeValue("name");
        String string2 = element.getTextTrim();
        if (StringHelper.isEmpty(string2)) {
            string2 = element.attributeValue("condition");
        }
        if (StringHelper.isEmpty(string2)) {
            string2 = mappings.getFilterDefinition(string).getDefaultFilterCondition();
        }
        if (string2 == null) {
            throw new MappingException("no filter condition found for filter: " + string);
        }
        log.debug((Object)("Applying filter [" + string + "] as [" + string2 + "]"));
        filterable.addFilter(string, string2);
    }

    private static String getSubselect(Element element) {
        String string = element.attributeValue("subselect");
        if (string != null) {
            return string;
        }
        Element element2 = element.element("subselect");
        return element2 == null ? null : element2.getText();
    }

    public static java.util.List getExtendsNeeded(Document document, Mappings mappings) {
        Object object;
        Object object2;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator[] iteratorArray = new Iterator[3];
        Element element = document.getRootElement();
        Attribute attribute = element.attribute("package");
        String string2 = string = attribute == null ? null : attribute.getValue();
        if (string != null) {
            mappings.setDefaultPackage(string);
        }
        iteratorArray[0] = element.elementIterator("subclass");
        iteratorArray[1] = element.elementIterator("joined-subclass");
        iteratorArray[2] = element.elementIterator("union-subclass");
        JoinedIterator joinedIterator = new JoinedIterator(iteratorArray);
        while (joinedIterator.hasNext()) {
            object2 = (Element)joinedIterator.next();
            object = object2.attributeValue("extends");
            if (mappings.getClass((String)object) != null || mappings.getClass(HbmBinder.getClassName((String)object, mappings)) != null) continue;
            arrayList.add(object);
        }
        if (!arrayList.isEmpty()) {
            object2 = new HashSet(arrayList);
            object = new EntityElementHandler((java.util.Set)object2, string){
                private final /* synthetic */ java.util.Set val$set;
                private final /* synthetic */ String val$packageName;
                {
                    this.val$set = set;
                    this.val$packageName = string;
                }

                public void handleEntity(String string, String string2, Mappings mappings) {
                    if (string != null) {
                        this.val$set.remove(string);
                    } else {
                        String string3 = HbmBinder.getClassName(string2, this.val$packageName);
                        this.val$set.remove(string3);
                        if (this.val$packageName != null) {
                            this.val$set.remove(StringHelper.unqualify(string3));
                        }
                    }
                }
            };
            HbmBinder.recognizeEntities(mappings, element, (EntityElementHandler)object);
            arrayList.clear();
            arrayList.addAll((Collection<Object>)object2);
        }
        return arrayList;
    }

    private static void recognizeEntities(Mappings mappings, Element element, EntityElementHandler entityElementHandler) {
        Iterator[] iteratorArray = new Iterator[]{element.elementIterator("class"), element.elementIterator("subclass"), element.elementIterator("joined-subclass"), element.elementIterator("union-subclass")};
        JoinedIterator joinedIterator = new JoinedIterator(iteratorArray);
        while (joinedIterator.hasNext()) {
            Element element2 = (Element)joinedIterator.next();
            entityElementHandler.handleEntity(element2.attributeValue("entity-name"), element2.attributeValue("name"), mappings);
            HbmBinder.recognizeEntities(mappings, element2, entityElementHandler);
        }
    }

    static class CollectionSecondPass
    extends org.hibernate.cfg.CollectionSecondPass {
        Element node;

        CollectionSecondPass(Element element, Mappings mappings, org.hibernate.mapping.Collection collection, java.util.Map map) {
            super(mappings, collection, map);
            this.node = element;
        }

        public void secondPass(java.util.Map map, java.util.Map map2) throws MappingException {
            HbmBinder.bindCollectionSecondPass(this.node, this.collection, map, this.mappings, map2);
        }
    }

    static abstract class CollectionType {
        private String xmlTag;
        private static final CollectionType MAP = new CollectionType("map"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                Map map2 = new Map(persistentClass);
                HbmBinder.bindCollection(element, map2, persistentClass.getEntityName(), string, mappings, map);
                return map2;
            }
        };
        private static final CollectionType SET = new CollectionType("set"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                Set set = new Set(persistentClass);
                HbmBinder.bindCollection(element, set, persistentClass.getEntityName(), string, mappings, map);
                return set;
            }
        };
        private static final CollectionType LIST = new CollectionType("list"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                List list = new List(persistentClass);
                HbmBinder.bindCollection(element, list, persistentClass.getEntityName(), string, mappings, map);
                return list;
            }
        };
        private static final CollectionType BAG = new CollectionType("bag"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                Bag bag = new Bag(persistentClass);
                HbmBinder.bindCollection(element, bag, persistentClass.getEntityName(), string, mappings, map);
                return bag;
            }
        };
        private static final CollectionType IDBAG = new CollectionType("idbag"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                IdentifierBag identifierBag = new IdentifierBag(persistentClass);
                HbmBinder.bindCollection(element, identifierBag, persistentClass.getEntityName(), string, mappings, map);
                return identifierBag;
            }
        };
        private static final CollectionType ARRAY = new CollectionType("array"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                Array array = new Array(persistentClass);
                HbmBinder.bindArray(element, array, persistentClass.getEntityName(), string, mappings, map);
                return array;
            }
        };
        private static final CollectionType PRIMITIVE_ARRAY = new CollectionType("primitive-array"){

            public org.hibernate.mapping.Collection create(Element element, String string, PersistentClass persistentClass, Mappings mappings, java.util.Map map) throws MappingException {
                PrimitiveArray primitiveArray = new PrimitiveArray(persistentClass);
                HbmBinder.bindArray(element, primitiveArray, persistentClass.getEntityName(), string, mappings, map);
                return primitiveArray;
            }
        };
        private static final HashMap INSTANCES = new HashMap();

        public abstract org.hibernate.mapping.Collection create(Element var1, String var2, PersistentClass var3, Mappings var4, java.util.Map var5) throws MappingException;

        CollectionType(String string) {
            this.xmlTag = string;
        }

        public String toString() {
            return this.xmlTag;
        }

        public static CollectionType collectionTypeFromString(String string) {
            return (CollectionType)INSTANCES.get(string);
        }

        static {
            INSTANCES.put(MAP.toString(), MAP);
            INSTANCES.put(BAG.toString(), BAG);
            INSTANCES.put(IDBAG.toString(), IDBAG);
            INSTANCES.put(SET.toString(), SET);
            INSTANCES.put(LIST.toString(), LIST);
            INSTANCES.put(ARRAY.toString(), ARRAY);
            INSTANCES.put(PRIMITIVE_ARRAY.toString(), PRIMITIVE_ARRAY);
        }
    }

    private static interface EntityElementHandler {
        public void handleEntity(String var1, String var2, Mappings var3);
    }

    static class IdentifierCollectionSecondPass
    extends CollectionSecondPass {
        IdentifierCollectionSecondPass(Element element, Mappings mappings, org.hibernate.mapping.Collection collection, java.util.Map map) {
            super(element, mappings, collection, map);
        }

        public void secondPass(java.util.Map map, java.util.Map map2) throws MappingException {
            HbmBinder.bindIdentifierCollectionSecondPass(this.node, (IdentifierCollection)this.collection, map, this.mappings, map2);
        }
    }

    static class ListSecondPass
    extends CollectionSecondPass {
        ListSecondPass(Element element, Mappings mappings, List list, java.util.Map map) {
            super(element, mappings, list, map);
        }

        public void secondPass(java.util.Map map, java.util.Map map2) throws MappingException {
            HbmBinder.bindListSecondPass(this.node, (List)this.collection, map, this.mappings, map2);
        }
    }

    static class ManyToOneSecondPass
    implements SecondPass {
        private final ManyToOne manyToOne;

        ManyToOneSecondPass(ManyToOne manyToOne) {
            this.manyToOne = manyToOne;
        }

        public void doSecondPass(java.util.Map map) throws MappingException {
            this.manyToOne.createPropertyRefConstraints(map);
        }
    }

    static class MapSecondPass
    extends CollectionSecondPass {
        MapSecondPass(Element element, Mappings mappings, Map map, java.util.Map map2) {
            super(element, mappings, map, map2);
        }

        public void secondPass(java.util.Map map, java.util.Map map2) throws MappingException {
            HbmBinder.bindMapSecondPass(this.node, (Map)this.collection, map, this.mappings, map2);
        }
    }
}

