/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.DefaultNamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.JACCConfiguration;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SerializationHelper;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Configuration
implements Serializable {
    private static Log log = LogFactory.getLog((Class)Configuration.class);
    protected Map classes;
    protected Map imports;
    protected Map collections;
    protected Map tables;
    protected List auxiliaryDatabaseObjects;
    protected Map sqlFunctions;
    protected Map namedQueries;
    protected Map namedSqlQueries;
    protected Map sqlResultSetMappings;
    protected Map filterDefinitions;
    protected List secondPasses;
    protected List propertyReferences;
    protected Map extendsQueue;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected transient Map typeDefs;
    protected NamingStrategy namingStrategy;
    private EventListeners eventListeners;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();

    protected void reset() {
        this.classes = new HashMap();
        this.imports = new HashMap();
        this.collections = new HashMap();
        this.tables = new TreeMap();
        this.namedQueries = new HashMap();
        this.namedSqlQueries = new HashMap();
        this.sqlResultSetMappings = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.typeDefs = new HashMap();
        this.propertyReferences = new ArrayList();
        this.secondPasses = new ArrayList();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.eventListeners = new EventListeners();
        this.filterDefinitions = new HashMap();
        this.extendsQueue = new HashMap();
        this.auxiliaryDatabaseObjects = new ArrayList();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.namingStrategy = DefaultNamingStrategy.INSTANCE;
        this.sqlFunctions = new HashMap();
    }

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    public Iterator getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator getTableMappings() {
        return this.tables.values().iterator();
    }

    public PersistentClass getClassMapping(String string) {
        return (PersistentClass)this.classes.get(string);
    }

    public Collection getCollectionMapping(String string) {
        return (Collection)this.collections.get(string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String string) throws MappingException {
        return this.addFile(new File(string));
    }

    public Configuration addFile(File file) throws MappingException {
        log.info((Object)("Reading mappings from file: " + file.getPath()));
        if (!file.exists()) {
            throw new MappingNotFoundException("file", file.toString());
        }
        try {
            ArrayList arrayList = new ArrayList();
            Document document = this.xmlHelper.createSAXReader(file.toString(), arrayList, this.entityResolver).read(file);
            if (arrayList.size() != 0) {
                throw new InvalidMappingException("file", file.toString(), (Throwable)arrayList.get(0));
            }
            this.add(document);
            return this;
        }
        catch (InvalidMappingException invalidMappingException) {
            throw invalidMappingException;
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            throw mappingNotFoundException;
        }
        catch (Exception exception) {
            throw new InvalidMappingException("file", file.toString(), exception);
        }
    }

    public Configuration addCacheableFile(File file) throws MappingException {
        try {
            boolean bl;
            File file2 = new File(file.getAbsolutePath() + ".bin");
            Document document = null;
            boolean bl2 = bl = file.exists() && file2.exists() && file.lastModified() < file2.lastModified();
            if (bl) {
                try {
                    log.info((Object)("Reading mappings from cache file: " + file2));
                    document = (Document)SerializationHelper.deserialize(new FileInputStream(file2));
                }
                catch (SerializationException serializationException) {
                    log.warn((Object)("Could not deserialize cache file: " + file2.getPath()), (Throwable)serializationException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.warn((Object)("I/O reported cached file could not be found : " + file2.getPath()), (Throwable)fileNotFoundException);
                }
            }
            if (document == null) {
                if (!file.exists()) {
                    throw new MappingNotFoundException("file", file.toString());
                }
                log.info((Object)("Reading mappings from file: " + file));
                ArrayList arrayList = new ArrayList();
                try {
                    document = this.xmlHelper.createSAXReader(file.getAbsolutePath(), arrayList, this.entityResolver).read(file);
                    if (arrayList.size() != 0) {
                        throw new MappingException("invalid mapping", (Throwable)arrayList.get(0));
                    }
                }
                catch (DocumentException documentException) {
                    throw new MappingException("invalid mapping", documentException);
                }
                try {
                    log.debug((Object)("Writing cache file for: " + file + " to: " + file2));
                    SerializationHelper.serialize((Serializable)document, new FileOutputStream(file2));
                }
                catch (SerializationException serializationException) {
                    log.warn((Object)("Could not write cached file: " + file2), (Throwable)serializationException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.warn((Object)("I/O reported error writing cached file : " + file2.getPath()), (Throwable)fileNotFoundException);
                }
            }
            this.add(document);
            return this;
        }
        catch (InvalidMappingException invalidMappingException) {
            throw invalidMappingException;
        }
        catch (MappingNotFoundException mappingNotFoundException) {
            throw mappingNotFoundException;
        }
        catch (Exception exception) {
            throw new InvalidMappingException("file", file.toString(), exception);
        }
    }

    public Configuration addCacheableFile(String string) throws MappingException {
        return this.addCacheableFile(new File(string));
    }

    public Configuration addXML(String string) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping XML:\n" + string));
        }
        try {
            ArrayList arrayList = new ArrayList();
            Document document = this.xmlHelper.createSAXReader("XML String", arrayList, this.entityResolver).read((Reader)new StringReader(string));
            if (arrayList.size() != 0) {
                throw new MappingException("invalid mapping", (Throwable)arrayList.get(0));
            }
            this.add(document);
        }
        catch (DocumentException documentException) {
            throw new MappingException("Could not parse mapping document in XML string", documentException);
        }
        return this;
    }

    public Configuration addURL(URL uRL) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading mapping document from URL:" + uRL.toExternalForm()));
        }
        try {
            this.addInputStream(uRL.openStream());
        }
        catch (InvalidMappingException invalidMappingException) {
            throw new InvalidMappingException("URL", uRL.toExternalForm(), invalidMappingException.getCause());
        }
        catch (Exception exception) {
            throw new InvalidMappingException("URL", uRL.toExternalForm(), exception);
        }
        return this;
    }

    public Configuration addDocument(org.w3c.dom.Document document) throws MappingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping document:\n" + document));
        }
        this.add(this.xmlHelper.createDOMReader().read(document));
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration addInputStream(InputStream inputStream) throws MappingException {
        Configuration configuration;
        try {
            try {
                ArrayList arrayList = new ArrayList();
                Document document = this.xmlHelper.createSAXReader("XML InputStream", arrayList, this.entityResolver).read(new InputSource(inputStream));
                if (arrayList.size() != 0) {
                    throw new InvalidMappingException("invalid mapping", null, (Throwable)arrayList.get(0));
                }
                this.add(document);
                configuration = this;
                Object var6_6 = null;
            }
            catch (DocumentException documentException) {
                throw new InvalidMappingException("input stream", null, documentException);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                log.warn((Object)"Could not close input stream", (Throwable)iOException);
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            log.warn((Object)"Could not close input stream", (Throwable)iOException);
            return configuration;
        }
        inputStream.close();
        return configuration;
    }

    public Configuration addResource(String string, ClassLoader classLoader) throws MappingException {
        log.info((Object)("Reading mappings from resource: " + string));
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        try {
            return this.addInputStream(inputStream);
        }
        catch (MappingException mappingException) {
            throw new InvalidMappingException("resource", string, mappingException);
        }
    }

    public Configuration addResource(String string) throws MappingException {
        log.info((Object)("Reading mappings from resource : " + string));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        if (classLoader != null) {
            inputStream = classLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = Environment.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            throw new MappingNotFoundException("resource", string);
        }
        try {
            return this.addInputStream(inputStream);
        }
        catch (MappingException mappingException) {
            throw new InvalidMappingException("resource", string, mappingException);
        }
    }

    public Configuration addClass(Class clazz) throws MappingException {
        String string = clazz.getName().replace('.', '/') + ".hbm.xml";
        log.info((Object)("Reading mappings from resource: " + string));
        return this.addResource(string, clazz.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration addJar(File file) throws MappingException {
        log.info((Object)("Searching for mapping documents in jar: " + file.getName()));
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), iOException);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".hbm.xml")) continue;
                log.info((Object)("Found mapping document in jar: " + zipEntry.getName()));
                try {
                    this.addInputStream(jarFile.getInputStream(zipEntry));
                }
                catch (Exception exception) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + file.getName(), "jar", file.getName(), exception);
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                log.error((Object)"could not close jar", (Throwable)iOException);
            }
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            log.error((Object)"could not close jar", (Throwable)iOException);
        }
        return this;
    }

    public Configuration addDirectory(File file) throws MappingException {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.addDirectory(fileArray[i]);
                continue;
            }
            if (!fileArray[i].getName().endsWith(".hbm.xml")) continue;
            this.addFile(fileArray[i]);
        }
        return this;
    }

    protected void add(Document document) throws MappingException {
        HbmBinder.bindRoot(document, this.createMappings(), CollectionHelper.EMPTY_MAP);
    }

    public Mappings createMappings() {
        return new Mappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.sqlResultSetMappings, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.extendsQueue, this.auxiliaryDatabaseObjects, this.tableNameBinding, this.columnNameBindingPerTable);
    }

    private Iterator iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator identifierGenerator;
        Filterable filterable;
        TreeMap<Object, IdentifierGenerator> treeMap = new TreeMap<Object, IdentifierGenerator>();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            filterable = (PersistentClass)iterator.next();
            if (((PersistentClass)filterable).isInherited() || !((identifierGenerator = ((PersistentClass)filterable).getIdentifier().createIdentifierGenerator(dialect, string, string2, (RootClass)filterable)) instanceof PersistentIdentifierGenerator)) continue;
            treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
        }
        iterator = this.collections.values().iterator();
        while (iterator.hasNext()) {
            filterable = (Collection)iterator.next();
            if (!((Collection)filterable).isIdentified() || !((identifierGenerator = ((IdentifierCollection)filterable).getIdentifier().createIdentifierGenerator(dialect, string, string2, null)) instanceof PersistentIdentifierGenerator)) continue;
            treeMap.put(((PersistentIdentifierGenerator)identifierGenerator).generatorKey(), identifierGenerator);
        }
        return treeMap.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Object object;
        Object object2;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> arrayList = new ArrayList<String>(50);
        ListIterator listIterator = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (listIterator.hasPrevious()) {
            object2 = (AuxiliaryDatabaseObject)listIterator.previous();
            if (!object2.appliesToDialect(dialect)) continue;
            arrayList.add(object2.sqlDropString(dialect, string, string2));
        }
        if (dialect.dropConstraints()) {
            object2 = this.getTableMappings();
            while (object2.hasNext()) {
                object = (String[])object2.next();
                if (!object.isPhysicalTable()) continue;
                Iterator iterator = object.getForeignKeyIterator();
                while (iterator.hasNext()) {
                    ForeignKey foreignKey = (ForeignKey)iterator.next();
                    if (!foreignKey.isPhysicalConstraint()) continue;
                    arrayList.add(foreignKey.sqlDropString(dialect, string, string2));
                }
            }
        }
        object2 = this.getTableMappings();
        while (object2.hasNext()) {
            object = (Table)object2.next();
            if (!object.isPhysicalTable()) continue;
            arrayList.add(object.sqlDropString(dialect, string, string2));
        }
        object2 = this.iterateGenerators(dialect);
        while (object2.hasNext()) {
            object = ((PersistentIdentifierGenerator)object2.next()).sqlDropStrings(dialect);
            for (int i = 0; i < ((String[])object).length; ++i) {
                arrayList.add(object[i]);
            }
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Iterator iterator;
        Object object;
        this.secondPassCompile();
        ArrayList<String> arrayList = new ArrayList<String>(50);
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator iterator2 = this.getTableMappings();
        while (iterator2.hasNext()) {
            object = (Table)iterator2.next();
            if (!object.isPhysicalTable()) continue;
            arrayList.add(object.sqlCreateString(dialect, this.mapping, string, string2));
            iterator = object.sqlCommentStrings(dialect, string, string2);
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        iterator2 = this.getTableMappings();
        while (iterator2.hasNext()) {
            RelationalModel relationalModel;
            object = (Table)iterator2.next();
            if (!object.isPhysicalTable()) continue;
            if (!dialect.supportsUniqueConstraintInCreateAlterTable()) {
                iterator = object.getUniqueKeyIterator();
                while (iterator.hasNext()) {
                    relationalModel = (UniqueKey)iterator.next();
                    String string3 = ((UniqueKey)relationalModel).sqlCreateString(dialect, this.mapping, string, string2);
                    if (string3 == null) continue;
                    arrayList.add(string3);
                }
            }
            iterator = object.getIndexIterator();
            while (iterator.hasNext()) {
                relationalModel = (Index)iterator.next();
                arrayList.add(((Index)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
            if (!dialect.hasAlterTable()) continue;
            iterator = object.getForeignKeyIterator();
            while (iterator.hasNext()) {
                relationalModel = (ForeignKey)iterator.next();
                if (!((ForeignKey)relationalModel).isPhysicalConstraint()) continue;
                arrayList.add(((Constraint)relationalModel).sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator2 = this.iterateGenerators(dialect);
        while (iterator2.hasNext()) {
            object = ((PersistentIdentifierGenerator)iterator2.next()).sqlCreateStrings(dialect);
            for (int i = 0; i < ((String[])object).length; ++i) {
                arrayList.add(object[i]);
            }
        }
        object = this.auxiliaryDatabaseObjects.iterator();
        while (object.hasNext()) {
            AuxiliaryDatabaseObject auxiliaryDatabaseObject = (AuxiliaryDatabaseObject)object.next();
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            arrayList.add(auxiliaryDatabaseObject.sqlCreateString(dialect, this.mapping, string, string2));
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Object object;
        Object object2;
        Object object3;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        ArrayList<Object> arrayList = new ArrayList<Object>(50);
        Iterator iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object3 = (Table)iterator.next();
            if (!((Table)object3).isPhysicalTable()) continue;
            object2 = databaseMetadata.getTableMetadata(((Table)object3).getName(), ((Table)object3).getSchema() == null ? string2 : ((Table)object3).getSchema(), ((Table)object3).getCatalog() == null ? string : ((Table)object3).getCatalog(), ((Table)object3).isQuoted());
            if (object2 == null) {
                arrayList.add(((Table)object3).sqlCreateString(dialect, this.mapping, string, string2));
            } else {
                object = ((Table)object3).sqlAlterStrings(dialect, this.mapping, (TableMetadata)object2, string, string2);
                while (object.hasNext()) {
                    arrayList.add(object.next());
                }
            }
            object = ((Table)object3).sqlCommentStrings(dialect, string, string2);
            while (object.hasNext()) {
                arrayList.add(object.next());
            }
        }
        iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object3 = (Table)iterator.next();
            if (!((Table)object3).isPhysicalTable()) continue;
            object2 = databaseMetadata.getTableMetadata(((Table)object3).getName(), ((Table)object3).getSchema(), ((Table)object3).getCatalog(), ((Table)object3).isQuoted());
            if (!dialect.hasAlterTable()) continue;
            object = ((Table)object3).getForeignKeyIterator();
            while (object.hasNext()) {
                boolean bl;
                ForeignKey foreignKey = (ForeignKey)object.next();
                if (!foreignKey.isPhysicalConstraint() || !(bl = object2 == null || ((TableMetadata)object2).getForeignKeyMetadata(foreignKey.getName()) == null && (!(dialect instanceof MySQLDialect) || ((TableMetadata)object2).getIndexMetadata(foreignKey.getName()) == null))) continue;
                arrayList.add(foreignKey.sqlCreateString(dialect, this.mapping, string, string2));
            }
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object3 = (PersistentIdentifierGenerator)iterator.next();
            object2 = object3.generatorKey();
            if (databaseMetadata.isSequence(object2) || databaseMetadata.isTable(object2)) continue;
            object = object3.sqlCreateStrings(dialect);
            for (int i = 0; i < ((Object)object).length; ++i) {
                arrayList.add(object[i]);
            }
        }
        return ArrayHelper.toStringArray(arrayList);
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Object object;
        Object object2;
        this.secondPassCompile();
        String string = this.properties.getProperty("hibernate.default_catalog");
        String string2 = this.properties.getProperty("hibernate.default_schema");
        Iterator iterator = this.getTableMappings();
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            if (!((Table)object2).isPhysicalTable()) continue;
            object = databaseMetadata.getTableMetadata(((Table)object2).getName(), ((Table)object2).getSchema() == null ? string2 : ((Table)object2).getSchema(), ((Table)object2).getCatalog() == null ? string : ((Table)object2).getCatalog(), ((Table)object2).isQuoted());
            if (object == null) {
                throw new HibernateException("Missing table: " + ((Table)object2).getName());
            }
            ((Table)object2).validateColumns(dialect, this.mapping, (TableMetadata)object);
        }
        iterator = this.iterateGenerators(dialect);
        while (iterator.hasNext()) {
            object2 = (PersistentIdentifierGenerator)iterator.next();
            object = object2.generatorKey();
            if (databaseMetadata.isSequence(object) || databaseMetadata.isTable(object)) continue;
            throw new HibernateException("Missing sequence or table: " + object);
        }
    }

    private void validate() throws MappingException {
        Iterator iterator = this.classes.values().iterator();
        while (iterator.hasNext()) {
            ((PersistentClass)iterator.next()).validate(this.mapping);
        }
        iterator = this.collections.values().iterator();
        while (iterator.hasNext()) {
            ((Collection)iterator.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        Serializable serializable;
        log.debug((Object)"processing extends queue");
        this.processExtendsQueue();
        log.debug((Object)"processing collection mappings");
        Iterator iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            serializable = (SecondPass)iterator.next();
            if (serializable instanceof QuerySecondPass) continue;
            serializable.doSecondPass(this.classes);
            iterator.remove();
        }
        log.debug((Object)"processing native query and ResultSetMapping mappings");
        iterator = this.secondPasses.iterator();
        while (iterator.hasNext()) {
            serializable = (SecondPass)iterator.next();
            serializable.doSecondPass(this.classes);
            iterator.remove();
        }
        log.debug((Object)"processing association property references");
        iterator = this.propertyReferences.iterator();
        while (iterator.hasNext()) {
            serializable = (Mappings.PropertyReference)iterator.next();
            PersistentClass persistentClass = this.getClassMapping(((Mappings.PropertyReference)serializable).referencedClass);
            if (persistentClass == null) {
                throw new MappingException("property-ref to unmapped class: " + ((Mappings.PropertyReference)serializable).referencedClass);
            }
            Property property = persistentClass.getReferencedProperty(((Mappings.PropertyReference)serializable).propertyName);
            if (!((Mappings.PropertyReference)serializable).unique) continue;
            ((SimpleValue)property.getValue()).setAlternateUniqueKey(true);
        }
        log.debug((Object)"processing foreign key constraints");
        iterator = this.getTableMappings();
        serializable = new HashSet();
        while (iterator.hasNext()) {
            this.secondPassCompileForeignKeys((Table)iterator.next(), (Set)((Object)serializable));
        }
    }

    private void processExtendsQueue() {
        Document document = this.findPossibleExtends();
        while (document != null) {
            this.add(document);
            document = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator iterator = this.extendsQueue.keySet().iterator();
            StringBuffer stringBuffer = new StringBuffer("Following superclasses referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry extendsQueueEntry = (ExtendsQueueEntry)iterator.next();
                stringBuffer.append(extendsQueueEntry.getExplicitName());
                if (extendsQueueEntry.getMappingPackage() != null) {
                    stringBuffer.append("[").append(extendsQueueEntry.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            throw new MappingException(stringBuffer.toString());
        }
    }

    protected Document findPossibleExtends() {
        Iterator iterator = this.extendsQueue.keySet().iterator();
        while (iterator.hasNext()) {
            ExtendsQueueEntry extendsQueueEntry = (ExtendsQueueEntry)iterator.next();
            if (this.getClassMapping(extendsQueueEntry.getExplicitName()) != null) {
                iterator.remove();
                return extendsQueueEntry.getDocument();
            }
            if (this.getClassMapping(HbmBinder.getClassName(extendsQueueEntry.getExplicitName(), extendsQueueEntry.getMappingPackage())) == null) continue;
            iterator.remove();
            return extendsQueueEntry.getDocument();
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set set) throws MappingException {
        table.createForeignKeys();
        Iterator iterator = table.getForeignKeyIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass;
            ForeignKey foreignKey = (ForeignKey)iterator.next();
            if (set.contains(foreignKey)) continue;
            set.add(foreignKey);
            String string = foreignKey.getReferencedEntityName();
            if (string == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " does not specify the referenced entity");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolving reference to class: " + string));
            }
            if ((persistentClass = (PersistentClass)this.classes.get(string)) == null) {
                throw new MappingException("An association from the table " + foreignKey.getTable().getName() + " refers to an unmapped class: " + string);
            }
            if (persistentClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(persistentClass.getSuperclass().getTable(), set);
            }
            foreignKey.setReferencedTable(persistentClass.getTable());
            foreignKey.alignColumns();
        }
    }

    public Map getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug((Object)("Preparing to build session factory with filters : " + this.filterDefinitions));
        this.secondPassCompile();
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        PropertiesHelper.resolvePlaceHolders(properties);
        Settings settings = this.buildSettings(properties);
        return new SessionFactoryImpl(this, this.mapping, settings, this.getInitializedEventListeners());
    }

    private EventListeners getInitializedEventListeners() {
        EventListeners eventListeners = (EventListeners)this.eventListeners.shallowCopy();
        eventListeners.initializeListeners(this);
        return eventListeners;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
        return this;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    private void addProperties(Element element) {
        Iterator iterator = element.elementIterator("property");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string = element2.attributeValue("name");
            String string2 = element2.getText().trim();
            log.debug((Object)(string + "=" + string2));
            this.properties.setProperty(string, string2);
            if (string.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + string, string2);
        }
        Environment.verifyProperties(this.properties);
    }

    protected InputStream getConfigurationInputStream(String string) throws HibernateException {
        log.info((Object)("Configuration resource: " + string));
        return ConfigHelper.getResourceAsStream(string);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String string) throws HibernateException {
        log.info((Object)("configuring from resource: " + string));
        InputStream inputStream = this.getConfigurationInputStream(string);
        return this.doConfigure(inputStream, string);
    }

    public Configuration configure(URL uRL) throws HibernateException {
        log.info((Object)("configuring from url: " + uRL.toString()));
        try {
            return this.doConfigure(uRL.openStream(), uRL.toString());
        }
        catch (IOException iOException) {
            throw new HibernateException("could not configure from URL: " + uRL, iOException);
        }
    }

    public Configuration configure(File file) throws HibernateException {
        log.info((Object)("configuring from file: " + file.getName()));
        try {
            return this.doConfigure(new FileInputStream(file), file.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HibernateException("could not find file: " + file, fileNotFoundException);
        }
    }

    /*
     * Loose catch block
     */
    protected Configuration doConfigure(InputStream inputStream, String string) throws HibernateException {
        Document document;
        block8: {
            ArrayList arrayList = new ArrayList();
            document = this.xmlHelper.createSAXReader(string, arrayList, this.entityResolver).read(new InputSource(inputStream));
            if (arrayList.size() != 0) {
                throw new MappingException("invalid configuration", (Throwable)arrayList.get(0));
            }
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn((Object)("could not close input stream for: " + string), (Throwable)iOException);
            }
            break block8;
            {
                catch (DocumentException documentException) {
                    throw new HibernateException("Could not parse configuration: " + string, documentException);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    log.warn((Object)("could not close input stream for: " + string), (Throwable)iOException);
                }
                throw throwable;
            }
        }
        return this.doConfigure(document);
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        log.info((Object)"configuring from XML document");
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(Document document) throws HibernateException {
        Element element = document.getRootElement().element("session-factory");
        String string = element.attributeValue("name");
        if (string != null) {
            this.properties.setProperty("hibernate.session_factory_name", string);
        }
        this.addProperties(element);
        this.parseSessionFactory(element, string);
        Element element2 = document.getRootElement().element("security");
        if (element2 != null) {
            this.parseSecurity(element2);
        }
        log.info((Object)("Configured SessionFactory: " + string));
        log.debug((Object)("properties: " + this.properties));
        return this;
    }

    private void parseSessionFactory(Element element, String string) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            String string2;
            Attribute attribute;
            String string3;
            Element element2 = (Element)iterator.next();
            String string4 = element2.getName();
            if ("mapping".equals(string4)) {
                this.parseMappingElement(element2, string);
                continue;
            }
            if ("class-cache".equals(string4)) {
                string3 = element2.attributeValue("class");
                attribute = element2.attribute("region");
                string2 = attribute == null ? string3 : attribute.getValue();
                boolean bl = !"non-lazy".equals(element2.attributeValue("include"));
                this.setCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2, bl);
                continue;
            }
            if ("collection-cache".equals(string4)) {
                string3 = element2.attributeValue("collection");
                attribute = element2.attribute("region");
                string2 = attribute == null ? string3 : attribute.getValue();
                this.setCollectionCacheConcurrencyStrategy(string3, element2.attributeValue("usage"), string2);
                continue;
            }
            if ("listener".equals(string4)) {
                this.parseListener(element2);
                continue;
            }
            if (!"event".equals(string4)) continue;
            this.parseEvent(element2);
        }
    }

    protected void parseMappingElement(Element element, String string) {
        Attribute attribute = element.attribute("resource");
        Attribute attribute2 = element.attribute("file");
        Attribute attribute3 = element.attribute("jar");
        Attribute attribute4 = element.attribute("package");
        Attribute attribute5 = element.attribute("class");
        if (attribute != null) {
            log.debug((Object)(string + "<-" + attribute));
            this.addResource(attribute.getValue());
        } else if (attribute3 != null) {
            log.debug((Object)(string + "<-" + attribute3));
            this.addJar(new File(attribute3.getValue()));
        } else {
            if (attribute4 != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping package=\"" + attribute4.getValue() + "\"/>");
            }
            if (attribute5 != null) {
                throw new MappingException("An AnnotationConfiguration instance is required to use <mapping class=\"" + attribute5.getValue() + "\"/>");
            }
            if (attribute2 == null) {
                throw new MappingException("<mapping> element in configuration specifies no attributes");
            }
            log.debug((Object)(string + "<-" + attribute2));
            this.addFile(attribute2.getValue());
        }
    }

    private void parseSecurity(Element element) {
        String string = element.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", string);
        log.info((Object)("JACC contextID: " + string));
        JACCConfiguration jACCConfiguration = new JACCConfiguration(string);
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            String string2 = element2.getName();
            if (!"grant".equals(string2)) continue;
            jACCConfiguration.addPermission(element2.attributeValue("role"), element2.attributeValue("entity-name"), element2.attributeValue("actions"));
        }
    }

    private void parseEvent(Element element) {
        String string = element.attributeValue("type");
        List list = element.elements();
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = ((Element)list.get(i)).attributeValue("class");
        }
        log.debug((Object)("Event listeners: " + string + "=" + StringHelper.toString(objectArray)));
        this.setListeners(string, (String[])objectArray);
    }

    private void parseListener(Element element) {
        String string = element.attributeValue("type");
        if (string == null) {
            throw new MappingException("No type specified for listener");
        }
        String string2 = element.attributeValue("class");
        log.debug((Object)("Event listener: " + string + "=" + string2));
        this.setListeners(string, new String[]{string2});
    }

    public void setListeners(String string, String[] stringArray) {
        Object[] objectArray = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(string), stringArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                objectArray[i] = ReflectHelper.classForName(stringArray[i]).newInstance();
                continue;
            }
            catch (Exception exception) {
                throw new MappingException("Unable to instantiate specified event (" + string + ") listener class: " + stringArray[i], exception);
            }
        }
        this.setListeners(string, objectArray);
    }

    public void setListener(String string, Object object) {
        if (object == null) {
            this.setListener(string, null);
        } else {
            Object[] objectArray = (Object[])Array.newInstance(this.eventListeners.getListenerClassFor(string), 1);
            objectArray[0] = object;
            this.setListeners(string, objectArray);
        }
    }

    public void setListeners(String string, Object[] objectArray) {
        if ("auto-flush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setAutoFlushEventListeners(new AutoFlushEventListener[0]);
            } else {
                this.eventListeners.setAutoFlushEventListeners((AutoFlushEventListener[])objectArray);
            }
        } else if ("merge".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setMergeEventListeners(new MergeEventListener[0]);
            } else {
                this.eventListeners.setMergeEventListeners((MergeEventListener[])objectArray);
            }
        } else if ("create".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPersistEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistEventListeners((PersistEventListener[])objectArray);
            }
        } else if ("create-onflush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPersistOnFlushEventListeners(new PersistEventListener[0]);
            } else {
                this.eventListeners.setPersistOnFlushEventListeners((PersistEventListener[])objectArray);
            }
        } else if ("delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setDeleteEventListeners(new DeleteEventListener[0]);
            } else {
                this.eventListeners.setDeleteEventListeners((DeleteEventListener[])objectArray);
            }
        } else if ("dirty-check".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setDirtyCheckEventListeners(new DirtyCheckEventListener[0]);
            } else {
                this.eventListeners.setDirtyCheckEventListeners((DirtyCheckEventListener[])objectArray);
            }
        } else if ("evict".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setEvictEventListeners(new EvictEventListener[0]);
            } else {
                this.eventListeners.setEvictEventListeners((EvictEventListener[])objectArray);
            }
        } else if ("flush".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setFlushEventListeners(new FlushEventListener[0]);
            } else {
                this.eventListeners.setFlushEventListeners((FlushEventListener[])objectArray);
            }
        } else if ("flush-entity".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setFlushEntityEventListeners(new FlushEntityEventListener[0]);
            } else {
                this.eventListeners.setFlushEntityEventListeners((FlushEntityEventListener[])objectArray);
            }
        } else if ("load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setLoadEventListeners(new LoadEventListener[0]);
            } else {
                this.eventListeners.setLoadEventListeners((LoadEventListener[])objectArray);
            }
        } else if ("load-collection".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setInitializeCollectionEventListeners(new InitializeCollectionEventListener[0]);
            } else {
                this.eventListeners.setInitializeCollectionEventListeners((InitializeCollectionEventListener[])objectArray);
            }
        } else if ("lock".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setLockEventListeners(new LockEventListener[0]);
            } else {
                this.eventListeners.setLockEventListeners((LockEventListener[])objectArray);
            }
        } else if ("refresh".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setRefreshEventListeners(new RefreshEventListener[0]);
            } else {
                this.eventListeners.setRefreshEventListeners((RefreshEventListener[])objectArray);
            }
        } else if ("replicate".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setReplicateEventListeners(new ReplicateEventListener[0]);
            } else {
                this.eventListeners.setReplicateEventListeners((ReplicateEventListener[])objectArray);
            }
        } else if ("save-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setSaveOrUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveOrUpdateEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("save".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setSaveEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setSaveEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setUpdateEventListeners(new SaveOrUpdateEventListener[0]);
            } else {
                this.eventListeners.setUpdateEventListeners((SaveOrUpdateEventListener[])objectArray);
            }
        } else if ("pre-load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreLoadEventListeners(new PreLoadEventListener[0]);
            } else {
                this.eventListeners.setPreLoadEventListeners((PreLoadEventListener[])objectArray);
            }
        } else if ("pre-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreUpdateEventListeners(new PreUpdateEventListener[0]);
            } else {
                this.eventListeners.setPreUpdateEventListeners((PreUpdateEventListener[])objectArray);
            }
        } else if ("pre-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreDeleteEventListeners(new PreDeleteEventListener[0]);
            } else {
                this.eventListeners.setPreDeleteEventListeners((PreDeleteEventListener[])objectArray);
            }
        } else if ("pre-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPreInsertEventListeners(new PreInsertEventListener[0]);
            } else {
                this.eventListeners.setPreInsertEventListeners((PreInsertEventListener[])objectArray);
            }
        } else if ("post-load".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostLoadEventListeners(new PostLoadEventListener[0]);
            } else {
                this.eventListeners.setPostLoadEventListeners((PostLoadEventListener[])objectArray);
            }
        } else if ("post-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostUpdateEventListeners((PostUpdateEventListener[])objectArray);
            }
        } else if ("post-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostDeleteEventListeners((PostDeleteEventListener[])objectArray);
            }
        } else if ("post-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostInsertEventListeners((PostInsertEventListener[])objectArray);
            }
        } else if ("post-commit-update".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitUpdateEventListeners(new PostUpdateEventListener[0]);
            } else {
                this.eventListeners.setPostCommitUpdateEventListeners((PostUpdateEventListener[])objectArray);
            }
        } else if ("post-commit-delete".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitDeleteEventListeners(new PostDeleteEventListener[0]);
            } else {
                this.eventListeners.setPostCommitDeleteEventListeners((PostDeleteEventListener[])objectArray);
            }
        } else if ("post-commit-insert".equals(string)) {
            if (objectArray == null) {
                this.eventListeners.setPostCommitInsertEventListeners(new PostInsertEventListener[0]);
            } else {
                this.eventListeners.setPostCommitInsertEventListeners((PostInsertEventListener[])objectArray);
            }
        } else {
            log.warn((Object)("Unrecognized listener type [" + string + "]"));
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    RootClass getRootClassMapping(String string) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(string);
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String string, String string2) throws MappingException {
        this.setCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public void setCacheConcurrencyStrategy(String string, String string2, String string3) throws MappingException {
        this.setCacheConcurrencyStrategy(string, string2, string3, true);
    }

    void setCacheConcurrencyStrategy(String string, String string2, String string3, boolean bl) throws MappingException {
        RootClass rootClass = this.getRootClassMapping(string);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + string);
        }
        rootClass.setCacheConcurrencyStrategy(string2);
        rootClass.setCacheRegionName(string3);
        rootClass.setLazyPropertiesCacheable(bl);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String string, String string2) throws MappingException {
        this.setCollectionCacheConcurrencyStrategy(string, string2, string);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String string, String string2, String string3) throws MappingException {
        Collection collection = this.getCollectionMapping(string);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + string);
        }
        collection.setCacheConcurrencyStrategy(string2);
        collection.setCacheRegionName(string3);
    }

    public Map getImports() {
        return this.imports;
    }

    public Settings buildSettings() throws HibernateException {
        Properties properties = (Properties)this.properties.clone();
        PropertiesHelper.resolvePlaceHolders(properties);
        return this.settingsFactory.buildSettings(properties);
    }

    public Settings buildSettings(Properties properties) throws HibernateException {
        return this.settingsFactory.buildSettings(properties);
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            public Type getIdentifierType(String string) throws MappingException {
                PersistentClass persistentClass = (PersistentClass)Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                return persistentClass.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String string) throws MappingException {
                PersistentClass persistentClass = (PersistentClass)Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                if (!persistentClass.hasIdentifierProperty()) {
                    return null;
                }
                return persistentClass.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String string, String string2) throws MappingException {
                PersistentClass persistentClass = (PersistentClass)Configuration.this.classes.get(string);
                if (persistentClass == null) {
                    throw new MappingException("persistent class not known: " + string);
                }
                Property property = persistentClass.getReferencedProperty(string2);
                if (property == null) {
                    throw new MappingException("property not known: " + string + '.' + string2);
                }
                return property.getType();
            }
        };
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition filterDefinition) {
        this.filterDefinitions.put(filterDefinition.getFilterName(), filterDefinition);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
        this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String string, SQLFunction sQLFunction) {
        this.sqlFunctions.put(string, sQLFunction);
    }
}

