/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.entry;

import java.io.Serializable;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.util.ArrayHelper;

public class CollectionCacheEntry
implements Serializable {
    private final Serializable state;

    public Serializable[] getState() {
        return (Serializable[])this.state;
    }

    public CollectionCacheEntry(PersistentCollection persistentCollection, CollectionPersister collectionPersister) {
        this.state = persistentCollection.disassemble(collectionPersister);
    }

    CollectionCacheEntry(Serializable serializable) {
        this.state = serializable;
    }

    public void assemble(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Object object) {
        persistentCollection.initializeFromCache(collectionPersister, this.state, object);
        persistentCollection.afterInitialize();
    }

    public String toString() {
        return "CollectionCacheEntry" + ArrayHelper.toString(this.getState());
    }
}

