/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.entry;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public final class CacheEntry
implements Serializable {
    private final Serializable[] disassembledState;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;
    private final Object version;

    public String getSubclass() {
        return this.subclass;
    }

    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    public CacheEntry(Object[] objectArray, EntityPersister entityPersister, boolean bl, Object object, SessionImplementor sessionImplementor, Object object2) throws HibernateException {
        this.disassembledState = TypeFactory.disassemble(objectArray, entityPersister.getPropertyTypes(), entityPersister.isLazyPropertiesCacheable() ? null : entityPersister.getPropertyLaziness(), sessionImplementor, object2);
        this.subclass = entityPersister.getEntityName();
        this.lazyPropertiesAreUnfetched = bl || !entityPersister.isLazyPropertiesCacheable();
        this.version = object;
    }

    public Object getVersion() {
        return this.version;
    }

    CacheEntry(Serializable[] serializableArray, String string, boolean bl, Object object) {
        this.disassembledState = serializableArray;
        this.subclass = string;
        this.lazyPropertiesAreUnfetched = bl;
        this.version = object;
    }

    public Object[] assemble(Object object, Serializable serializable, EntityPersister entityPersister, Interceptor interceptor, EventSource eventSource) throws HibernateException {
        if (!entityPersister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return CacheEntry.assemble(this.disassembledState, object, serializable, entityPersister, interceptor, eventSource);
    }

    private static Object[] assemble(Serializable[] serializableArray, Object object, Serializable serializable, EntityPersister entityPersister, Interceptor interceptor, EventSource eventSource) throws HibernateException {
        Object[] objectArray = TypeFactory.assemble(serializableArray, entityPersister.getPropertyTypes(), eventSource, object);
        PreLoadEvent preLoadEvent = new PreLoadEvent(eventSource).setEntity(object).setState(objectArray).setId(serializable).setPersister(entityPersister);
        PreLoadEventListener[] preLoadEventListenerArray = eventSource.getListeners().getPreLoadEventListeners();
        for (int i = 0; i < preLoadEventListenerArray.length; ++i) {
            preLoadEventListenerArray[i].onPreLoad(preLoadEvent);
        }
        entityPersister.setPropertyValues(object, objectArray, eventSource.getEntityMode());
        return objectArray;
    }

    public Serializable[] getDisassembledState() {
        return this.disassembledState;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.disassembledState);
    }
}

