/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Settings;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final Log log = LogFactory.getLog((Class)UpdateTimestampsCache.class);
    private Cache updateTimestamps;
    private final String regionName;

    public void clear() throws CacheException {
        this.updateTimestamps.clear();
    }

    public UpdateTimestampsCache(Settings settings, Properties properties) throws HibernateException {
        String string = settings.getCacheRegionPrefix();
        this.regionName = string == null ? REGION_NAME : string + '.' + REGION_NAME;
        log.info((Object)("starting update timestamps cache at region: " + this.regionName));
        this.updateTimestamps = settings.getCacheProvider().buildCache(this.regionName, properties);
    }

    public synchronized void preinvalidate(Serializable[] serializableArray) throws CacheException {
        Long l = new Long(this.updateTimestamps.nextTimestamp() + (long)this.updateTimestamps.getTimeout());
        for (int i = 0; i < serializableArray.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pre-invalidating space [" + serializableArray[i] + "]"));
            }
            this.updateTimestamps.put(serializableArray[i], l);
        }
    }

    public synchronized void invalidate(Serializable[] serializableArray) throws CacheException {
        Long l = new Long(this.updateTimestamps.nextTimestamp());
        for (int i = 0; i < serializableArray.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalidating space [" + serializableArray[i] + "], timestamp: " + l));
            }
            this.updateTimestamps.put(serializableArray[i], l);
        }
    }

    public synchronized boolean isUpToDate(Set set, Long l) throws HibernateException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Serializable serializable = (Serializable)iterator.next();
            Long l2 = (Long)this.updateTimestamps.get(serializable);
            if (l2 == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + serializable + "] last update timestamp: " + l2 + ", result set timestamp: " + l));
            }
            if (l2 < l) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        try {
            this.updateTimestamps.destroy();
        }
        catch (Exception exception) {
            log.warn((Object)"could not destroy UpdateTimestamps cache", (Throwable)exception);
        }
    }

    public Cache getCache() {
        return this.updateTimestamps;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String toString() {
        return "UpdateTimestampeCache";
    }
}

