/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.TreeCache;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TransactionManagerLookup;

public class TreeCacheProvider
implements CacheProvider {
    public static final String CONFIG_RESOURCE = "hibernate.cache.tree_cache.config";
    public static final String DEFAULT_CONFIG = "treecache.xml";
    private static final Log log = LogFactory.getLog((Class)TreeCacheProvider.class);
    private org.jboss.cache.TreeCache cache;
    private TransactionManager transactionManager;

    public Cache buildCache(String string, Properties properties) throws CacheException {
        return new TreeCache(this.cache, string, this.transactionManager);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) {
        String string = properties.getProperty("hibernate.cache.provider_configuration_file_resource_path");
        if (string == null) {
            string = properties.getProperty(CONFIG_RESOURCE);
        }
        if (string == null) {
            string = DEFAULT_CONFIG;
        }
        log.debug((Object)("Configuring TreeCache from resource [" + string + "]"));
        try {
            this.cache = new org.jboss.cache.TreeCache();
            PropertyConfigurator propertyConfigurator = new PropertyConfigurator();
            propertyConfigurator.configure((Object)this.cache, string);
            org.hibernate.transaction.TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
            if (transactionManagerLookup != null) {
                this.cache.setTransactionManagerLookup((TransactionManagerLookup)new TransactionManagerLookupAdaptor(transactionManagerLookup, properties));
                this.transactionManager = transactionManagerLookup.getTransactionManager(properties);
            }
            this.cache.start();
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public org.jboss.cache.TreeCache getUnderlyingCache() {
        return this.cache;
    }

    static final class TransactionManagerLookupAdaptor
    implements TransactionManagerLookup {
        private final org.hibernate.transaction.TransactionManagerLookup tml;
        private final Properties props;

        TransactionManagerLookupAdaptor(org.hibernate.transaction.TransactionManagerLookup transactionManagerLookup, Properties properties) {
            this.tml = transactionManagerLookup;
            this.props = properties;
        }

        public TransactionManager getTransactionManager() throws Exception {
            return this.tml.getTransactionManager(this.props);
        }
    }
}

