/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.lock.TimeoutException;

public class TreeCache
implements Cache {
    private static final Log log = LogFactory.getLog((Class)TreeCache.class);
    private static final String ITEM = "item";
    private org.jboss.cache.TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private final TransactionManager transactionManager;

    public TreeCache(org.jboss.cache.TreeCache treeCache, String string, TransactionManager transactionManager) throws CacheException {
        this.cache = treeCache;
        this.regionName = string;
        this.regionFqn = Fqn.fromString((String)string.replace('.', '/'));
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws CacheException {
        Transaction transaction = this.suspend();
        try {
            Object object2 = this.read(object);
            return object2;
        }
        finally {
            this.resume(transaction);
        }
    }

    public Object read(Object object) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, object), (Object)ITEM);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void update(Object object, Object object2) throws CacheException {
        try {
            this.cache.put(new Fqn(this.regionFqn, object), (Object)ITEM, object2);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void put(Object object, Object object2) throws CacheException {
        Transaction transaction = this.suspend();
        try {
            this.cache.putFailFast(new Fqn(this.regionFqn, object), (Object)ITEM, object2, 0L);
        }
        catch (TimeoutException timeoutException) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
        finally {
            this.resume(transaction);
        }
    }

    private void resume(Transaction transaction) {
        try {
            if (transaction != null) {
                this.transactionManager.resume(transaction);
            }
        }
        catch (Exception exception) {
            throw new CacheException("Could not resume transaction", exception);
        }
    }

    private Transaction suspend() {
        Transaction transaction = null;
        try {
            if (this.transactionManager != null) {
                transaction = this.transactionManager.suspend();
            }
        }
        catch (SystemException systemException) {
            throw new CacheException("Could not suspend transaction", (Exception)((Object)systemException));
        }
        return transaction;
    }

    public void remove(Object object) throws CacheException {
        try {
            this.cache.remove(new Fqn(this.regionFqn, object));
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.remove(this.regionFqn);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cache.evict(this.regionFqn);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void lock(Object object) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object object) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set set = this.cache.getChildrenNames(this.regionFqn);
            return set == null ? 0L : (long)set.size();
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap hashMap = new HashMap();
            Set set = this.cache.getChildrenNames(this.regionFqn);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    hashMap.put(e, this.cache.get(new Fqn(this.regionFqn, e), (Object)ITEM));
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public String toString() {
        return "TreeCache(" + this.regionName + ')';
    }
}

