/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog((Class)TransactionalCache.class);
    private Cache cache;

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public Object get(Object object, long l) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cache lookup: " + object));
        }
        Object object2 = this.cache.read(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)(object2 == null ? "cache miss" : "cache hit"));
        }
        return object2;
    }

    public boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (bl && this.cache.read(object) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("item already cached: " + object));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching: " + object));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeLoad(object, object2, object3);
        } else {
            this.cache.put(object, object2);
        }
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object object, Object object2) throws CacheException {
        return null;
    }

    public void release(Object object, CacheConcurrencyStrategy.SoftLock softLock) throws CacheException {
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + object));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeUpdate(object, object2, object3, object4);
        } else {
            this.cache.update(object, object2);
        }
        return true;
    }

    public boolean insert(Object object, Object object2, Object object3) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserting: " + object));
        }
        if (this.cache instanceof OptimisticCache) {
            ((OptimisticCache)this.cache).writeInsert(object, object2, object3);
        } else {
            this.cache.update(object, object2);
        }
        return true;
    }

    public void evict(Object object) throws CacheException {
        this.cache.remove(object);
    }

    public void remove(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing: " + object));
        }
        this.cache.remove(object);
    }

    public void clear() throws CacheException {
        log.debug((Object)"clearing");
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn((Object)"could not destroy cache", (Throwable)exception);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        return false;
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, CacheConcurrencyStrategy.SoftLock softLock) throws CacheException {
        return false;
    }

    public String toString() {
        return this.cache + "(transactional)";
    }
}

