/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Map;
import net.sf.swarmcache.ObjectCache;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;

public class SwarmCache
implements Cache {
    private final ObjectCache cache;
    private final String regionName;

    public SwarmCache(ObjectCache objectCache, String string) {
        this.cache = objectCache;
        this.regionName = string;
    }

    public Object get(Object object) throws CacheException {
        if (object instanceof Serializable) {
            return this.cache.get((Serializable)object);
        }
        throw new CacheException("Keys must implement Serializable");
    }

    public Object read(Object object) throws CacheException {
        return this.get(object);
    }

    public void update(Object object, Object object2) throws CacheException {
        this.put(object, object2);
    }

    public void put(Object object, Object object2) throws CacheException {
        if (!(object instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.put((Serializable)object, object2);
    }

    public void remove(Object object) throws CacheException {
        if (!(object instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.clear((Serializable)object);
    }

    public void clear() throws CacheException {
        this.cache.clearAll();
    }

    public void destroy() throws CacheException {
        this.cache.clearAll();
    }

    public void lock(Object object) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public void unlock(Object object) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SwarmCache(" + this.regionName + ')';
    }
}

