/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.QueryKey;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class StandardQueryCache
implements QueryCache {
    private static final Log log = LogFactory.getLog((Class)StandardQueryCache.class);
    private Cache queryCache;
    private UpdateTimestampsCache updateTimestampsCache;
    private final String regionName;

    public void clear() throws CacheException {
        this.queryCache.clear();
    }

    public StandardQueryCache(Settings settings, Properties properties, UpdateTimestampsCache updateTimestampsCache, String string) throws HibernateException {
        String string2;
        if (string == null) {
            string = StandardQueryCache.class.getName();
        }
        if ((string2 = settings.getCacheRegionPrefix()) != null) {
            string = string2 + '.' + string;
        }
        log.info((Object)("starting query cache at region: " + string));
        this.queryCache = settings.getCacheProvider().buildCache(string, properties);
        this.updateTimestampsCache = updateTimestampsCache;
        this.regionName = string;
    }

    public boolean put(QueryKey queryKey, Type[] typeArray, List list, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (bl && list.size() == 0) {
            return false;
        }
        Long l = new Long(sessionImplementor.getTimestamp());
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching query results in region: " + this.regionName + "; timestamp=" + l));
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
        arrayList.add(l);
        for (int i = 0; i < list.size(); ++i) {
            if (typeArray.length == 1) {
                arrayList.add(typeArray[0].disassemble(list.get(i), sessionImplementor, null));
                continue;
            }
            arrayList.add(TypeFactory.disassemble((Object[])list.get(i), typeArray, null, sessionImplementor, null));
        }
        this.queryCache.put(queryKey, arrayList);
        return true;
    }

    public List get(QueryKey queryKey, Type[] typeArray, boolean bl, Set set, SessionImplementor sessionImplementor) throws HibernateException {
        List list;
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking cached query results in region: " + this.regionName));
        }
        if ((list = (List)this.queryCache.get(queryKey)) == null) {
            log.debug((Object)"query results were not found in cache");
            return null;
        }
        Long l = (Long)list.get(0);
        if (!bl && !this.isUpToDate(set, l)) {
            log.debug((Object)"cached query results were not up to date");
            return null;
        }
        log.debug((Object)"returning cached query results");
        for (int i = 1; i < list.size(); ++i) {
            if (typeArray.length == 1) {
                typeArray[0].beforeAssemble((Serializable)list.get(i), sessionImplementor);
                continue;
            }
            TypeFactory.beforeAssemble((Serializable[])list.get(i), typeArray, sessionImplementor);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() - 1);
        for (int i = 1; i < list.size(); ++i) {
            try {
                if (typeArray.length == 1) {
                    arrayList.add(typeArray[0].assemble((Serializable)list.get(i), sessionImplementor, null));
                    continue;
                }
                arrayList.add(TypeFactory.assemble((Serializable[])list.get(i), typeArray, sessionImplementor, null));
                continue;
            }
            catch (UnresolvableObjectException unresolvableObjectException) {
                if (bl) {
                    log.debug((Object)"could not reassemble cached result set");
                    this.queryCache.remove(queryKey);
                    return null;
                }
                throw unresolvableObjectException;
            }
        }
        return arrayList;
    }

    protected boolean isUpToDate(Set set, Long l) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking query spaces for up-to-dateness: " + set));
        }
        return this.updateTimestampsCache.isUpToDate(set, l);
    }

    public void destroy() {
        try {
            this.queryCache.destroy();
        }
        catch (Exception exception) {
            log.warn((Object)("could not destroy query cache: " + this.regionName), (Throwable)exception);
        }
    }

    public Cache getCache() {
        return this.queryCache;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String toString() {
        return "StandardQueryCache(" + this.regionName + ')';
    }
}

