/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;
import org.hibernate.util.EqualsHelper;

public class QueryKey
implements Serializable {
    private final String sqlQueryString;
    private final Type[] types;
    private final Object[] values;
    private final Integer firstRow;
    private final Integer maxRows;
    private final Map namedParameters;
    private final EntityMode entityMode;
    private final Set filters;
    private final int hashCode;
    private final ResultTransformer customTransformer;

    public QueryKey(String string, QueryParameters queryParameters, Set set, EntityMode entityMode) {
        this.sqlQueryString = string;
        this.types = queryParameters.getPositionalParameterTypes();
        this.values = queryParameters.getPositionalParameterValues();
        RowSelection rowSelection = queryParameters.getRowSelection();
        if (rowSelection != null) {
            this.firstRow = rowSelection.getFirstRow();
            this.maxRows = rowSelection.getMaxRows();
        } else {
            this.firstRow = null;
            this.maxRows = null;
        }
        this.namedParameters = queryParameters.getNamedParameters();
        this.entityMode = entityMode;
        this.filters = set;
        this.customTransformer = queryParameters.getResultTransformer();
        this.hashCode = this.getHashCode();
    }

    public boolean equals(Object object) {
        QueryKey queryKey = (QueryKey)object;
        if (!this.sqlQueryString.equals(queryKey.sqlQueryString)) {
            return false;
        }
        if (!EqualsHelper.equals(this.firstRow, queryKey.firstRow) || !EqualsHelper.equals(this.maxRows, queryKey.maxRows)) {
            return false;
        }
        if (!EqualsHelper.equals(this.customTransformer, queryKey.customTransformer)) {
            return false;
        }
        if (this.types == null) {
            if (queryKey.types != null) {
                return false;
            }
        } else {
            if (queryKey.types == null) {
                return false;
            }
            if (this.types.length != queryKey.types.length) {
                return false;
            }
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i].getReturnedClass() != queryKey.types[i].getReturnedClass()) {
                    return false;
                }
                if (this.types[i].isEqual(this.values[i], queryKey.values[i], this.entityMode)) continue;
                return false;
            }
        }
        if (!EqualsHelper.equals(this.filters, queryKey.filters)) {
            return false;
        }
        return EqualsHelper.equals(this.namedParameters, queryKey.namedParameters);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int getHashCode() {
        int n = 13;
        n = 37 * n + (this.firstRow == null ? 0 : this.firstRow.hashCode());
        n = 37 * n + (this.maxRows == null ? 0 : this.maxRows.hashCode());
        for (int i = 0; i < this.values.length; ++i) {
            n = 37 * n + (this.values[i] == null ? 0 : this.types[i].getHashCode(this.values[i], this.entityMode));
        }
        n = 37 * n + (this.namedParameters == null ? 0 : ((Object)this.namedParameters).hashCode());
        n = 37 * n + (this.filters == null ? 0 : ((Object)this.filters).hashCode());
        n = 37 * n + (this.customTransformer == null ? 0 : this.customTransformer.hashCode());
        n = 37 * n + this.sqlQueryString.hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("sql: ").append(this.sqlQueryString);
        if (this.values != null) {
            stringBuffer.append("; parameters: ");
            for (int i = 0; i < this.values.length; ++i) {
                stringBuffer.append(this.values[i]).append(", ");
            }
        }
        if (this.namedParameters != null) {
            stringBuffer.append("; named parameters: ").append(this.namedParameters);
        }
        if (this.filters != null) {
            stringBuffer.append("; filters: ").append(this.filters);
        }
        if (this.firstRow != null) {
            stringBuffer.append("; first row: ").append(this.firstRow);
        }
        if (this.maxRows != null) {
            stringBuffer.append("; max rows: ").append(this.maxRows);
        }
        if (this.customTransformer != null) {
            stringBuffer.append("; transformer: ").append(this.customTransformer);
        }
        return stringBuffer.toString();
    }
}

