/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.OptimisticCache;
import org.hibernate.cache.OptimisticCacheSource;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;

public class OptimisticTreeCache
implements OptimisticCache {
    private static final Log log = LogFactory.getLog((Class)OptimisticTreeCache.class);
    private static final String ITEM = "item";
    private TreeCache cache;
    private final String regionName;
    private final Fqn regionFqn;
    private OptimisticCacheSource source;

    public OptimisticTreeCache(TreeCache treeCache, String string) throws CacheException {
        this.cache = treeCache;
        this.regionName = string;
        this.regionFqn = Fqn.fromString((String)string.replace('.', '/'));
    }

    public void setSource(OptimisticCacheSource optimisticCacheSource) {
        this.source = optimisticCacheSource;
    }

    public void writeInsert(Object object, Object object2, Object object3) {
        this.writeUpdate(object, object2, object3, null);
    }

    public void writeUpdate(Object object, Object object2, Object object3, Object object4) {
        try {
            Option option = new Option();
            DataVersion dataVersion = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(object3, object4, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dataVersion);
            this.cache.put(new Fqn(this.regionFqn, object), (Object)ITEM, object2, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void writeLoad(Object object, Object object2, Object object3) {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(new Fqn(this.regionFqn, object), (Object)"ITEM", option);
            option = new Option();
            option.setFailSilently(true);
            DataVersion dataVersion = this.source != null && this.source.isVersioned() ? new DataVersionAdapter(object3, object3, this.source.getVersionComparator(), this.source.toString()) : NonLockingDataVersion.INSTANCE;
            option.setDataVersion(dataVersion);
            this.cache.put(new Fqn(this.regionFqn, object), (Object)ITEM, object2, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public Object get(Object object) throws CacheException {
        try {
            Option option = new Option();
            option.setFailSilently(true);
            return this.cache.get(new Fqn(this.regionFqn, object), (Object)ITEM, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public Object read(Object object) throws CacheException {
        try {
            return this.cache.get(new Fqn(this.regionFqn, object), (Object)ITEM);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void update(Object object, Object object2) throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.put(new Fqn(this.regionFqn, object), (Object)ITEM, object2, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void put(Object object, Object object2) throws CacheException {
        try {
            log.trace((Object)("performing put() into region [" + this.regionName + "]"));
            Option option = new Option();
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.put(new Fqn(this.regionFqn, object), (Object)ITEM, object2, option);
        }
        catch (TimeoutException timeoutException) {
            log.debug((Object)"ignoring write lock acquisition failure");
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void remove(Object object) throws CacheException {
        try {
            if (this.cache.get(new Fqn(this.regionFqn, object), (Object)ITEM) != null) {
                Option option = new Option();
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
                this.cache.remove(new Fqn(this.regionFqn, object), option);
            } else {
                log.trace((Object)"skipping remove() call as the underlying node did not seem to exist");
            }
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void clear() throws CacheException {
        try {
            Option option = new Option();
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(this.regionFqn, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            option.setDataVersion(NonLockingDataVersion.INSTANCE);
            this.cache.remove(this.regionFqn, option);
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public void lock(Object object) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object object) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            Set set = this.cache.getChildrenNames(this.regionFqn);
            return set == null ? 0L : (long)set.size();
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map toMap() {
        try {
            HashMap hashMap = new HashMap();
            Set set = this.cache.getChildrenNames(this.regionFqn);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    hashMap.put(e, this.cache.get(new Fqn(this.regionFqn, e), (Object)ITEM));
                }
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public String toString() {
        return "OptimisticTreeCache(" + this.regionName + ')';
    }

    public static class CircumventChecksDataVersion
    implements DataVersion {
        public static final DataVersion INSTANCE = new CircumventChecksDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            throw new CacheException("optimistic locking checks should never happen on CircumventChecksDataVersion");
        }
    }

    public static class DataVersionAdapter
    implements DataVersion {
        private final Object currentVersion;
        private final Object previousVersion;
        private final Comparator versionComparator;
        private final String sourceIdentifer;

        public DataVersionAdapter(Object object, Object object2, Comparator comparator, String string) {
            this.currentVersion = object;
            this.previousVersion = object2;
            this.versionComparator = comparator;
            this.sourceIdentifer = string;
            log.trace((Object)("created " + this));
        }

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)("checking [" + this + "] against [" + dataVersion + "]"));
            if (dataVersion instanceof CircumventChecksDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            if (dataVersion instanceof NonLockingDataVersion) {
                log.trace((Object)"skipping lock checks...");
                return false;
            }
            DataVersionAdapter dataVersionAdapter = (DataVersionAdapter)dataVersion;
            if (dataVersionAdapter.previousVersion == null) {
                log.warn((Object)"Unexpected optimistic lock check on inserting data");
                if (this == dataVersion) {
                    log.trace((Object)"skipping lock checks due to same DV instance");
                    return false;
                }
            }
            return this.versionComparator.compare(this.currentVersion, dataVersionAdapter.previousVersion) >= 1;
        }

        public String toString() {
            return super.toString() + " [current=" + this.currentVersion + ", previous=" + this.previousVersion + ", src=" + this.sourceIdentifer + "]";
        }
    }

    public static class NonLockingDataVersion
    implements DataVersion {
        public static final DataVersion INSTANCE = new NonLockingDataVersion();

        public boolean newerThan(DataVersion dataVersion) {
            log.trace((Object)"non locking lock check...");
            return false;
        }
    }
}

