/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import com.opensymphony.oscache.base.Config;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.OSCache;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;

public class OSCacheProvider
implements CacheProvider {
    public static final String OSCACHE_REFRESH_PERIOD = "refresh.period";
    public static final String OSCACHE_CRON = "cron";
    public static final String OSCACHE_CAPACITY = "capacity";
    private static final Properties OSCACHE_PROPERTIES = new Config().getProperties();

    public Cache buildCache(String string, Properties properties) throws CacheException {
        int n = PropertiesHelper.getInt(StringHelper.qualify(string, OSCACHE_REFRESH_PERIOD), OSCACHE_PROPERTIES, -1);
        String string2 = OSCACHE_PROPERTIES.getProperty(StringHelper.qualify(string, OSCACHE_CRON));
        OSCache oSCache = new OSCache(n, string2, string);
        Integer n2 = PropertiesHelper.getInteger(StringHelper.qualify(string, OSCACHE_CAPACITY), OSCACHE_PROPERTIES);
        if (n2 != null) {
            oSCache.setCacheCapacity(n2);
        }
        return oSCache;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
    }

    public void stop() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

