/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Map;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class OSCache
implements Cache {
    private GeneralCacheAdministrator cache = new GeneralCacheAdministrator();
    private final int refreshPeriod;
    private final String cron;
    private final String regionName;

    private String toString(Object object) {
        return String.valueOf(object) + '.' + this.regionName;
    }

    public OSCache(int n, String string, String string2) {
        this.refreshPeriod = n;
        this.cron = string;
        this.regionName = string2;
    }

    public void setCacheCapacity(int n) {
        this.cache.setCacheCapacity(n);
    }

    public Object get(Object object) throws CacheException {
        try {
            return this.cache.getFromCache(this.toString(object), this.refreshPeriod, this.cron);
        }
        catch (NeedsRefreshException needsRefreshException) {
            this.cache.cancelUpdate(this.toString(object));
            return null;
        }
    }

    public Object read(Object object) throws CacheException {
        return this.get(object);
    }

    public void update(Object object, Object object2) throws CacheException {
        this.put(object, object2);
    }

    public void put(Object object, Object object2) throws CacheException {
        this.cache.putInCache(this.toString(object), object2);
    }

    public void remove(Object object) throws CacheException {
        this.cache.flushEntry(this.toString(object));
    }

    public void clear() throws CacheException {
        this.cache.flushAll();
    }

    public void destroy() throws CacheException {
        this.cache.destroy();
    }

    public void lock(Object object) throws CacheException {
    }

    public void unlock(Object object) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "OSCache(" + this.regionName + ')';
    }
}

