/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;

public class NonstrictReadWriteCache
implements CacheConcurrencyStrategy {
    private Cache cache;
    private static final Log log = LogFactory.getLog((Class)NonstrictReadWriteCache.class);

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Object get(Object object, long l) throws CacheException {
        Object object2;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache lookup: " + object));
        }
        if ((object2 = this.cache.get(object)) != null) {
            log.debug((Object)"Cache hit");
        } else {
            log.debug((Object)"Cache miss");
        }
        return object2;
    }

    public boolean put(Object object, Object object2, long l, Object object3, Comparator comparator, boolean bl) throws CacheException {
        if (bl && this.cache.get(object) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("item already cached: " + object));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Caching: " + object));
        }
        this.cache.put(object, object2);
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object object, Object object2) throws CacheException {
        return null;
    }

    public void remove(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing: " + object));
        }
        this.cache.remove(object);
    }

    public void clear() throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clearing");
        }
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception exception) {
            log.warn((Object)"could not destroy cache", (Throwable)exception);
        }
    }

    public void evict(Object object) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating: " + object));
        }
        this.cache.remove(object);
    }

    public boolean insert(Object object, Object object2, Object object3) {
        return false;
    }

    public boolean update(Object object, Object object2, Object object3, Object object4) {
        this.evict(object);
        return false;
    }

    public void release(Object object, CacheConcurrencyStrategy.SoftLock softLock) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invalidating (again): " + object));
        }
        this.cache.remove(object);
    }

    public boolean afterUpdate(Object object, Object object2, Object object3, CacheConcurrencyStrategy.SoftLock softLock) throws CacheException {
        this.release(object, softLock);
        return false;
    }

    public boolean afterInsert(Object object, Object object2, Object object3) throws CacheException {
        return false;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    public String toString() {
        return this.cache + "(nonstrict-read-write)";
    }
}

