/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.EntityMode;
import org.hibernate.engine.TypedValue;
import org.hibernate.impl.FilterImpl;
import org.hibernate.type.Type;

public final class FilterKey
implements Serializable {
    private String filterName;
    private Map filterParameters = new HashMap();

    public FilterKey(String string, Map map, Map map2, EntityMode entityMode) {
        this.filterName = string;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Type type = (Type)map2.get(entry.getKey());
            this.filterParameters.put(entry.getKey(), new TypedValue(type, entry.getValue(), entityMode));
        }
    }

    public int hashCode() {
        int n = 13;
        n = 37 * n + this.filterName.hashCode();
        n = 37 * n + ((Object)this.filterParameters).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterKey)) {
            return false;
        }
        FilterKey filterKey = (FilterKey)object;
        if (!filterKey.filterName.equals(this.filterName)) {
            return false;
        }
        return ((Object)filterKey.filterParameters).equals(this.filterParameters);
    }

    public String toString() {
        return "FilterKey[" + this.filterName + this.filterParameters + ']';
    }

    public static Set createFilterKeys(Map map, EntityMode entityMode) {
        if (map.size() == 0) {
            return null;
        }
        HashSet<FilterKey> hashSet = new HashSet<FilterKey>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            FilterImpl filterImpl = (FilterImpl)iterator.next();
            FilterKey filterKey = new FilterKey(filterImpl.getName(), filterImpl.getParameters(), filterImpl.getFilterDefinition().getParameterTypes(), entityMode);
            hashSet.add(filterKey);
        }
        return hashSet;
    }
}

