/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.EhCache;
import org.hibernate.cache.Timestamper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.StringHelper;

public class EhCacheProvider
implements CacheProvider {
    private static final Log log = LogFactory.getLog((Class)EhCacheProvider.class);
    private CacheManager manager;

    public Cache buildCache(String string, Properties properties) throws CacheException {
        try {
            net.sf.ehcache.Cache cache = this.manager.getCache(string);
            if (cache == null) {
                log.warn((Object)("Could not find configuration [" + string + "]; using defaults."));
                this.manager.addCache(string);
                cache = this.manager.getCache(string);
                log.debug((Object)("started EHCache region: " + string));
            }
            return new EhCache(cache);
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void start(Properties properties) throws CacheException {
        if (this.manager != null) {
            log.warn((Object)"Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Using previously created EhCacheProvider. If this behaviour is required, consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.");
            return;
        }
        try {
            String string = null;
            if (properties != null) {
                string = (String)properties.get("hibernate.cache.provider_configuration_file_resource_path");
            }
            if (StringHelper.isEmpty(string)) {
                this.manager = new CacheManager();
            } else {
                URL uRL = this.loadResource(string);
                this.manager = new CacheManager(uRL);
            }
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            if (cacheException.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheProvider. Use sessionFactory.close()  between repeated calls to buildSessionFactory. Consider using net.sf.ehcache.hibernate.SingletonEhCacheProvider.", (Exception)((Object)cacheException));
            }
            throw cacheException;
        }
    }

    private URL loadResource(String string) {
        URL uRL = ConfigHelper.locateConfig(string);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating EhCacheProvider from a specified resource: " + string + " Resolved to URL: " + uRL));
        }
        return uRL;
    }

    public void stop() {
        if (this.manager != null) {
            this.manager.shutdown();
            this.manager = null;
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return false;
    }
}

