/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.ehcache.Element;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Timestamper;

public class EhCache
implements Cache {
    private static final Log log = LogFactory.getLog((Class)EhCache.class);
    private static final int SIXTY_THOUSAND_MS = 60000;
    private net.sf.ehcache.Cache cache;

    public EhCache(net.sf.ehcache.Cache cache) {
        this.cache = cache;
    }

    public Object get(Object object) throws CacheException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("key: " + object));
            }
            if (object == null) {
                return null;
            }
            Element element = this.cache.get(object);
            if (element == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Element for " + object + " is null"));
                }
                return null;
            }
            return element.getObjectValue();
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public Object read(Object object) throws CacheException {
        return this.get(object);
    }

    public void update(Object object, Object object2) throws CacheException {
        this.put(object, object2);
    }

    public void put(Object object, Object object2) throws CacheException {
        try {
            Element element = new Element(object, object2);
            this.cache.put(element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CacheException(illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new CacheException(illegalStateException);
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public void remove(Object object) throws CacheException {
        try {
            this.cache.remove(object);
        }
        catch (ClassCastException classCastException) {
            throw new CacheException(classCastException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new CacheException(illegalStateException);
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public void clear() throws CacheException {
        try {
            this.cache.removeAll();
        }
        catch (IllegalStateException illegalStateException) {
            throw new CacheException(illegalStateException);
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cache.getCacheManager().removeCache(this.cache.getName());
        }
        catch (IllegalStateException illegalStateException) {
            throw new CacheException(illegalStateException);
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public void lock(Object object) throws CacheException {
    }

    public void unlock(Object object) throws CacheException {
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public int getTimeout() {
        return 245760000;
    }

    public String getRegionName() {
        return this.cache.getName();
    }

    public long getSizeInMemory() {
        try {
            return this.cache.calculateInMemorySize();
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public long getElementCountInMemory() {
        try {
            return this.cache.getMemoryStoreSize();
        }
        catch (net.sf.ehcache.CacheException cacheException) {
            throw new CacheException((Exception)((Object)cacheException));
        }
    }

    public long getElementCountOnDisk() {
        return this.cache.getDiskStoreSize();
    }

    public Map toMap() {
        try {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.cache.getKeys().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                hashMap.put(e, this.cache.get(e).getObjectValue());
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new CacheException(exception);
        }
    }

    public String toString() {
        return "EHCache(" + this.getRegionName() + ')';
    }
}

