/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class CacheKey
implements Serializable {
    private final Serializable key;
    private final Type type;
    private final String entityOrRoleName;
    private final EntityMode entityMode;
    private final int hashCode;

    public CacheKey(Serializable serializable, Type type, String string, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) {
        this.key = serializable;
        this.type = type;
        this.entityOrRoleName = string;
        this.entityMode = entityMode;
        this.hashCode = type.getHashCode(this.key, entityMode, sessionFactoryImplementor);
    }

    public String toString() {
        return this.entityOrRoleName + '#' + this.key.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        return this.type.isEqual(this.key, cacheKey.key, this.entityMode) && this.entityOrRoleName.equals(cacheKey.entityOrRoleName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Serializable getKey() {
        return this.key;
    }

    public String getEntityOrRoleName() {
        return this.entityOrRoleName;
    }
}

