/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.NonstrictReadWriteCache;
import org.hibernate.cache.ReadOnlyCache;
import org.hibernate.cache.ReadWriteCache;
import org.hibernate.cache.TransactionalCache;
import org.hibernate.cfg.Settings;

public final class CacheFactory {
    private static final Log log = LogFactory.getLog((Class)CacheFactory.class);
    public static final String READ_ONLY = "read-only";
    public static final String READ_WRITE = "read-write";
    public static final String NONSTRICT_READ_WRITE = "nonstrict-read-write";
    public static final String TRANSACTIONAL = "transactional";

    private CacheFactory() {
    }

    public static CacheConcurrencyStrategy createCache(String string, String string2, boolean bl, Settings settings, Properties properties) throws HibernateException {
        Cache cache;
        CacheConcurrencyStrategy cacheConcurrencyStrategy;
        if (string == null || !settings.isSecondLevelCacheEnabled()) {
            return null;
        }
        String string3 = settings.getCacheRegionPrefix();
        if (string3 != null) {
            string2 = string3 + '.' + string2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("instantiating cache region: " + string2 + " usage strategy: " + string));
        }
        if (string.equals(READ_ONLY)) {
            if (bl) {
                log.warn((Object)("read-only cache configured for mutable class: " + string2));
            }
            cacheConcurrencyStrategy = new ReadOnlyCache();
        } else if (string.equals(READ_WRITE)) {
            cacheConcurrencyStrategy = new ReadWriteCache();
        } else if (string.equals(NONSTRICT_READ_WRITE)) {
            cacheConcurrencyStrategy = new NonstrictReadWriteCache();
        } else if (string.equals(TRANSACTIONAL)) {
            cacheConcurrencyStrategy = new TransactionalCache();
        } else {
            throw new MappingException("cache usage attribute should be read-write, read-only, nonstrict-read-write or transactional");
        }
        try {
            cache = settings.getCacheProvider().buildCache(string2, properties);
        }
        catch (CacheException cacheException) {
            throw new HibernateException("Could not instantiate cache implementation", cacheException);
        }
        cacheConcurrencyStrategy.setCache(cache);
        return cacheConcurrencyStrategy;
    }
}

