/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final Log log = LogFactory.getLog((Class)AbstractJndiBoundCacheProvider.class);
    private Object cache;

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    public final void start(Properties properties) throws CacheException {
        String string = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(string)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(string, NamingHelper.getJndiProperties(properties));
        this.prepare(properties);
    }

    public final void stop() {
        this.release();
        this.cache = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object locateCache(String string, Properties properties) {
        Object object;
        InitialContext initialContext = null;
        try {
            try {
                initialContext = new InitialContext(properties);
                object = initialContext.lookup(string);
                Object var7_6 = null;
                if (initialContext == null) return object;
            }
            catch (NamingException namingException) {
                String string2 = "Unable to retreive Cache from JNDI [" + string + "]";
                log.info((Object)string2, (Throwable)namingException);
                throw new CacheException(string2);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (initialContext == null) throw throwable;
            try {
                initialContext.close();
                throw throwable;
            }
            catch (NamingException namingException2) {
                log.info((Object)"Unable to release initial context", (Throwable)namingException2);
                throw throwable;
            }
        }
        try {}
        catch (NamingException namingException) {
            log.info((Object)"Unable to release initial context", (Throwable)namingException);
            return object;
        }
        initialContext.close();
        return object;
    }

    public Object getCache() {
        return this.cache;
    }
}

