/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.util;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.util.ClassFilter;

public class BasicClassFilter
implements ClassFilter {
    private final String[] includedPackages;
    private final Set includedClassNames = new HashSet();
    private final boolean isAllEmpty;

    public BasicClassFilter() {
        this(null, null);
    }

    public BasicClassFilter(String[] stringArray, String[] stringArray2) {
        this.includedPackages = stringArray;
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.includedClassNames.add(stringArray2[i]);
            }
        }
        this.isAllEmpty = (this.includedPackages == null || this.includedPackages.length == 0) && this.includedClassNames.isEmpty();
    }

    public boolean shouldInstrumentClass(String string) {
        if (this.isAllEmpty) {
            return true;
        }
        if (this.includedClassNames.contains(string)) {
            return true;
        }
        return this.isInIncludedPackage(string);
    }

    private boolean isInIncludedPackage(String string) {
        if (this.includedPackages != null) {
            for (int i = 0; i < this.includedPackages.length; ++i) {
                if (!string.startsWith(this.includedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }
}

