/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.ProtectionDomain;
import javassist.bytecode.ClassFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.javassist.FieldFilter;
import org.hibernate.bytecode.javassist.FieldTransformer;
import org.hibernate.bytecode.util.ClassFilter;

public class JavassistClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog((String)JavassistClassTransformer.class.getName());
    static /* synthetic */ Class class$org$hibernate$bytecode$javassist$FieldHandled;

    public JavassistClassTransformer(ClassFilter classFilter, org.hibernate.bytecode.util.FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doTransform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        byte[] byArray2;
        ClassFile classFile;
        try {
            classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (IOException iOException) {
            log.error((Object)("Unable to build enhancement metamodel for " + string));
            return byArray;
        }
        FieldTransformer fieldTransformer = this.getFieldTransformer(classFile);
        if (fieldTransformer == null) return byArray;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enhancing " + string));
        }
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                fieldTransformer.transform(classFile);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                classFile.write((DataOutputStream)filterOutputStream);
                byArray2 = byteArrayOutputStream.toByteArray();
                Object var12_13 = null;
            }
            catch (Exception exception) {
                log.error((Object)"Unable to transform class", (Throwable)exception);
                throw new HibernateException("Unable to transform class: " + exception.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (filterOutputStream == null) throw throwable;
                filterOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return byArray2;
        }
        if (filterOutputStream == null) return byArray2;
        filterOutputStream.close();
        return byArray2;
    }

    protected FieldTransformer getFieldTransformer(final ClassFile classFile) {
        if (this.alreadyInstrumented(classFile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleWrite(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldInstrumentField(classFile.getName(), string2);
            }

            public boolean handleReadAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }

            public boolean handleWriteAccess(String string, String string2) {
                return JavassistClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classFile.getName(), string, string2);
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classFile) {
        String[] stringArray = classFile.getInterfaces();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(class$org$hibernate$bytecode$javassist$FieldHandled == null ? JavassistClassTransformer.class$("org.hibernate.bytecode.javassist.FieldHandled") : class$org$hibernate$bytecode$javassist$FieldHandled).getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

