/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.javassist.BulkAccessor;
import org.hibernate.bytecode.javassist.BulkAccessorException;
import org.hibernate.bytecode.javassist.FastClass;
import org.hibernate.bytecode.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.javassist.JavassistClassTransformer;
import org.hibernate.bytecode.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.hibernate.util.StringHelper;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Log log = LogFactory.getLog((Class)BytecodeProviderImpl.class);

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        try {
            fastClass = FastClass.create(clazz);
            bulkAccessor = BulkAccessor.create(clazz, stringArray, stringArray2, classArray);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkAccessor = null;
                } else {
                    Object object = fastClass.newInstance();
                    bulkAccessor.setPropertyValues(object, bulkAccessor.getPropertyValues(object));
                }
            }
        }
        catch (Throwable throwable) {
            int n;
            fastClass = null;
            bulkAccessor = null;
            String string = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(throwable.getClass().getName()) + ": " + throwable.getMessage();
            if (throwable instanceof BulkAccessorException && (n = ((BulkAccessorException)throwable).getIndex()) >= 0) {
                string = string + " (property " + stringArray2[n] + ")";
            }
            log.debug((Object)string);
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }

    public ClassTransformer getTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        return new JavassistClassTransformer(classFilter, fieldFilter);
    }
}

