/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.javassist;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import javassist.CannotCompileException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.util.proxy.FactoryHelper;
import javassist.util.proxy.RuntimeSupport;
import org.hibernate.bytecode.javassist.BulkAccessor;
import org.hibernate.bytecode.javassist.BulkAccessorException;

class BulkAccessorFactory {
    private static final String PACKAGE_NAME_PREFIX = "org.javassist.tmp.";
    private static final String BULKACESSOR_CLASS_NAME = BulkAccessor.class.getName();
    private static final String OBJECT_CLASS_NAME = Object.class.getName();
    private static final String GENERATED_GETTER_NAME = "getPropertyValues";
    private static final String GENERATED_SETTER_NAME = "setPropertyValues";
    private static final String GET_SETTER_DESC = "(Ljava/lang/Object;[Ljava/lang/Object;)V";
    private static final String THROWABLE_CLASS_NAME = Throwable.class.getName();
    private static final String BULKEXCEPTION_CLASS_NAME = BulkAccessorException.class.getName();
    private static int counter = 0;
    private Class targetBean;
    private String[] getterNames;
    private String[] setterNames;
    private Class[] types;
    public String writeDirectory;

    BulkAccessorFactory(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray) {
        this.targetBean = clazz;
        this.getterNames = stringArray;
        this.setterNames = stringArray2;
        this.types = classArray;
        this.writeDirectory = null;
    }

    BulkAccessor create() {
        Method[] methodArray = new Method[this.getterNames.length];
        Method[] methodArray2 = new Method[this.setterNames.length];
        BulkAccessorFactory.findAccessors(this.targetBean, this.getterNames, this.setterNames, this.types, methodArray, methodArray2);
        try {
            ClassFile classFile = this.make(methodArray, methodArray2);
            ClassLoader classLoader = this.getClassLoader();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile((ClassFile)classFile, (String)this.writeDirectory);
            }
            Class clazz = FactoryHelper.toClass((ClassFile)classFile, (ClassLoader)classLoader, (ProtectionDomain)this.getDomain());
            return (BulkAccessor)this.newInstance(clazz);
        }
        catch (Exception exception) {
            throw new BulkAccessorException(exception.getMessage(), exception);
        }
    }

    private ProtectionDomain getDomain() {
        Class<?> clazz = this.targetBean != null ? this.targetBean : this.getClass();
        return clazz.getProtectionDomain();
    }

    private ClassFile make(Method[] methodArray, Method[] methodArray2) throws CannotCompileException {
        String string = this.targetBean.getName();
        if ((string = string + "_$$_bulkaccess_" + counter++).startsWith("java.")) {
            string = PACKAGE_NAME_PREFIX + string;
        }
        ClassFile classFile = new ClassFile(false, string, BULKACESSOR_CLASS_NAME);
        classFile.setAccessFlags(1);
        this.addDefaultConstructor(classFile);
        this.addGetter(classFile, methodArray);
        this.addSetter(classFile, methodArray2);
        return classFile;
    }

    private ClassLoader getClassLoader() {
        if (this.targetBean != null && this.targetBean.getName().equals(OBJECT_CLASS_NAME)) {
            return this.targetBean.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private Object newInstance(Class clazz) throws Exception {
        BulkAccessor bulkAccessor = (BulkAccessor)clazz.newInstance();
        bulkAccessor.target = this.targetBean;
        int n = this.getterNames.length;
        bulkAccessor.getters = new String[n];
        bulkAccessor.setters = new String[n];
        bulkAccessor.types = new Class[n];
        for (int i = 0; i < n; ++i) {
            bulkAccessor.getters[i] = this.getterNames[i];
            bulkAccessor.setters[i] = this.setterNames[i];
            bulkAccessor.types[i] = this.types[i];
        }
        return bulkAccessor;
    }

    private void addDefaultConstructor(ClassFile classFile) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        String string = "()V";
        MethodInfo methodInfo = new MethodInfo(constPool, "<init>", string);
        Bytecode bytecode = new Bytecode(constPool, 0, 1);
        bytecode.addAload(0);
        bytecode.addInvokespecial(BulkAccessor.class.getName(), "<init>", string);
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addGetter(ClassFile classFile, Method[] methodArray) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.addClassInfo(this.targetBean.getName());
        String string = GET_SETTER_DESC;
        MethodInfo methodInfo = new MethodInfo(constPool, GENERATED_GETTER_NAME, string);
        Bytecode bytecode = new Bytecode(constPool, 6, 4);
        if (methodArray.length >= 0) {
            bytecode.addAload(1);
            bytecode.addCheckcast(this.targetBean.getName());
            bytecode.addAstore(3);
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i] == null) continue;
                Method method = methodArray[i];
                bytecode.addAload(2);
                bytecode.addIconst(i);
                Class<?> clazz = method.getReturnType();
                int n2 = -1;
                if (clazz.isPrimitive()) {
                    n2 = FactoryHelper.typeIndex(clazz);
                    bytecode.addNew(FactoryHelper.wrapperTypes[n2]);
                    bytecode.addOpcode(89);
                }
                bytecode.addAload(3);
                String string2 = RuntimeSupport.makeDescriptor((Method)method);
                String string3 = method.getName();
                if (this.targetBean.isInterface()) {
                    bytecode.addInvokeinterface(n, string3, string2, 1);
                } else {
                    bytecode.addInvokevirtual(n, string3, string2);
                }
                if (n2 >= 0) {
                    bytecode.addInvokespecial(FactoryHelper.wrapperTypes[n2], "<init>", FactoryHelper.wrapperDesc[n2]);
                }
                bytecode.add(83);
                bytecode.growStack(-3);
            }
        }
        bytecode.addOpcode(177);
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addSetter(ClassFile classFile, Method[] methodArray) throws CannotCompileException {
        ConstPool constPool = classFile.getConstPool();
        int n = constPool.addClassInfo(this.targetBean.getName());
        String string = GET_SETTER_DESC;
        MethodInfo methodInfo = new MethodInfo(constPool, GENERATED_SETTER_NAME, string);
        Bytecode bytecode = new Bytecode(constPool, 4, 6);
        if (methodArray.length > 0) {
            Object object;
            int n2;
            bytecode.addIconst(0);
            bytecode.addIstore(3);
            bytecode.addAload(1);
            bytecode.addCheckcast(this.targetBean.getName());
            bytecode.addAstore(4);
            int n3 = bytecode.currentPc();
            int n4 = 0;
            for (n2 = 0; n2 < methodArray.length; ++n2) {
                int n5;
                if (methodArray[n2] != null && (n5 = n2 - n4) > 0) {
                    bytecode.addOpcode(132);
                    bytecode.add(3);
                    bytecode.add(n5);
                    n4 = n2;
                }
                bytecode.addAload(4);
                bytecode.addAload(2);
                bytecode.addIconst(n2);
                bytecode.addOpcode(50);
                object = methodArray[n2].getParameterTypes();
                Class<?> clazz = object[0];
                if (clazz.isPrimitive()) {
                    this.addUnwrapper(classFile, bytecode, clazz);
                } else {
                    bytecode.addCheckcast(clazz.getName());
                }
                String string2 = RuntimeSupport.makeDescriptor((Method)methodArray[n2]);
                if (!this.targetBean.isInterface()) {
                    bytecode.addInvokevirtual(n, methodArray[n2].getName(), string2);
                    continue;
                }
                Class<?>[] classArray = methodArray[n2].getParameterTypes();
                int n6 = classArray[0].equals(Double.TYPE) || classArray[0].equals(Long.TYPE) ? 3 : 2;
                bytecode.addInvokeinterface(n, methodArray[n2].getName(), string2, n6);
            }
            int n7 = bytecode.currentPc();
            bytecode.addOpcode(177);
            n2 = constPool.addClassInfo(THROWABLE_CLASS_NAME);
            bytecode.addExceptionHandler(n3, n7, bytecode.currentPc(), n2);
            bytecode.addAstore(5);
            bytecode.addNew(BULKEXCEPTION_CLASS_NAME);
            bytecode.addOpcode(89);
            bytecode.addAload(5);
            bytecode.addIload(3);
            object = "(Ljava/lang/Throwable;I)V";
            bytecode.addInvokespecial(BULKEXCEPTION_CLASS_NAME, "<init>", object);
            bytecode.addOpcode(191);
        } else {
            bytecode.addOpcode(177);
        }
        methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
        methodInfo.setAccessFlags(1);
        classFile.addMethod(methodInfo);
    }

    private void addUnwrapper(ClassFile classFile, Bytecode bytecode, Class clazz) {
        int n = FactoryHelper.typeIndex((Class)clazz);
        String string = FactoryHelper.wrapperTypes[n];
        bytecode.addCheckcast(string);
        bytecode.addInvokevirtual(string, FactoryHelper.unwarpMethods[n], FactoryHelper.unwrapDesc[n]);
    }

    private static void findAccessors(Class clazz, String[] stringArray, String[] stringArray2, Class[] classArray, Method[] methodArray, Method[] methodArray2) {
        int n = classArray.length;
        if (stringArray2.length != n || stringArray.length != n) {
            throw new BulkAccessorException("bad number of accessors");
        }
        Class[] classArray2 = new Class[]{};
        Class[] classArray3 = new Class[1];
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] != null) {
                Method method = BulkAccessorFactory.findAccessor(clazz, stringArray[i], classArray2, i);
                if (method.getReturnType() != classArray[i]) {
                    throw new BulkAccessorException("wrong return type: " + stringArray[i], i);
                }
                methodArray[i] = method;
            }
            if (stringArray2[i] == null) continue;
            classArray3[0] = classArray[i];
            methodArray2[i] = BulkAccessorFactory.findAccessor(clazz, stringArray2[i], classArray3, i);
        }
    }

    private static Method findAccessor(Class clazz, String string, Class[] classArray, int n) throws BulkAccessorException {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkAccessorException("private property", n);
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new BulkAccessorException("cannot find an accessor", n);
        }
    }
}

