/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.cglib.reflect.FastClass;
import org.hibernate.InstantiationException;
import org.hibernate.bytecode.ReflectionOptimizer;

public class InstantiationOptimizerAdapter
implements ReflectionOptimizer.InstantiationOptimizer,
Serializable {
    private FastClass fastClass;

    public InstantiationOptimizerAdapter(FastClass fastClass) {
        this.fastClass = fastClass;
    }

    public Object newInstance() {
        try {
            return this.fastClass.newInstance();
        }
        catch (Throwable throwable) {
            throw new InstantiationException("Could not instantiate entity with CGLIB optimizer: ", this.fastClass.getJavaClass(), throwable);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.fastClass.getJavaClass());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz = (Class)objectInputStream.readObject();
        this.fastClass = FastClass.create((Class)clazz);
    }
}

