/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Attributes;

public class CglibClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog((String)CglibClassTransformer.class.getName());
    static /* synthetic */ Class class$net$sf$cglib$transform$impl$InterceptFieldEnabled;

    public CglibClassTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        ClassReader classReader;
        try {
            classReader = new ClassReader((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            log.error((Object)"Unable to read class", (Throwable)iOException);
            throw new HibernateException("Unable to read class: " + iOException.getMessage());
        }
        String[] stringArray = ClassNameReader.getClassInfo((ClassReader)classReader);
        DebuggingClassWriter debuggingClassWriter = new DebuggingClassWriter(true);
        ClassTransformer classTransformer = this.getClassTransformer(stringArray);
        if (classTransformer != null) {
            byte[] byArray2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enhancing " + string));
            }
            try {
                classReader = new ClassReader((InputStream)new ByteArrayInputStream(byArray));
                new TransformingClassGenerator((ClassGenerator)new ClassReaderGenerator(classReader, this.attributes(), this.skipDebug()), classTransformer).generateClass((ClassVisitor)debuggingClassWriter);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(debuggingClassWriter.toByteArray());
                byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                log.error((Object)"Unable to transform class", (Throwable)exception);
                throw new HibernateException("Unable to transform class: " + exception.getMessage());
            }
            return byArray2;
        }
        return byArray;
    }

    private Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    private boolean skipDebug() {
        return false;
    }

    private ClassTransformer getClassTransformer(final String[] stringArray) {
        if (this.isAlreadyInstrumented(stringArray)) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type type, String string) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(stringArray[0], type.getClassName(), string);
            }

            public boolean acceptWrite(Type type, String string) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(stringArray[0], type.getClassName(), string);
            }
        });
    }

    private boolean isAlreadyInstrumented(String[] stringArray) {
        for (int i = 1; i < stringArray.length; ++i) {
            if (!(class$net$sf$cglib$transform$impl$InterceptFieldEnabled == null ? CglibClassTransformer.class$("net.sf.cglib.transform.impl.InterceptFieldEnabled") : class$net$sf$cglib$transform$impl$InterceptFieldEnabled).getName().equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

