/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import org.hibernate.PropertyAccessException;
import org.hibernate.bytecode.ReflectionOptimizer;

public class AccessOptimizerAdapter
implements ReflectionOptimizer.AccessOptimizer,
Serializable {
    public static final String PROPERTY_GET_EXCEPTION = "exception getting property value with CGLIB (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    public static final String PROPERTY_SET_EXCEPTION = "exception setting property value with CGLIB (set hibernate.bytecode.use_reflection_optimizer=false for more info)";
    private Class mappedClass;
    private BulkBean bulkBean;

    public AccessOptimizerAdapter(BulkBean bulkBean, Class clazz) {
        this.bulkBean = bulkBean;
        this.mappedClass = clazz;
    }

    public String[] getPropertyNames() {
        return this.bulkBean.getGetters();
    }

    public Object[] getPropertyValues(Object object) {
        try {
            return this.bulkBean.getPropertyValues(object);
        }
        catch (Throwable throwable) {
            throw new PropertyAccessException(throwable, PROPERTY_GET_EXCEPTION, false, this.mappedClass, AccessOptimizerAdapter.getterName(throwable, this.bulkBean));
        }
    }

    public void setPropertyValues(Object object, Object[] objectArray) {
        try {
            this.bulkBean.setPropertyValues(object, objectArray);
        }
        catch (Throwable throwable) {
            throw new PropertyAccessException(throwable, PROPERTY_SET_EXCEPTION, true, this.mappedClass, AccessOptimizerAdapter.setterName(throwable, this.bulkBean));
        }
    }

    private static String setterName(Throwable throwable, BulkBean bulkBean) {
        if (throwable instanceof BulkBeanException) {
            return bulkBean.getSetters()[((BulkBeanException)throwable).getIndex()];
        }
        return "?";
    }

    private static String getterName(Throwable throwable, BulkBean bulkBean) {
        if (throwable instanceof BulkBeanException) {
            return bulkBean.getGetters()[((BulkBeanException)throwable).getIndex()];
        }
        return "?";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.mappedClass);
        objectOutputStream.writeObject(this.bulkBean.getGetters());
        objectOutputStream.writeObject(this.bulkBean.getSetters());
        objectOutputStream.writeObject(this.bulkBean.getPropertyTypes());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Class clazz = (Class)objectInputStream.readObject();
        String[] stringArray = (String[])objectInputStream.readObject();
        String[] stringArray2 = (String[])objectInputStream.readObject();
        Class[] classArray = (Class[])objectInputStream.readObject();
        this.bulkBean = BulkBean.create((Class)clazz, (String[])stringArray, (String[])stringArray2, (Class[])classArray);
    }
}

