/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode;

import java.io.InputStream;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.util.ByteCodeHelper;

public class InstrumentedClassLoader
extends ClassLoader {
    private ClassTransformer classTransformer;

    public InstrumentedClassLoader(ClassLoader classLoader, ClassTransformer classTransformer) {
        super(classLoader);
        this.classTransformer = classTransformer;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (string.startsWith("java.") || this.classTransformer == null) {
            return this.getParent().loadClass(string);
        }
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        InputStream inputStream = this.getResourceAsStream(string.replace('.', '/') + ".class");
        if (inputStream == null) {
            throw new ClassNotFoundException(string + " not found");
        }
        try {
            byte[] byArray = ByteCodeHelper.readByteCode(inputStream);
            byte[] byArray2 = this.classTransformer.transform(this.getParent(), string, null, null, byArray);
            if (byArray == byArray2) {
                return this.getParent().loadClass(string);
            }
            return this.defineClass(string, byArray2, 0, byArray2.length);
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(string + " not found", throwable);
        }
    }
}

