/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeFactory;

public final class EntityUpdateAction
extends EntityAction {
    private final Object[] state;
    private final Object[] previousState;
    private final Object previousVersion;
    private Object nextVersion;
    private final int[] dirtyFields;
    private final boolean hasDirtyCollection;
    private final Object rowId;
    private Object cacheEntry;
    private CacheConcurrencyStrategy.SoftLock lock;

    public EntityUpdateAction(Serializable serializable, Object[] objectArray, int[] nArray, boolean bl, Object[] objectArray2, Object object, Object object2, Object object3, Object object4, EntityPersister entityPersister, SessionImplementor sessionImplementor) throws HibernateException {
        super(sessionImplementor, serializable, object3, entityPersister);
        this.state = objectArray;
        this.previousState = objectArray2;
        this.previousVersion = object;
        this.nextVersion = object2;
        this.dirtyFields = nArray;
        this.hasDirtyCollection = bl;
        this.rowId = object4;
    }

    public void execute() throws HibernateException {
        EntityEntry entityEntry;
        CacheKey cacheKey;
        Serializable serializable = this.getId();
        EntityPersister entityPersister = this.getPersister();
        SessionImplementor sessionImplementor = this.getSession();
        Object object = this.getInstance();
        boolean bl = this.preUpdate();
        SessionFactoryImplementor sessionFactoryImplementor = this.getSession().getFactory();
        Object object2 = this.previousVersion;
        if (entityPersister.isVersionPropertyGenerated()) {
            object2 = entityPersister.getVersion(object, sessionImplementor.getEntityMode());
        }
        if (entityPersister.hasCache()) {
            cacheKey = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            this.lock = entityPersister.getCache().lock(cacheKey, object2);
        } else {
            cacheKey = null;
        }
        if (!bl) {
            entityPersister.update(serializable, this.state, this.dirtyFields, this.hasDirtyCollection, this.previousState, object2, object, this.rowId, sessionImplementor);
        }
        if ((entityEntry = this.getSession().getPersistenceContext().getEntry(object)) == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        if (entityEntry.getStatus() == Status.MANAGED || entityPersister.isVersionPropertyGenerated()) {
            TypeFactory.deepCopy(this.state, entityPersister.getPropertyTypes(), entityPersister.getPropertyCheckability(), this.state, sessionImplementor);
            if (entityPersister.hasUpdateGeneratedProperties()) {
                entityPersister.processUpdateGeneratedProperties(serializable, object, this.state, sessionImplementor);
                if (entityPersister.isVersionPropertyGenerated()) {
                    this.nextVersion = Versioning.getVersion(this.state, entityPersister);
                }
            }
            entityEntry.postUpdate(object, this.state, this.nextVersion);
        }
        if (entityPersister.hasCache()) {
            if (entityPersister.isCacheInvalidationRequired() || entityEntry.getStatus() != Status.MANAGED) {
                entityPersister.getCache().evict(cacheKey);
            } else {
                CacheEntry cacheEntry = new CacheEntry(this.state, entityPersister, entityPersister.hasUninitializedLazyProperties(object, sessionImplementor.getEntityMode()), this.nextVersion, this.getSession(), object);
                this.cacheEntry = entityPersister.getCacheEntryStructure().structure(cacheEntry);
                boolean bl2 = entityPersister.getCache().update(cacheKey, this.cacheEntry, this.nextVersion, object2);
                if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
                }
            }
        }
        this.postUpdate();
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled() && !bl) {
            sessionFactoryImplementor.getStatisticsImplementor().updateEntity(this.getPersister().getEntityName());
        }
    }

    private void postUpdate() {
        PostUpdateEventListener[] postUpdateEventListenerArray = this.getSession().getListeners().getPostUpdateEventListeners();
        if (postUpdateEventListenerArray.length > 0) {
            PostUpdateEvent postUpdateEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postUpdateEventListenerArray.length; ++i) {
                postUpdateEventListenerArray[i].onPostUpdate(postUpdateEvent);
            }
        }
    }

    private void postCommitUpdate() {
        PostUpdateEventListener[] postUpdateEventListenerArray = this.getSession().getListeners().getPostCommitUpdateEventListeners();
        if (postUpdateEventListenerArray.length > 0) {
            PostUpdateEvent postUpdateEvent = new PostUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), (EventSource)this.getSession());
            for (int i = 0; i < postUpdateEventListenerArray.length; ++i) {
                postUpdateEventListenerArray[i].onPostUpdate(postUpdateEvent);
            }
        }
    }

    private boolean preUpdate() {
        PreUpdateEventListener[] preUpdateEventListenerArray = this.getSession().getListeners().getPreUpdateEventListeners();
        boolean bl = false;
        if (preUpdateEventListenerArray.length > 0) {
            PreUpdateEvent preUpdateEvent = new PreUpdateEvent(this.getInstance(), this.getId(), this.state, this.previousState, this.getPersister(), this.getSession());
            for (int i = 0; i < preUpdateEventListenerArray.length; ++i) {
                bl = preUpdateEventListenerArray[i].onPreUpdate(preUpdateEvent) || bl;
            }
        }
        return bl;
    }

    public void afterTransactionCompletion(boolean bl) throws CacheException {
        EntityPersister entityPersister = this.getPersister();
        if (entityPersister.hasCache()) {
            CacheKey cacheKey = new CacheKey(this.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), this.getSession().getEntityMode(), this.getSession().getFactory());
            if (bl && this.cacheEntry != null) {
                boolean bl2 = entityPersister.getCache().afterUpdate(cacheKey, this.cacheEntry, this.nextVersion, this.lock);
                if (bl2 && this.getSession().getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getSession().getFactory().getStatisticsImplementor().secondLevelCachePut(this.getPersister().getCache().getRegionName());
                }
            } else {
                entityPersister.getCache().release(cacheKey, this.lock);
            }
        }
        this.postCommitUpdate();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitUpdateEventListeners().length > 0;
    }
}

